/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.UniqueIdSupplier;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.colors.StandardColors;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class Es6RewriteBlockScopedDeclaration
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Set<Node> letConsts = new LinkedHashSet<Node>();
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.LET_DECLARATIONS, FeatureSet.Feature.CONST_DECLARATIONS);
    private final UniqueIdSupplier uniqueIdSupplier;
    private static final String LOOP_PARAM_NAME_PREFIX = "$jscomp$loop_param$";
    private static final Predicate<Node> isLoopOrFunction = new Predicate<Node>(){

        public boolean apply(Node n) {
            return n.isFunction() || NodeUtil.isLoopStructure(n);
        }
    };

    public Es6RewriteBlockScopedDeclaration(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.uniqueIdSupplier = compiler.getUniqueIdSupplier();
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.hasChildren() || !NodeUtil.isBlockScopedDeclaration(n.getFirstChild())) {
            return;
        }
        Preconditions.checkState((parent == null || !parent.isForOf() ? 1 : 0) != 0, (Object)parent);
        if (n.isLet() || n.isConst()) {
            this.letConsts.add(n);
        }
        if (NodeUtil.isNameDeclaration(n)) {
            for (Node nameNode = n.getFirstChild(); nameNode != null; nameNode = nameNode.getNext()) {
                this.visitBlockScopedNameDeclaration(n, nameNode);
            }
        } else {
            Preconditions.checkState((n.isFunction() || n.isCatch() ? 1 : 0) != 0, (String)"Unexpected declaration node: %s", (Object)n);
            this.visitBlockScopedNameDeclaration(n, n.getFirstChild());
        }
    }

    @Override
    public void process(Node externs, Node root) {
        MakeDeclaredNamesUnique renamer = MakeDeclaredNamesUnique.builder().build();
        NodeTraversal.traverseRoots(this.compiler, renamer, externs, root);
        NodeTraversal.traverse(this.compiler, root, this);
        LoopClosureTransformer transformer = new LoopClosureTransformer();
        NodeTraversal.traverse(this.compiler, root, transformer);
        transformer.transformLoopClosure();
        this.rewriteDeclsToVars();
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, root, transpiledFeatures);
    }

    private void visitBlockScopedNameDeclaration(Node decl, Node nameNode) {
        Node parent = decl.getParent();
        if (!(!decl.isLet() && !decl.isConst() || nameNode.hasChildren() || parent != null && parent.isForIn() || !this.inLoop(decl))) {
            Node undefined = this.astFactory.createUndefinedValue().srcrefTree(nameNode);
            nameNode.addChildToFront(undefined);
            this.compiler.reportChangeToEnclosingScope(undefined);
        }
    }

    private boolean inLoop(Node n) {
        Node enclosingNode = NodeUtil.getEnclosingNode(n, isLoopOrFunction);
        return enclosingNode != null && !enclosingNode.isFunction();
    }

    private static void extractInlineJSDoc(Node srcDeclaration, Node srcName, Node destDeclaration) {
        JSDocInfo existingInfo = srcDeclaration.getJSDocInfo();
        if (existingInfo == null) {
            existingInfo = srcName.getJSDocInfo();
            srcName.setJSDocInfo(null);
        }
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(existingInfo);
        destDeclaration.setJSDocInfo(builder.build());
    }

    private static void maybeAddConstJSDoc(Node srcDeclaration, Node srcName, Node destDeclaration) {
        if (srcDeclaration.isConst()) {
            Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(srcDeclaration, srcName, destDeclaration);
            JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(destDeclaration.getJSDocInfo());
            builder.recordConstancy();
            destDeclaration.setJSDocInfo(builder.build());
        }
    }

    private void handleDeclarationList(Node declarationList, Node parent) {
        if (declarationList.isVar() && declarationList.hasOneChild()) {
            return;
        }
        if (parent.isVanillaFor()) {
            this.handleDeclarationListInVanillaForInitializer(declarationList, parent);
            return;
        }
        if (parent.isForIn()) {
            this.handleDeclarationListInForInInitializer(declarationList, parent);
            return;
        }
        while (declarationList.hasChildren()) {
            Node name = declarationList.getLastChild();
            Node newDeclaration = IR.var(name.detach()).srcref(declarationList);
            Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(declarationList, name, newDeclaration);
            Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declarationList, name, newDeclaration);
            newDeclaration.insertAfter(declarationList);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        declarationList.detach();
        this.compiler.reportChangeToEnclosingScope(parent);
    }

    private void handleDeclarationListInForInInitializer(Node declarationList, Node parent) {
        Preconditions.checkState((boolean)parent.isForIn());
        Node first = declarationList;
        Node lhs = first.getFirstChild();
        Node loopNode = parent;
        if (lhs.isDestructuringLhs()) {
            Preconditions.checkState((boolean)false, (Object)"Destructuring syntax is unsupported in ES6RewriteBlockScopedDeclarations pass");
            NodeUtil.visitLhsNodesInNode(lhs, name -> {
                Preconditions.checkState((boolean)name.isName(), (String)"lhs in destructuring declaration should be a simple name. (%s)", (Object)name);
                Node newName = IR.name(name.getString()).srcref((Node)name);
                Node newVar = IR.var(newName).srcref((Node)name);
                Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(declarationList, name, newVar);
                this.addNodeBeforeLoop(newVar, loopNode);
            });
            Node destructuringPattern = lhs.removeFirstChild();
            first.replaceWith(destructuringPattern);
        } else {
            Node newStatement = first.cloneTree();
            Node name2 = newStatement.getFirstChild().cloneNode();
            if (name2.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                name2.putProp(Node.IS_CONSTANT_NAME, false);
            }
            newStatement.setToken(Token.VAR);
            Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(first, first.getFirstChild(), newStatement);
            first.replaceWith(name2);
            this.addNodeBeforeLoop(newStatement, loopNode);
        }
    }

    private void handleDeclarationListInVanillaForInitializer(Node declarationList, Node parent) {
        Preconditions.checkState((boolean)parent.isVanillaFor());
        Node insertSpot = this.getInsertSpotBeforeLoop(parent);
        while (declarationList.hasChildren()) {
            Node name = declarationList.getLastChild();
            Node newDeclaration = IR.var(name.detach()).srcref(declarationList);
            Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(declarationList, name, newDeclaration);
            if (name.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                name.putProp(Node.IS_CONSTANT_NAME, false);
            }
            newDeclaration.insertBefore(insertSpot);
            insertSpot = newDeclaration;
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        Node empty = this.astFactory.createEmpty().srcref(declarationList);
        declarationList.replaceWith(empty);
        this.compiler.reportChangeToEnclosingScope(empty);
    }

    private void addNodeBeforeLoop(Node newNode, Node loopNode) {
        Node insertSpot = this.getInsertSpotBeforeLoop(loopNode);
        newNode.insertBefore(insertSpot);
        this.compiler.reportChangeToEnclosingScope(newNode);
    }

    private Node getInsertSpotBeforeLoop(Node loopNode) {
        Node insertSpot = loopNode;
        while (insertSpot.getParent().isLabel()) {
            insertSpot = insertSpot.getParent();
        }
        return insertSpot;
    }

    private void rewriteDeclsToVars() {
        if (!this.letConsts.isEmpty()) {
            for (Node n : this.letConsts) {
                this.handleDeclarationList(n, n.getParent());
            }
        }
    }

    private class LoopClosureTransformer
    extends NodeTraversal.AbstractPreOrderCallback {
        private static final String LOOP_OBJECT_NAME = "$jscomp$loop";
        private final Map<Node, LoopObject> loopObjectMap = new LinkedHashMap<Node, LoopObject>();
        private final SetMultimap<Node, LoopObject> nodesRequiringLoopObjectsClosureMap = LinkedHashMultimap.create();
        private final SetMultimap<Node, String> nodesHandledForLoopObjectClosure = HashMultimap.create();
        private final SetMultimap<Var, Node> referenceMap = LinkedHashMultimap.create();

        private LoopClosureTransformer() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return true;
            }
            String name = n.getString();
            Scope referencedIn = t.getScope();
            Var var = (Var)referencedIn.getVar(name);
            if (var == null) {
                return true;
            }
            if (!var.isLet() && !var.isConst()) {
                return true;
            }
            Scope declaredIn = (Scope)var.getScope();
            Node loopNode = null;
            Scope s = declaredIn;
            while (true) {
                Node scopeRoot;
                if (NodeUtil.isLoopStructure(scopeRoot = s.getRootNode())) {
                    loopNode = scopeRoot;
                    break;
                }
                if (scopeRoot.hasParent() && NodeUtil.isLoopStructure(scopeRoot.getParent())) {
                    loopNode = scopeRoot.getParent();
                    break;
                }
                if (s.isFunctionBlockScope() || s.isGlobal()) {
                    return true;
                }
                s = s.getParent();
            }
            this.referenceMap.put((Object)var, (Object)n);
            AbstractScope outerMostFunctionScope = null;
            for (Scope s2 = referencedIn; s2 != declaredIn && s2.getRootNode() != loopNode; s2 = s2.getParent()) {
                if (!s2.isFunctionScope()) continue;
                outerMostFunctionScope = s2;
            }
            if (outerMostFunctionScope != null) {
                Node nodeToWrapInClosure;
                Node enclosingFunction = outerMostFunctionScope.getRootNode();
                if (enclosingFunction.getParent().isGetterDef() || enclosingFunction.getParent().isSetterDef()) {
                    nodeToWrapInClosure = enclosingFunction.getGrandparent();
                    Preconditions.checkState((boolean)nodeToWrapInClosure.isObjectLit());
                } else {
                    nodeToWrapInClosure = enclosingFunction;
                }
                if (this.nodesHandledForLoopObjectClosure.containsEntry((Object)nodeToWrapInClosure, (Object)name)) {
                    return true;
                }
                this.nodesHandledForLoopObjectClosure.put((Object)nodeToWrapInClosure, (Object)name);
                LoopObject object = this.loopObjectMap.computeIfAbsent(loopNode, k -> new LoopObject(this.createUniqueObjectName(t.getInput())));
                object.vars.add(var);
                this.nodesRequiringLoopObjectsClosureMap.put((Object)nodeToWrapInClosure, (Object)object);
            }
            return true;
        }

        private String createUniqueObjectName(CompilerInput input) {
            return "$jscomp$loop$" + Es6RewriteBlockScopedDeclaration.this.uniqueIdSupplier.getUniqueId(input);
        }

        private String getLoopObjPropName(Var var) {
            return var.getNameNode().getString();
        }

        private void transformLoopClosure() {
            if (this.loopObjectMap.isEmpty()) {
                return;
            }
            Set<Node> wrapperFunctions = this.createWrapperFunctions();
            for (Node loopNode : this.loopObjectMap.keySet()) {
                LoopObject loopObject = this.loopObjectMap.get(loopNode);
                Node objectLitNextIteration = Es6RewriteBlockScopedDeclaration.this.astFactory.createObjectLit(new Node[0]);
                this.renameVarsToProperties(loopObject, objectLitNextIteration);
                Node updateLoopObject = Es6RewriteBlockScopedDeclaration.this.astFactory.createAssign(this.createLoopObjectNameNode(loopObject), objectLitNextIteration);
                Node objectLit = IR.var(this.createLoopObjectNameNode(loopObject), Es6RewriteBlockScopedDeclaration.this.astFactory.createObjectLit(new Node[0])).srcrefTree(loopNode);
                Es6RewriteBlockScopedDeclaration.this.addNodeBeforeLoop(objectLit, loopNode);
                if (loopNode.isVanillaFor()) {
                    this.changeVanillaForLoopHeader(loopNode, updateLoopObject);
                } else {
                    Node loopBody = NodeUtil.getLoopCodeBlock(loopNode);
                    loopBody.addChildToFront(IR.exprResult(updateLoopObject).srcrefTreeIfMissing(loopNode));
                }
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(loopNode);
                this.changeLoopLocalVariablesToProperties(loopNode, loopObject);
            }
            this.updateNamesInWrapperFunctions(wrapperFunctions);
        }

        private void updateNamesInWrapperFunctions(Set<Node> wrapperFunctions) {
            for (Node func : wrapperFunctions) {
                Node paramList = func.getSecondChild();
                for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
                    String loopObjectName = param.getString().substring(0, param.getString().indexOf(Es6RewriteBlockScopedDeclaration.LOOP_PARAM_NAME_PREFIX));
                    this.updateNames(func.getLastChild(), param, loopObjectName);
                }
            }
        }

        private Set<Node> createWrapperFunctions() {
            LinkedHashSet<Node> wrapperFunctions = new LinkedHashSet<Node>();
            for (Node functionOrObjectLit : this.nodesRequiringLoopObjectsClosureMap.keySet()) {
                Node returnNode = IR.returnNode();
                Set objects = this.nodesRequiringLoopObjectsClosureMap.get((Object)functionOrObjectLit);
                Node[] parameterNames = new Node[objects.size()];
                Node[] objectNamesForCall = new Node[objects.size()];
                int loopObjectIndex = 0;
                for (LoopObject object : objects) {
                    parameterNames[loopObjectIndex] = this.createUniqueParameterNameToUseWithinLoop(functionOrObjectLit, object);
                    objectNamesForCall[loopObjectIndex] = this.createLoopObjectNameNode(object);
                    ++loopObjectIndex;
                }
                Node iife = Es6RewriteBlockScopedDeclaration.this.astFactory.createFunction("", IR.paramList(parameterNames), IR.block(returnNode), AstFactory.type(StandardColors.TOP_OBJECT));
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToChangeScope(iife);
                Node call = Es6RewriteBlockScopedDeclaration.this.astFactory.createCall(iife, AstFactory.type(functionOrObjectLit), objectNamesForCall);
                call.putBooleanProp(Node.FREE_CALL, true);
                Preconditions.checkState((!NodeUtil.isFunctionDeclaration(functionOrObjectLit) ? 1 : 0) != 0, (String)"block-scoped function declarations should not exist now: %s", (Object)functionOrObjectLit);
                Node replacement = call.srcrefTreeIfMissing(functionOrObjectLit);
                functionOrObjectLit.replaceWith(replacement);
                wrapperFunctions.add(iife);
                returnNode.addChildToFront(functionOrObjectLit);
                Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(replacement);
            }
            return wrapperFunctions;
        }

        private void updateNames(Node node, Node paramName, String loopObjectName) {
            if (node.isName() && !node.getString().isEmpty() && node.getString().contains(loopObjectName)) {
                node.setString(paramName.getString());
                return;
            }
            for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                this.updateNames(child, paramName, loopObjectName);
            }
        }

        private void changeVanillaForLoopHeader(Node loopNode, Node updateLoopObject) {
            Node increment;
            Node initializer = loopNode.getFirstChild();
            initializer.replaceWith(IR.empty());
            if (!initializer.isEmpty()) {
                if (!NodeUtil.isNameDeclaration(initializer)) {
                    initializer = IR.exprResult(initializer).srcref(initializer);
                }
                Es6RewriteBlockScopedDeclaration.this.addNodeBeforeLoop(initializer, loopNode);
            }
            if ((increment = loopNode.getChildAtIndex(2)).isEmpty()) {
                increment.replaceWith(updateLoopObject.srcrefTreeIfMissing(loopNode));
            } else {
                Node placeHolder = IR.empty();
                increment.replaceWith(placeHolder);
                placeHolder.replaceWith(Es6RewriteBlockScopedDeclaration.this.astFactory.createComma(updateLoopObject, increment).srcrefTreeIfMissing(loopNode));
            }
        }

        private void changeLoopLocalVariablesToProperties(Node loopNode, LoopObject loopObject) {
            for (Var var : loopObject.vars) {
                String newPropertyName = this.getLoopObjPropName(var);
                for (Node reference : this.referenceMap.get((Object)var)) {
                    Preconditions.checkState((!loopNode.isForOf() ? 1 : 0) != 0, (Object)loopNode);
                    if (loopNode.isForIn() && loopNode.getFirstChild() == reference.getParent()) {
                        this.assignLoopVarToLoopObjectProperty(loopNode, loopObject, var, newPropertyName, reference);
                        continue;
                    }
                    if (NodeUtil.isNameDeclaration(reference.getParent())) {
                        this.replaceDeclarationWithProperty(loopObject, newPropertyName, reference);
                        continue;
                    }
                    this.replaceReferenceWithProperty(loopObject, newPropertyName, reference);
                }
            }
        }

        private void replaceDeclarationWithProperty(LoopObject loopObject, String newPropertyName, Node reference) {
            Node declaration = reference.getParent();
            Node grandParent = declaration.getParent();
            Es6RewriteBlockScopedDeclaration.this.letConsts.remove(declaration);
            Es6RewriteBlockScopedDeclaration.this.handleDeclarationList(declaration, grandParent);
            declaration = reference.getParent();
            if (reference.hasChildren()) {
                Node newReference = this.createLoopVarReferenceReplacement(loopObject, reference, newPropertyName);
                Node assign = Es6RewriteBlockScopedDeclaration.this.astFactory.createAssign(newReference, reference.removeFirstChild());
                Es6RewriteBlockScopedDeclaration.extractInlineJSDoc(declaration, reference, declaration);
                Es6RewriteBlockScopedDeclaration.maybeAddConstJSDoc(declaration, reference, declaration);
                assign.setJSDocInfo(declaration.getJSDocInfo());
                Node replacement = IR.exprResult(assign).srcrefTreeIfMissing(declaration);
                declaration.replaceWith(replacement);
            } else {
                declaration.detach();
            }
            Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(grandParent);
        }

        private void replaceReferenceWithProperty(LoopObject loopObject, String newPropertyName, Node reference) {
            Node referenceParent = reference.getParent();
            reference.replaceWith(this.createLoopVarReferenceReplacement(loopObject, reference, newPropertyName));
            Es6RewriteBlockScopedDeclaration.this.compiler.reportChangeToEnclosingScope(referenceParent);
        }

        private void assignLoopVarToLoopObjectProperty(Node loopNode, LoopObject loopObject, Var var, String newPropertyName, Node reference) {
            Preconditions.checkState((reference == var.getNameNode() ? 1 : 0) != 0, (Object)reference);
            Node referenceParent = reference.getParent();
            Preconditions.checkState((boolean)NodeUtil.isNameDeclaration(referenceParent), (Object)referenceParent);
            Preconditions.checkState((boolean)reference.isName(), (Object)reference);
            Node loopVarReference = reference.cloneNode();
            Node forInPropAssignmentStatemnt = IR.exprResult(Es6RewriteBlockScopedDeclaration.this.astFactory.createAssign(this.createLoopVarReferenceReplacement(loopObject, reference, newPropertyName), loopVarReference)).srcrefTreeIfMissing(reference);
            Node loopUpdateStatement = loopNode.getLastChild().getFirstChild();
            forInPropAssignmentStatemnt.insertAfter(loopUpdateStatement);
        }

        private void renameVarsToProperties(LoopObject loopObject, Node objectLitNextIteration) {
            for (Var var : loopObject.vars) {
                String newPropertyName = this.getLoopObjPropName(var);
                objectLitNextIteration.addChildToBack(Es6RewriteBlockScopedDeclaration.this.astFactory.createStringKey(newPropertyName, this.createLoopVarReferenceReplacement(loopObject, var.getNameNode(), newPropertyName)));
            }
        }

        private Node createLoopVarReferenceReplacement(LoopObject loopObject, Node reference, String propertyName) {
            Node replacement = Es6RewriteBlockScopedDeclaration.this.astFactory.createGetProp(this.createLoopObjectNameNode(loopObject), propertyName, AstFactory.type(reference));
            replacement.srcrefTree(reference);
            return replacement;
        }

        private Node createUniqueParameterNameToUseWithinLoop(Node node, LoopObject loopObject) {
            return Es6RewriteBlockScopedDeclaration.this.astFactory.createName(loopObject.name + Es6RewriteBlockScopedDeclaration.LOOP_PARAM_NAME_PREFIX + Es6RewriteBlockScopedDeclaration.this.uniqueIdSupplier.getUniqueId(Es6RewriteBlockScopedDeclaration.this.compiler.getInput(NodeUtil.getInputId(node))), AstFactory.type(StandardColors.TOP_OBJECT));
        }

        private Node createLoopObjectNameNode(LoopObject loopObject) {
            return Es6RewriteBlockScopedDeclaration.this.astFactory.createName(loopObject.name, AstFactory.type(StandardColors.TOP_OBJECT));
        }

        private class LoopObject {
            private final String name;
            private final Set<Var> vars = new LinkedHashSet<Var>();

            private LoopObject(String name) {
                this.name = name;
            }
        }
    }
}

