/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6RenameReferences;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class Es6RenameVariablesInParamLists
implements NodeTraversal.ScopedCallback,
CompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.DEFAULT_PARAMETERS, FeatureSet.Feature.COMPUTED_PROPERTIES);

    public Es6RenameVariablesInParamLists(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void enterScope(NodeTraversal t) {
    }

    @Override
    public void exitScope(NodeTraversal t) {
        Node block = t.getScopeRoot();
        Node function = block.getParent();
        if (!block.isBlock() || !function.isFunction()) {
            return;
        }
        CollectReferences collector = new CollectReferences();
        collector.collect(function);
        Scope blockScope = t.getScope();
        HashBasedTable renameTable = HashBasedTable.create();
        Map renameRow = renameTable.row((Object)block);
        for (Var var : blockScope.getVarIterable()) {
            String oldName = var.getName();
            if (!collector.currFuncReferences.contains(oldName)) continue;
            renameRow.computeIfAbsent(oldName, x -> oldName + "$" + this.compiler.getUniqueNameIdSupplier().get());
        }
        NodeTraversal.builder().setCompiler(this.compiler).setScopeCreator(t.getScopeCreator()).setCallback(new Es6RenameReferences((Table<Node, String, String>)renameTable)).traverseAtScope(blockScope);
    }

    @Override
    public void visit(NodeTraversal t, Node block, Node function) {
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
    }

    private static class CollectReferences {
        private final Set<String> currFuncReferences = new LinkedHashSet<String>();

        private CollectReferences() {
        }

        void collect(Node fn) {
            Preconditions.checkState((boolean)fn.isFunction());
            Node paramList = fn.getSecondChild();
            this.findCandiates(paramList);
        }

        void findCandiates(Node n) {
            Node parent = n.getParent();
            if (parent.isDefaultValue() && n == parent.getLastChild() || parent.isComputedProp() && n == parent.getFirstChild()) {
                this.visitCandiates(n);
                return;
            }
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                this.visitCandiates(c);
            }
        }

        void visitCandiates(Node n) {
            if (NodeUtil.isReferenceName(n)) {
                this.currFuncReferences.add(n.getString());
            }
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                this.visitCandiates(c);
            }
        }
    }
}

