/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.Keep;
import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.AllowlistWarningsGuard;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ChromeCodingConvention;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.EmptyMessageBundle;
import com.google.javascript.jscomp.FlagUsageException;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.PolymerExportPolicy;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WarningLevel;
import com.google.javascript.jscomp.XtbMessageBundle;
import com.google.javascript.jscomp.deps.ClosureBundler;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.transpile.BaseTranspiler;
import com.google.javascript.jscomp.transpile.Transpiler;
import com.google.javascript.rhino.TokenStream;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.StringOptionHandler;

@GwtIncompatible(value="Unnecessary")
public class CommandLineRunner
extends AbstractCommandLineRunner<Compiler, CompilerOptions> {
    public static final String OUTPUT_MARKER = "%output%";
    public static final int UTF8_BOM_CODE = 65279;
    private static final Pattern extraChunkNameChars = Pattern.compile("[-.]+");
    private final Flags flags = new Flags();
    private boolean errors = false;
    private boolean runCompiler = false;
    private @Nullable PrintStream errorStream;
    private ClosureBundler bundler;
    private static final Logger phaseLogger = Logger.getLogger(PhaseOptimizer.class.getName());

    protected CommandLineRunner(String[] args) {
        this.initConfigFromFlags(args, System.out, System.err);
    }

    protected CommandLineRunner(String[] args, PrintStream out, PrintStream err) {
        super(out, err);
        this.initConfigFromFlags(args, out, err);
    }

    protected CommandLineRunner(String[] args, InputStream in, PrintStream out, PrintStream err) {
        super(in, out, err);
        this.initConfigFromFlags(args, out, err);
    }

    private static List<String> processArgs(String[] args) {
        Pattern argPattern = Pattern.compile("(--?[a-zA-Z_]+)=(.*)", 32);
        Pattern quotesPattern = Pattern.compile("^['\"](.*)['\"]$");
        ArrayList<String> processedArgs = new ArrayList<String>();
        for (String arg : args) {
            Matcher matcher = argPattern.matcher(arg);
            if (matcher.matches()) {
                processedArgs.add(matcher.group(1));
                String value = matcher.group(2);
                Matcher quotesMatcher = quotesPattern.matcher(value);
                if (quotesMatcher.matches()) {
                    processedArgs.add(quotesMatcher.group(1));
                    continue;
                }
                processedArgs.add(value);
                continue;
            }
            processedArgs.add(arg);
        }
        return processedArgs;
    }

    private void reportError(String message) {
        this.errors = true;
        this.errorStream.println(message);
        this.errorStream.flush();
    }

    private void processFlagFiles() throws CmdLineException {
        for (String flagFile : this.flags.flagFiles) {
            try {
                this.processFlagFile(flagFile);
            }
            catch (IOException ioErr) {
                this.reportError("ERROR - " + flagFile + " read error.");
            }
        }
    }

    private void processFlagFile(String flagFileString) throws CmdLineException, IOException {
        int c;
        Path flagFile = Paths.get(flagFileString, new String[0]);
        BufferedReader buffer = Files.newBufferedReader(flagFile, StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        ArrayList<String> tokens = new ArrayList<String>();
        boolean quoted = false;
        boolean escaped = false;
        boolean isFirstCharacter = true;
        while ((c = buffer.read()) != -1) {
            if (isFirstCharacter) {
                isFirstCharacter = false;
                if (c == 65279) continue;
            }
            if (c == 32 || c == 9 || c == 10 || c == 13) {
                if (quoted) {
                    builder.append((char)c);
                } else if (builder.length() != 0) {
                    tokens.add(builder.toString());
                    builder.setLength(0);
                }
            } else if (c == 34) {
                if (escaped) {
                    if (quoted) {
                        builder.setCharAt(builder.length() - 1, (char)c);
                    } else {
                        builder.append((char)c);
                    }
                } else {
                    quoted = !quoted;
                }
            } else {
                builder.append((char)c);
            }
            escaped = c == 92;
        }
        buffer.close();
        if (builder.length() != 0) {
            tokens.add(builder.toString());
        }
        this.flags.flagFiles = new ArrayList<String>();
        tokens = CommandLineRunner.processArgs(tokens.toArray(new String[0]));
        ArrayList<AbstractCommandLineRunner.FlagEntry<CheckLevel>> previousGuardLevels = new ArrayList<AbstractCommandLineRunner.FlagEntry<CheckLevel>>(Flags.guardLevels);
        ArrayList<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> previousMixedJsSources = new ArrayList<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>>(Flags.mixedJsSources);
        Flags.guardLevels.clear();
        Flags.mixedJsSources.clear();
        this.flags.parse(tokens);
        Flags.guardLevels.addAll(previousGuardLevels);
        Flags.mixedJsSources.addAll(previousMixedJsSources);
        if (!this.flags.flagFiles.isEmpty()) {
            this.reportError("ERROR - Arguments in the file cannot contain --flagfile option.");
        }
    }

    @Override
    protected final String getVersionText() {
        return String.join((CharSequence)"\n", "Closure Compiler (http://github.com/google/closure-compiler)", "Version: v20231112");
    }

    private void initConfigFromFlags(String[] args, PrintStream out, PrintStream err) {
        this.errorStream = err;
        List<String> processedArgs = CommandLineRunner.processArgs(args);
        Flags.guardLevels.clear();
        Flags.mixedJsSources.clear();
        List<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> mixedSources = null;
        List<SourceMap.LocationMapping> mappings = null;
        ImmutableMap<String, String> sourceMapInputs = null;
        boolean parseInlineSourceMaps = false;
        boolean applyInputSourceMaps = false;
        try {
            this.flags.parse(processedArgs);
            this.processFlagFiles();
            mixedSources = this.flags.getMixedJsSources();
            mappings = this.flags.getSourceMapLocationMappings();
            sourceMapInputs = this.flags.getSourceMapInputs();
            parseInlineSourceMaps = this.flags.parseInlineSourceMaps;
            applyInputSourceMaps = this.flags.applyInputSourceMaps;
        }
        catch (CmdLineException e) {
            this.reportError(e.getMessage());
        }
        catch (IOException ioErr) {
            this.reportError("ERROR - ioException: " + ioErr);
        }
        if (this.flags.processCommonJsModules) {
            this.flags.processClosurePrimitives = true;
        }
        if (this.flags.browserFeaturesetYear != 0 && this.flags.languageOut != "ECMASCRIPT_NEXT") {
            throw new FlagUsageException("ERROR - both flags `--browser_featureset_year` and `--language_out` specified.");
        }
        if (this.flags.outputWrapper == null) {
            this.flags.outputWrapper = "";
        }
        if (this.flags.outputWrapperFile != null && !this.flags.outputWrapperFile.isEmpty()) {
            try {
                this.flags.outputWrapper = com.google.common.io.Files.asCharSource((File)new File(this.flags.outputWrapperFile), (Charset)StandardCharsets.UTF_8).read();
            }
            catch (Exception e) {
                this.reportError("ERROR - invalid output_wrapper_file specified.");
            }
        }
        if (!this.flags.outputWrapper.isEmpty() && !this.flags.outputWrapper.contains(OUTPUT_MARKER)) {
            this.reportError("ERROR - invalid output_wrapper specified. Missing '%output%'.");
        }
        if (!this.flags.outputWrapper.isEmpty() && this.flags.isolationMode != CompilerOptions.IsolationMode.NONE) {
            this.reportError("--output_wrapper and --isolation_mode may not be used together.");
        }
        if (this.flags.isolationMode == CompilerOptions.IsolationMode.IIFE) {
            this.flags.outputWrapper = "(function(){%output%}).call(this);";
        }
        ImmutableList bundleFiles = ImmutableList.of();
        boolean skipNormalOutputs = false;
        if (this.flags.compilationLevelParsed == CompilationLevel.BUNDLE) {
            if (this.flags.jsOutputFile.isEmpty()) {
                this.reportError("--compilation_level=BUNDLE cannot be used without a --js_output_file.");
            } else {
                bundleFiles = ImmutableList.of((Object)this.flags.jsOutputFile);
                this.flags.jsOutputFile = "";
                skipNormalOutputs = true;
            }
        }
        CodingConvention conv = this.flags.thirdParty ? CodingConventions.getDefault() : (this.flags.chromePass ? new ChromeCodingConvention() : new ClosureCodingConvention());
        if (!this.flags.renaming && this.flags.compilationLevelParsed == CompilationLevel.ADVANCED_OPTIMIZATIONS) {
            this.reportError("ERROR - renaming cannot be disabled when ADVANCED_OPTIMIZATIONS is used.");
        }
        DependencyOptions dependencyOptions = null;
        try {
            dependencyOptions = DependencyOptions.fromFlags(this.flags.dependencyMode, this.flags.entryPoint, (List<String>)ImmutableList.of(), null, false, false);
        }
        catch (FlagUsageException e) {
            this.reportError(e.getMessage());
        }
        if (this.errors) {
            Flags.printShortUsageAfterErrors(this.errorStream);
        } else if (this.flags.displayHelp || this.flags.helpMarkdown) {
            this.flags.printUsage(out);
        } else {
            this.runCompiler = true;
            AbstractCommandLineRunner.CommandLineConfig config = this.getCommandLineConfig();
            config.setPrintVersion(this.flags.version).setPrintTree(this.flags.printTree).setPrintTreeJson(this.flags.printTreeJson).setPrintAst(this.flags.printAst).setJscompDevMode(this.flags.jscompDevMode).setLoggingLevel(this.flags.loggingLevel).setExterns(this.flags.externs).setMixedJsSources(mixedSources).setDefaultToStdin().setJsOutputFile(this.flags.jsOutputFile).setModule(this.flags.chunk).setVariableMapOutputFile(this.flags.variableMapOutputFile).setCreateNameMapFiles(this.flags.createNameMapFiles).setPropertyMapOutputFile(this.flags.propertyMapOutputFile).setInstrumentationMappingFile(this.flags.instrumentationMappingOutputFile).setCodingConvention(conv).setSummaryDetailLevel(this.flags.summaryDetailLevel).setOutputWrapper(this.flags.outputWrapper).setModuleWrapper(this.flags.chunkWrapper).setModuleOutputPathPrefix(this.flags.chunkOutputPathPrefix).setCreateSourceMap(this.flags.createSourceMap).setSourceMapFormat(this.flags.sourceMapFormat).setSourceMapLocationMappings(mappings).setSourceMapInputFiles((Map<String, String>)sourceMapInputs).setParseInlineSourceMaps(parseInlineSourceMaps).setApplyInputSourceMaps(applyInputSourceMaps).setWarningGuards(Flags.guardLevels).setDefine(this.flags.define).setBrowserFeaturesetYear(this.flags.browserFeaturesetYear).setEmitAsyncFunctionsWithZonejs(this.flags.emitAsyncFunctionsWithZonejs).setCharset(this.flags.charset).setDependencyOptions(dependencyOptions).setOutputManifest((List<String>)ImmutableList.of((Object)this.flags.outputManifest)).setOutputBundle((List<String>)bundleFiles).setSkipNormalOutputs(skipNormalOutputs).setOutputModuleDependencies(this.flags.outputChunkDependencies).setProcessCommonJSModules(this.flags.processCommonJsModules).setModuleRoots(this.flags.moduleRoot).setWarningsAllowlistFile(this.flags.warningsAllowlistFile).setHideWarningsFor(this.flags.hideWarningsFor).setAngularPass(this.flags.angularPass).setJsonStreamMode(this.flags.jsonStreamMode).setErrorFormat(this.flags.errorFormat);
            String stage1RestoreFile = this.flags.restoreStage1FromFile;
            if (stage1RestoreFile == null) {
                stage1RestoreFile = this.flags.continueSavedCompilationFile;
            }
            if (stage1RestoreFile != null) {
                config.setContinueSavedCompilationFileName(stage1RestoreFile, 1);
            }
            String stage2RestoreFile = this.flags.restoreStage2FromFile;
            if (stage1RestoreFile != null) {
                Preconditions.checkState((stage2RestoreFile == null ? 1 : 0) != 0, (Object)"cannot restore both from stage 1 and from stage 2");
                config.setContinueSavedCompilationFileName(stage1RestoreFile, 1);
            } else if (stage2RestoreFile != null) {
                config.setContinueSavedCompilationFileName(stage2RestoreFile, 2);
            }
            String stage1SaveFile = this.flags.saveStage1ToFile;
            if (stage1SaveFile == null) {
                stage1SaveFile = this.flags.saveAfterChecksFile;
            }
            String stage2SaveFile = this.flags.saveStage2ToFile;
            if (stage1SaveFile != null) {
                Preconditions.checkState((stage2SaveFile == null ? 1 : 0) != 0, (Object)"cannot save both stage 1 and stage 2");
                Preconditions.checkState((stage1RestoreFile == null ? 1 : 0) != 0, (Object)"cannot perform stage 1 on a restored stage 1");
                config.setSaveCompilationStateToFilename(stage1SaveFile, 1);
            } else if (stage2SaveFile != null) {
                Preconditions.checkState((stage2RestoreFile == null ? 1 : 0) != 0, (Object)"Cannot perform stage 2 on a restored stage 2");
                Preconditions.checkState((stage1RestoreFile != null ? 1 : 0) != 0, (Object)"Saving stage 2 requires restoring from stage 1");
                config.setSaveCompilationStateToFilename(stage2SaveFile, 2);
            }
        }
        this.errorStream = null;
    }

    @Override
    protected void addAllowlistWarningsGuard(CompilerOptions options, File allowlistFile) {
        options.addWarningsGuard(AllowlistWarningsGuard.fromFile(allowlistFile));
    }

    @Override
    protected void checkModuleName(String name) {
        if (!TokenStream.isJSIdentifier(extraChunkNameChars.matcher(name).replaceAll("_"))) {
            throw new FlagUsageException("Invalid chunk name: '" + name + "'");
        }
    }

    @Override
    protected CompilerOptions createOptions() {
        CompilerOptions.LanguageMode languageMode;
        CompilerOptions options = new CompilerOptions();
        if (!this.flags.languageIn.isEmpty()) {
            languageMode = CompilerOptions.LanguageMode.fromString(this.flags.languageIn);
            if (languageMode == CompilerOptions.LanguageMode.UNSUPPORTED) {
                throw new FlagUsageException("Cannot specify the unsupported set of features for language_in.");
            }
            if (languageMode != null) {
                options.setLanguageIn(languageMode);
            } else {
                throw new FlagUsageException("Unknown language `" + this.flags.languageIn + "' specified.");
            }
        }
        if ((languageMode = CompilerOptions.LanguageMode.fromString(this.flags.languageOut)) == CompilerOptions.LanguageMode.UNSUPPORTED) {
            throw new FlagUsageException("Cannot specify the unsupported set of features for language_out.");
        }
        if (languageMode == null) {
            throw new FlagUsageException("Unknown language `" + this.flags.languageOut + "' specified.");
        }
        options.setLanguageOut(languageMode);
        options.setCodingConvention(new ClosureCodingConvention());
        options.setExtraAnnotationNames(this.flags.extraAnnotationName);
        CompilationLevel level = this.flags.compilationLevelParsed;
        level.setOptionsForCompilationLevel(options);
        if (this.flags.debug) {
            level.setDebugOptionsForCompilationLevel(options);
        }
        options.setNumParallelThreads(this.flags.numParallelThreads);
        options.setEnvironment(this.flags.environment);
        options.setChecksOnly(this.flags.checksOnly);
        if (this.flags.checksOnly) {
            options.setOutputJs(CompilerOptions.OutputJs.NONE);
        }
        options.setIncrementalChecks(this.flags.incrementalCheckMode);
        options.setContinueAfterErrors(this.flags.continueAfterErrors);
        options.setBadRewriteModulesBeforeTypecheckingThatWeWantToGetRidOf(true);
        if (this.flags.useTypesForOptimization) {
            level.setTypeBasedOptimizationOptions(options);
        }
        if (this.flags.assumeFunctionWrapper || this.flags.isolationMode == CompilerOptions.IsolationMode.IIFE || this.flags.chunkOutputType == CompilerOptions.ChunkOutputType.ES_MODULES) {
            level.setWrappedOutputOptimizations(options);
        }
        if (this.flags.typedAstOutputFile != null) {
            options.setTypedAstOutputFile(Paths.get(this.flags.typedAstOutputFile, new String[0]));
        }
        options.setGenerateExports(this.flags.generateExports);
        options.setExportLocalPropertyDefinitions(this.flags.exportLocalPropertyDefinitions);
        WarningLevel wLevel = this.flags.warningLevel;
        wLevel.setOptionsForWarningLevel(options);
        for (FormattingOption formattingOption : this.flags.formatting) {
            formattingOption.applyToOptions(options);
        }
        options.closurePass = this.flags.processClosurePrimitives;
        options.angularPass = this.flags.angularPass;
        options.polymerVersion = this.flags.polymerVersion;
        try {
            options.polymerExportPolicy = PolymerExportPolicy.valueOf(Ascii.toUpperCase((String)this.flags.polymerExportPolicy));
        }
        catch (IllegalArgumentException ex) {
            throw new FlagUsageException("Unknown PolymerExportPolicy `" + this.flags.polymerExportPolicy + "' specified.");
        }
        options.setChromePass(this.flags.chromePass);
        if (!this.flags.j2clPassMode.isEmpty()) {
            try {
                CompilerOptions.J2clPassMode j2clPassMode = CompilerOptions.J2clPassMode.valueOf(Ascii.toUpperCase((String)this.flags.j2clPassMode));
                options.setJ2clPass(j2clPassMode);
            }
            catch (IllegalArgumentException ex) {
                throw new FlagUsageException("Unknown J2clPassMode `" + this.flags.j2clPassMode + "' specified.");
            }
        }
        options.removeJ2clAsserts = this.flags.removeJ2cLAsserts;
        options.renamePrefix = this.flags.renamePrefix;
        options.renamePrefixNamespace = this.flags.renamePrefixNamespace;
        options.setPreserveTypeAnnotations(this.flags.preserveTypeAnnotations);
        options.setPreventLibraryInjection(!this.flags.injectLibraries);
        if (!this.flags.forceInjectLibraries.isEmpty()) {
            options.setForceLibraryInjection(this.flags.forceInjectLibraries);
        }
        options.rewritePolyfills = this.flags.rewritePolyfills && options.getLanguageIn().toFeatureSet().contains(FeatureSet.ES2015);
        options.setIsolatePolyfills(this.flags.isolatePolyfills);
        if (!this.flags.translationsFile.isEmpty()) {
            try {
                options.messageBundle = new XtbMessageBundle(new FileInputStream(this.flags.translationsFile), this.flags.translationsProject);
            }
            catch (IOException e) {
                throw new RuntimeException("Reading XTB file", e);
            }
        } else if (CompilationLevel.ADVANCED_OPTIMIZATIONS == level) {
            options.messageBundle = new EmptyMessageBundle();
            options.setWarningLevel(DiagnosticGroups.MSG_CONVENTIONS, CheckLevel.OFF);
        }
        options.setConformanceConfigs((List<ConformanceConfig>)CommandLineRunner.loadConformanceConfigs(this.flags.conformanceConfigs));
        options.setPrintSourceAfterEachPass(this.flags.printSourceAfterEachPass);
        options.setTracerMode(this.flags.tracerMode);
        options.setStrictModeInput(this.flags.strictModeInput);
        options.setEmitUseStrict(this.flags.emitUseStrict);
        options.setSourceMapIncludeSourcesContent(this.flags.sourceMapIncludeSourcesContent);
        options.setModuleResolutionMode(this.flags.moduleResolutionMode);
        options.setBrowserResolverPrefixReplacements((ImmutableMap<String, String>)ImmutableMap.copyOf(this.flags.browserResolverPrefixReplacements));
        if (this.flags.packageJsonEntryNames != null) {
            try {
                List<String> packageJsonEntryNames = this.flags.getPackageJsonEntryNames();
                options.setPackageJsonEntryNames(packageJsonEntryNames);
            }
            catch (CmdLineException e) {
                this.reportError("ERROR - invalid package_json_entry_names format specified.");
            }
        }
        if (!this.flags.renaming) {
            options.setVariableRenaming(VariableRenamingPolicy.OFF);
            options.setPropertyRenaming(PropertyRenamingPolicy.OFF);
        }
        if (this.flags.instrumentCodeParsed == CompilerOptions.InstrumentOption.PRODUCTION && Strings.isNullOrEmpty((String)this.flags.instrumentationMappingOutputFile)) {
            throw new FlagUsageException("Expected --instrument_mapping_report to be set when --instrument_for_coverage_option is set to Production");
        }
        if (!Strings.isNullOrEmpty((String)this.flags.instrumentationMappingOutputFile) && this.flags.instrumentCodeParsed != CompilerOptions.InstrumentOption.PRODUCTION) {
            throw new FlagUsageException("Expected --instrument_for_coverage_option to be passed with PRODUCTION when --instrument_mapping_report is set");
        }
        if (Strings.isNullOrEmpty((String)this.flags.productionInstrumentationArrayName) && this.flags.instrumentCodeParsed == CompilerOptions.InstrumentOption.PRODUCTION) {
            throw new FlagUsageException("Expected --production_instrumentation_array_name to be set when --instrument_for_coverage_option is set to Production");
        }
        options.setInstrumentForCoverageOption(this.flags.instrumentCodeParsed);
        options.setProductionInstrumentationArrayName(this.flags.productionInstrumentationArrayName);
        options.setAllowDynamicImport(this.flags.allowDynamicImport);
        options.setDynamicImportAlias(this.flags.dynamicImportAlias);
        options.setAssumeStaticInheritanceIsNotUsed(this.flags.assumeStaticInheritanceIsNotUsed);
        options.setCrossChunkCodeMotionNoStubMethods(this.flags.assumeNoPrototypeMethodEnumeration);
        if (this.flags.chunkOutputType == CompilerOptions.ChunkOutputType.ES_MODULES) {
            if (this.flags.renamePrefixNamespace != null) {
                throw new FlagUsageException("Expected --rename_prefix_namespace not to be specified when --chunk_output_type is set to ES_MODULES.");
            }
            if (this.flags.emitUseStrict) {
                throw new FlagUsageException("Expected --emit_use_strict should not be specified when --chunk_output_type is set to ES_MODULES.");
            }
            options.chunkOutputType = this.flags.chunkOutputType;
            options.setEmitUseStrict(false);
            if (level == CompilationLevel.ADVANCED_OPTIMIZATIONS) {
                options.setExtractPrototypeMemberDeclarations(CompilerOptions.ExtractPrototypeMemberDeclarationsMode.USE_CHUNK_TEMP);
            }
        }
        return options;
    }

    @Override
    protected Compiler createCompiler() {
        return new Compiler(this.getErrorPrintStream());
    }

    private ClosureBundler getBundler() {
        if (this.bundler != null) {
            return this.bundler;
        }
        ImmutableList moduleRoots = !this.flags.moduleRoot.isEmpty() ? ImmutableList.copyOf(this.flags.moduleRoot) : ImmutableList.of((Object)"./");
        CompilerOptions options = this.createOptions();
        this.bundler = new ClosureBundler(Transpiler.NULL, new BaseTranspiler(new BaseTranspiler.CompilerSupplier(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT.toFeatureSet().without(FeatureSet.Feature.MODULES, new FeatureSet.Feature[0]), options.getModuleResolutionMode(), (ImmutableList<String>)moduleRoots, options.getBrowserResolverPrefixReplacements()), ""));
        return this.bundler;
    }

    @Override
    protected void prepForBundleAndAppendTo(Appendable out, CompilerInput input, String content) throws IOException {
        this.getBundler().withPath(input.getName()).appendTo(out, (DependencyInfo)input, content);
    }

    @Override
    protected void appendRuntimeTo(Appendable out) throws IOException {
        this.getBundler().appendRuntimeTo(out);
    }

    @Override
    protected List<SourceFile> createExterns(CompilerOptions options) throws IOException {
        List<SourceFile> externs = super.createExterns(options);
        if (this.isInTestMode()) {
            return externs;
        }
        List<SourceFile> builtinExterns = CommandLineRunner.getBuiltinExterns(options.getEnvironment());
        builtinExterns.addAll(externs);
        return builtinExterns;
    }

    private static ImmutableList<ConformanceConfig> loadConformanceConfigs(List<String> configPaths) {
        ImmutableList.Builder configs = ImmutableList.builder();
        for (String configPath : configPaths) {
            try {
                configs.add((Object)CommandLineRunner.loadConformanceConfig(configPath));
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading conformance config", e);
            }
        }
        return configs.build();
    }

    private static ConformanceConfig loadConformanceConfig(String configFile) throws IOException {
        String textProto = com.google.common.io.Files.asCharSource((File)new File(configFile), (Charset)StandardCharsets.UTF_8).read();
        ConformanceConfig.Builder builder = ConformanceConfig.newBuilder();
        if (!textProto.isEmpty() && textProto.charAt(0) == '\ufeff') {
            textProto = textProto.substring(1);
        }
        try {
            TextFormat.merge((CharSequence)textProto, (Message.Builder)builder);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return builder.build();
    }

    @Deprecated
    @InlineMe(replacement="CommandLineRunner.getBuiltinExterns(CompilerOptions.Environment.BROWSER)", imports={"com.google.javascript.jscomp.CommandLineRunner", "com.google.javascript.jscomp.CompilerOptions"})
    public static List<SourceFile> getDefaultExterns() throws IOException {
        return CommandLineRunner.getBuiltinExterns(CompilerOptions.Environment.BROWSER);
    }

    public static List<String> findJsFiles(Collection<String> patterns) throws IOException {
        return CommandLineRunner.findJsFiles(patterns, false);
    }

    private static List<String> findJsFiles(Collection<String> patterns, boolean sortAlphabetically) throws IOException {
        AbstractMap allJsInputs = sortAlphabetically ? new TreeMap() : new LinkedHashMap();
        HashSet<String> excludes = new HashSet<String>();
        for (String pattern : patterns) {
            if (!pattern.contains("*") && !pattern.startsWith("!")) {
                File matchedFile = new File(pattern);
                if (matchedFile.isDirectory()) {
                    CommandLineRunner.matchPaths(new File(matchedFile, "**.js").toString(), allJsInputs, excludes);
                    continue;
                }
                Path original = Paths.get(pattern, new String[0]);
                String pathStringAbsolute = original.normalize().toAbsolutePath().toString();
                if (excludes.contains(pathStringAbsolute)) continue;
                allJsInputs.put(pathStringAbsolute, original.toString());
                continue;
            }
            CommandLineRunner.matchPaths(pattern, allJsInputs, excludes);
        }
        return new ArrayList<String>(allJsInputs.values());
    }

    private static void matchPaths(String pattern, final Map<String, String> allJsInputs, final Set<String> excludes) throws IOException {
        boolean remove;
        FileSystem fs = FileSystems.getDefault();
        boolean bl = remove = pattern.indexOf(33) == 0;
        if (remove) {
            pattern = pattern.substring(1);
        }
        String separator = File.separator.equals("\\") ? "\\\\" : File.separator;
        List patternParts = Splitter.on((String)File.separator).splitToList((CharSequence)pattern);
        String prefix = ".";
        for (int i = 0; i < patternParts.size(); ++i) {
            if (!((String)patternParts.get(i)).contains("*")) continue;
            if (i <= 0) break;
            prefix = Joiner.on((String)separator).join(patternParts.subList(0, i));
            pattern = Joiner.on((String)separator).join(patternParts.subList(i, patternParts.size()));
            break;
        }
        final PathMatcher matcher = fs.getPathMatcher("glob:" + prefix + separator + pattern);
        Files.walkFileTree(fs.getPath(prefix, new String[0]), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) {
                if (matcher.matches(p) || matcher.matches(p.normalize())) {
                    String pathStringAbsolute = p.normalize().toAbsolutePath().toString();
                    if (remove) {
                        excludes.add(pathStringAbsolute);
                        allJsInputs.remove(pathStringAbsolute);
                    } else if (!excludes.contains(pathStringAbsolute)) {
                        allJsInputs.put(pathStringAbsolute, p.toString());
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) {
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    public boolean shouldRunCompiler() {
        return this.runCompiler;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public static void main(String[] args) {
        CommandLineRunner runner;
        if (phaseLogger != null) {
            phaseLogger.setLevel(Level.OFF);
        }
        if ((runner = new CommandLineRunner(args)).shouldRunCompiler()) {
            runner.run();
        }
        if (runner.hasErrors()) {
            System.exit(-1);
        }
    }

    public static enum FormattingOption {
        PRETTY_PRINT,
        PRINT_INPUT_DELIMITER,
        SINGLE_QUOTES;


        private void applyToOptions(CompilerOptions options) {
            switch (this) {
                case PRETTY_PRINT: {
                    options.setPrettyPrint(true);
                    break;
                }
                case PRINT_INPUT_DELIMITER: {
                    options.printInputDelimiter = true;
                    break;
                }
                case SINGLE_QUOTES: {
                    options.setPreferSingleQuotes(true);
                }
            }
        }
    }

    private static class Flags {
        private static final List<AbstractCommandLineRunner.FlagEntry<CheckLevel>> guardLevels = Collections.synchronizedList(new ArrayList());
        private static final List<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> mixedJsSources = Collections.synchronizedList(new ArrayList());
        @Option(name="--browser_featureset_year", usage="shortcut for defining goog.FEATURESET_YEAR=YYYY. The minimum valid value of the browser year is 2012")
        private Integer browserFeaturesetYear = 0;
        @Option(name="--emit_async_functions_with_zonejs", handler=BooleanOptionHandler.class, usage="Relax the restriction on disallowing --language_out=ES_2017 together with Zone.js")
        private boolean emitAsyncFunctionsWithZonejs = false;
        @Option(name="--help", handler=BooleanOptionHandler.class, usage="Displays this message on stdout and exit")
        private boolean displayHelp = false;
        @Option(name="--print_tree", hidden=true, handler=BooleanOptionHandler.class, usage="Prints out the parse tree and exits")
        private boolean printTree = false;
        @Option(name="--print_tree_json", hidden=true, handler=BooleanOptionHandler.class, usage="Prints out the parse tree as json and exits")
        private boolean printTreeJson = false;
        @Option(name="--print_ast", hidden=true, handler=BooleanOptionHandler.class, usage="Prints a dot file describing the internal abstract syntax tree and exits")
        private boolean printAst = false;
        @Option(name="--emit_use_strict", handler=BooleanOptionHandler.class, usage="Start output with \"'use strict';\".")
        private boolean emitUseStrict = false;
        @Option(name="--strict_mode_input", handler=BooleanOptionHandler.class, usage="Assume input sources are to run in strict mode.")
        private boolean strictModeInput = true;
        @Option(name="--jscomp_dev_mode", hidden=true, aliases={"--dev_mode"})
        private CompilerOptions.DevMode jscompDevMode = CompilerOptions.DevMode.OFF;
        @Option(name="--logging_level", hidden=true, usage="The logging level (standard java.util.logging.Level values) for Compiler progress. Does not control errors or warnings for the JavaScript code under compilation")
        private String loggingLevel = Level.WARNING.getName();
        @Option(name="--externs", usage="The file containing JavaScript externs. You may specify multiple")
        private List<String> externs = new ArrayList<String>();
        @Keep
        @Option(name="--js", handler=JsOptionHandler.class, usage="The JavaScript filename. You may specify multiple. The flag name is optional, because args are interpreted as files by default. You may also use minimatch-style glob patterns. For example, use --js='**.js' --js='!**_test.js' to recursively include all js files that do not end in _test.js")
        private List<String> js = new ArrayList<String>();
        @Option(name="--jszip", hidden=true, handler=JsZipOptionHandler.class, usage="The JavaScript zip filename. You may specify multiple.")
        private @Nullable List<String> unusedJsZip = null;
        @Option(name="--js_output_file", usage="Primary output filename. If not specified, output is written to stdout")
        private String jsOutputFile = "";
        @Option(name="--chunk", usage="A JavaScript chunk specification. The format is <name>:<num-js-files>[:[<dep>,...][:]]]. Chunk names must be unique. Each dep is the name of a chunk that this chunk depends on. Chunks must be listed in dependency order, and JS source files must be listed in the corresponding order. Where --chunk flags occur in relation to --js flags is unimportant. <num-js-files> may be set to 'auto' for the first chunk if it has no dependencies. Provide the value 'auto' to trigger chunk creation from CommonJSmodules.")
        private List<String> chunk = new ArrayList<String>();
        @Option(name="--continue-saved-compilation", usage="Filename where a stage 1 compilation state was previously saved.", hidden=true)
        private @Nullable String continueSavedCompilationFile = null;
        @Option(name="--restore_stage1_from_file", usage="Filename where a stage 1 compilation state was previously saved.", hidden=true)
        private @Nullable String restoreStage1FromFile = null;
        @Option(name="--restore_stage2_from_file", usage="Filename where a stage 2 compilation state was previously saved.", hidden=true)
        private @Nullable String restoreStage2FromFile = null;
        @Option(name="--save-after-checks", usage="Filename to save stage 1 state so that the compilation can be resumed later.", hidden=true)
        private @Nullable String saveAfterChecksFile = null;
        @Option(name="--save_stage1_to_file", usage="Filename to save stage 1 state so that the compilation can be resumed later.", hidden=true)
        private @Nullable String saveStage1ToFile = null;
        @Option(name="--save_stage2_to_file", usage="Filename to save stage 2 state so that the compilation can be resumed later.", hidden=true)
        private @Nullable String saveStage2ToFile = null;
        @Option(name="--variable_renaming_report", usage="File where the serialized version of the variable renaming map produced should be saved")
        private String variableMapOutputFile = "";
        @Option(name="--instrument_mapping_report", usage="File where the encoded parameters created by Production Instrumentation are mapped to their pre-encoded values. The %outname% placeholder will expand to the name of the output file that the source map corresponds to. Must be used in tandem with --instrument_for_coverage_option=PRODUCTION")
        private String instrumentationMappingOutputFile = "";
        @Option(name="--create_renaming_reports", hidden=true, handler=BooleanOptionHandler.class, usage="If true, variable renaming and property renaming report files will be produced as {binary name}_vars_renaming_report.out and {binary name}_props_renaming_report.out. Note that this flag cannot be used in conjunction with either variable_renaming_report or property_renaming_report")
        private boolean createNameMapFiles = false;
        @Option(name="--source_map_include_content", handler=BooleanOptionHandler.class, usage="Includes sources content into source map. Greatly increases the size of source maps but offers greater portability")
        private boolean sourceMapIncludeSourcesContent = false;
        @Option(name="--property_renaming_report", usage="File where the serialized version of the property renaming map produced should be saved")
        private String propertyMapOutputFile = "";
        @Option(name="--third_party", handler=BooleanOptionHandler.class, usage="Check source validity but do not enforce Closure style rules and conventions")
        private boolean thirdParty = false;
        @Option(name="--summary_detail_level", hidden=true, usage="Controls how detailed the compilation summary is. Values: 0 (never print summary), 1 (print summary only if there are errors or warnings), 2 (print summary if the 'checkTypes' diagnostic  group is enabled, see --jscomp_warning), 3 (always print summary). The default level is 1")
        private int summaryDetailLevel = 1;
        @Option(name="--isolation_mode", usage="If set to IIFE the compiler output will follow the form:\n  (function(){%output%}).call(this);\nOptions: NONE, IIFE")
        private CompilerOptions.IsolationMode isolationMode = CompilerOptions.IsolationMode.NONE;
        @Option(name="--output_wrapper", usage="Interpolate output into this string at the place denoted by the marker token %output%. Use marker token %output|jsstring% to do js string escaping on the output. Consider using the --isolation_mode flag instead.")
        private String outputWrapper = "";
        @Option(name="--output_wrapper_file", usage="Loads the specified file and passes the file contents to the --output_wrapper flag, replacing the value if it exists. This is useful if you want special characters like newline in the wrapper.")
        private String outputWrapperFile = "";
        @Option(name="--chunk_wrapper", usage="An output wrapper for a JavaScript chunk (optional). The format is <name>:<wrapper>. The chunk name must correspond with a chunk specified using --chunk. The wrapper must contain %s as the code placeholder. Alternately, %output% can be used in place of %s. %n% can be used to represent a newline. The %basename% placeholder can also be used to substitute the base name of the chunk output file.")
        private List<String> chunkWrapper = new ArrayList<String>();
        @Option(name="--chunk_output_path_prefix", usage="Prefix for filenames of compiled JS chunks. <chunk-name>.js will be appended to this prefix. Directories will be created as needed. Use with --chunk")
        private String chunkOutputPathPrefix = "./";
        @Option(name="--create_source_map", usage="If specified, a source map file mapping the generated source files back to the original source file will be output to the specified path. The %outname% placeholder will expand to the name of the output file that the source map corresponds to.")
        private String createSourceMap = "";
        @Option(name="--source_map_format", hidden=true, usage="The source map format to produce. Options are V3 and DEFAULT, which are equivalent.")
        private SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
        @Option(name="--source_map_location_mapping", usage="Source map location mapping separated by a '|' (i.e. filesystem-path|webserver-path)")
        private List<String> sourceMapLocationMapping = new ArrayList<String>();
        @Option(name="--source_map_input", usage="Source map locations for input files, separated by a '|', (i.e. input-file-path|input-source-map)")
        private List<String> sourceMapInputs = new ArrayList<String>();
        @Option(name="--parse_inline_source_maps", handler=BooleanOptionHandler.class, usage="Parse inline source maps (//# sourceMappingURL=data:...)")
        private Boolean parseInlineSourceMaps = true;
        @Option(name="--apply_input_source_maps", handler=BooleanOptionHandler.class, usage="Apply input source maps to the output source map, i.e. have the result map back to original inputs.  Input sourcemaps can be located in 2 ways:\n 1) by the//# sourceMappingURL=<url>. \n 2) using the--source_map_location_mapping flag.\nsourceMappingURL=<url> can read both paths and inline Base64 encoded sourcemaps. For inline Base64 encoded sourcemaps, see --parse_inline_source_maps.")
        private boolean applyInputSourceMaps = true;
        @Option(name="--jscomp_error", handler=WarningGuardErrorOptionHandler.class, usage="Make the named class of warnings an error. Must be one of the error group items. '*' adds all supported.")
        private List<String> jscompError = new ArrayList<String>();
        @Option(name="--jscomp_warning", handler=WarningGuardWarningOptionHandler.class, usage="Make the named class of warnings a normal warning. Must be one of the error group items. '*' adds all supported.")
        private List<String> jscompWarning = new ArrayList<String>();
        @Option(name="--jscomp_off", handler=WarningGuardOffOptionHandler.class, usage="Turn off the named class of warnings. Must be one of the error group items. '*' adds all supported.")
        private List<String> jscompOff = new ArrayList<String>();
        @Option(name="--define", aliases={"--D", "-D"}, usage="Override the value of a variable annotated @define. The format is <name>[=<val>], where <name> is the name of a @define variable and <val> is a boolean, number, or a single-quoted string that contains no single quotes. If [=<val>] is omitted, the variable is marked true")
        private List<String> define = new ArrayList<String>();
        @Option(name="--charset", usage="Input and output charset for all files. By default, we accept UTF-8 as input and output US_ASCII")
        private String charset = "";
        @Option(name="--compilation_level", aliases={"-O"}, usage="Specifies the compilation level to use. Options: BUNDLE, WHITESPACE_ONLY, SIMPLE (default), ADVANCED")
        private String compilationLevel = "SIMPLE";
        private @Nullable CompilationLevel compilationLevelParsed = null;
        @Option(name="--num_parallel_threads", hidden=true, handler=IntOptionHandler.class, usage="Use multiple threads to parallelize parts of the compilation.")
        private int numParallelThreads = 1;
        @Option(name="--checks_only", aliases={"--checks-only"}, handler=BooleanOptionHandler.class, usage="Don't generate output. Run checks, but no optimization passes.")
        private boolean checksOnly = false;
        @Option(name="--incremental_check_mode", usage="Generate or check externs-like .i.js files representing individual libraries.")
        private CompilerOptions.IncrementalCheckMode incrementalCheckMode = CompilerOptions.IncrementalCheckMode.OFF;
        @Option(name="--continue_after_errors", handler=BooleanOptionHandler.class, usage="Continue trying to compile after an error is encountered.")
        private boolean continueAfterErrors = false;
        @Option(name="--use_types_for_optimization", handler=BooleanOptionHandler.class, usage="Enable or disable the optimizations based on available type information. Inaccurate type annotations may result in incorrect results.")
        private boolean useTypesForOptimization = true;
        @Option(name="--assume_function_wrapper", handler=BooleanOptionHandler.class, usage="Enable additional optimizations based on the assumption that the output will be wrapped with a function wrapper.  This flag is used to indicate that \"global\" declarations will not actually be global but instead isolated to the compilation unit. This enables additional optimizations.")
        private boolean assumeFunctionWrapper = false;
        @Option(name="--warning_level", aliases={"-W"}, usage="Specifies the warning level to use. Options: QUIET, DEFAULT, VERBOSE")
        private WarningLevel warningLevel = WarningLevel.DEFAULT;
        @Option(name="--debug", handler=BooleanOptionHandler.class, usage="Enable debugging options. Property renaming uses long mangled names which can be mapped back to the original name.")
        private boolean debug = false;
        @Option(name="--typed_ast_output_file__INTENRNAL_USE_ONLY", usage="Sets file to output in-progress typedAST format. DO NOT USE!", hidden=true)
        private @Nullable String typedAstOutputFile = null;
        @Option(name="--generate_exports", handler=BooleanOptionHandler.class, usage="Generates export code for those marked with @export")
        private boolean generateExports = true;
        @Option(name="--export_local_property_definitions", handler=BooleanOptionHandler.class, usage="Generates export code for local properties marked with @export")
        private boolean exportLocalPropertyDefinitions = true;
        @Option(name="--formatting", usage="Specifies which formatting options, if any, should be applied to the output JS. Options: PRETTY_PRINT, PRINT_INPUT_DELIMITER, SINGLE_QUOTES")
        private List<FormattingOption> formatting = new ArrayList<FormattingOption>();
        @Option(name="--process_common_js_modules", handler=BooleanOptionHandler.class, usage="Process CommonJS modules to a concatenable form.")
        private boolean processCommonJsModules = false;
        @Option(name="--js_module_root", usage="Path prefixes to be removed from ES6 & CommonJS modules.")
        private List<String> moduleRoot = new ArrayList<String>();
        @Option(name="--process_closure_primitives", handler=BooleanOptionHandler.class, usage="Processes built-ins from the Closure library, such as goog.require(), goog.provide(), and goog.exportSymbol(). True by default.")
        private boolean processClosurePrimitives = true;
        @Option(name="--angular_pass", handler=BooleanOptionHandler.class, usage="Generate $inject properties for AngularJS for functions annotated with @ngInject")
        private boolean angularPass = false;
        @Option(name="--polymer_version", usage="Which version of Polymer is being used (1 or 2).")
        private @Nullable Integer polymerVersion = null;
        @Option(name="--polymer_export_policy", usage="How to handle exports/externs for Polymer properties and methods. Values: LEGACY, EXPORT_ALL.")
        private String polymerExportPolicy = PolymerExportPolicy.LEGACY.name();
        @Option(name="--chrome_pass", handler=BooleanOptionHandler.class, usage="Enable Chrome-specific options for handling cr.* functions.", hidden=true)
        private boolean chromePass = false;
        @Option(name="--j2cl_pass", hidden=true, usage="Rewrite J2CL output to be compiler-friendly if enabled (ON or AUTO). Options:OFF, ON, AUTO(default)")
        private String j2clPassMode = "AUTO";
        @Option(name="--remove_j2cl_asserts", hidden=true, usage="Remove calls to J2CL assertions.")
        private boolean removeJ2cLAsserts = true;
        @Option(name="--output_manifest", usage="Prints out a list of all the files in the compilation. If --dependency_mode=PRUNE or PRUNE_LEGACY is specified, this will not include files that got dropped because they were not required. The %outname% placeholder expands to the JS output file. If you're using modularization, using %outname% will create a manifest for each module.")
        private String outputManifest = "";
        @Option(name="--output_chunk_dependencies", usage="Prints out a JSON file of dependencies between chunks.")
        private String outputChunkDependencies = "";
        @Option(name="--language_in", usage="Sets the language spec to which input sources should conform. Options: ECMASCRIPT3, ECMASCRIPT5, ECMASCRIPT5_STRICT, ECMASCRIPT_2015, ECMASCRIPT_2016, ECMASCRIPT_2017, ECMASCRIPT_2018, ECMASCRIPT_2019, ECMASCRIPT_2020,ECMASCRIPT_2021, STABLE, ECMASCRIPT_NEXT (latest features supported),UNSTABLE (for testing only)")
        private String languageIn = "STABLE";
        @Option(name="--language_out", usage="Sets the language spec to which output should conform. Options: ECMASCRIPT3, ECMASCRIPT5, ECMASCRIPT_2015, ECMASCRIPT_2016, ECMASCRIPT_2017, ECMASCRIPT_2018, ECMASCRIPT_2019, ECMASCRIPT_2020, ECMASCRIPT_2021, STABLE, ECMASCRIPT_NEXT (latest features supported)")
        private String languageOut = "ECMASCRIPT_NEXT";
        @Option(name="--version", handler=BooleanOptionHandler.class, usage="Prints the compiler version to stdout and exit.")
        private boolean version = false;
        @Option(name="--translations_file", hidden=true, usage="Source of translated messages. Currently only supports XTB.")
        private String translationsFile = "";
        @Option(name="--translations_project", hidden=true, usage="Scopes all translations to the specified project.When specified, we will use different message ids so that messages in different projects can have different translations.")
        private @Nullable String translationsProject = null;
        @Option(name="--flagfile", hidden=true, usage="A file (or files) containing additional command-line options.")
        private List<String> flagFiles = new ArrayList<String>();
        @Option(name="--warnings_allowlist_file", usage="A file containing warnings to suppress. Each line should be of the form\n<file-name>:<line-number>?  <warning-description>", aliases={"--warnings_whitelist_file"})
        private String warningsAllowlistFile = "";
        @Option(name="--hide_warnings_for", usage="If specified, files whose path contains this string will have their warnings hidden. You may specify multiple.")
        private List<String> hideWarningsFor = new ArrayList<String>();
        @Option(name="--extra_annotation_name", usage="A allowlist of tag names in JSDoc. You may specify multiple")
        private List<String> extraAnnotationName = new ArrayList<String>();
        @Option(name="--tracer_mode", hidden=true, usage="Shows the duration of each compiler pass and the impact to the compiled output size. Options: ALL, AST_SIZE, RAW_SIZE, TIMING_ONLY, OFF")
        private CompilerOptions.TracerMode tracerMode = CompilerOptions.TracerMode.OFF;
        @Option(name="--rename_variable_prefix", usage="Specifies a prefix that will be prepended to all variables.")
        private @Nullable String renamePrefix = null;
        @Option(name="--rename_prefix_namespace", usage="Specifies the name of an object that will be used to store all non-extern globals")
        private @Nullable String renamePrefixNamespace = null;
        @Option(name="--conformance_configs", usage="A list of JS Conformance configurations in text protocol buffer format.")
        private List<String> conformanceConfigs = new ArrayList<String>();
        @Option(name="--env", usage="Determines the set of builtin externs to load. Options: BROWSER, CUSTOM. Defaults to BROWSER.")
        private CompilerOptions.Environment environment = CompilerOptions.Environment.BROWSER;
        @Option(name="--json_streams", usage="Specifies whether standard input and output streams will be a JSON array of sources. Each source will be an object of the form {path: filename, src: file_contents, source_map: srcmap_contents }. Intended for use by stream-based build systems such as gulpjs. Options: NONE, IN, OUT, BOTH. Defaults to NONE.")
        private CompilerOptions.JsonStreamMode jsonStreamMode = CompilerOptions.JsonStreamMode.NONE;
        @Option(name="--preserve_type_annotations", hidden=true, handler=BooleanOptionHandler.class, usage="Preserves type annotations.")
        private boolean preserveTypeAnnotations = false;
        @Option(name="--inject_libraries", handler=BooleanOptionHandler.class, usage="Allow injecting runtime libraries.")
        private boolean injectLibraries = true;
        @Option(name="--force_inject_library", usage="Force injection of named runtime libraries. The format is <name> where <name> is the name of a runtime library. Possible libraries include: base, es6_runtime")
        private List<String> forceInjectLibraries = new ArrayList<String>();
        @Option(name="--dependency_mode", usage="Specifies how the compiler should determine the set and order of files for a compilation. Options: NONE the compiler will include all src files in the order listed, SORT_ONLY the compiler will include all source files in dependency order, PRUNE files will only be included if they are transitive dependencies of files listed in the --entry_point flag and then sorted in dependency order, PRUNE_LEGACY same as PRUNE but files that do not goog.provide a namespace and are not modules will be automatically added as --entry_point entries. Defaults to PRUNE_LEGACY if entry points are defined, otherwise to NONE.")
        private @Nullable DependencyOptions.DependencyMode dependencyMode = null;
        @Option(name="--entry_point", usage="A file or namespace to use as the starting point for determining which src files to include in the compilation. ES6 and CommonJS modules are specified as file paths (without the extension). Closure-library namespaces are specified with a \"goog:\" prefix. Example: --entry_point=goog:goog.Promise")
        private List<String> entryPoint = new ArrayList<String>();
        @Option(name="--rewrite_polyfills", handler=BooleanOptionHandler.class, usage="Injects polyfills for ES2015+ library classes and methods used in source. See also the \"Polyfills\" GitHub Wiki page.")
        private boolean rewritePolyfills = true;
        @Option(name="--isolate_polyfills", handler=BooleanOptionHandler.class, usage="Hides injected polyfills from the global scope and any external code. See the the \"Polyfills\" GitHub Wiki page for details.")
        private boolean isolatePolyfills = false;
        @Option(name="--print_source_after_each_pass", handler=BooleanOptionHandler.class, hidden=true, usage="Whether to iteratively print resulting JS source per pass.")
        private boolean printSourceAfterEachPass = false;
        @Option(name="--module_resolution", usage="Specifies how the compiler locates modules. BROWSER requires all module imports to begin with a '.' or '/' and have a file extension. NODE uses the node module rules. WEBPACK looks up modules from a special lookup map.")
        private ModuleLoader.ResolutionMode moduleResolutionMode = ModuleLoader.ResolutionMode.BROWSER;
        @Option(name="--browser_resolver_prefix_replacements", usage="Prefixes to replace in ES6 import paths before resolving. module_resolution must be BROWSER_WITH_TRANSFORMED_PREFIXES to take effect.")
        private Map<String, String> browserResolverPrefixReplacements = new HashMap<String, String>();
        @Option(name="--package_json_entry_names", usage="Ordered list of entries to look for in package.json files when processing modules with the NODE module resolution strategy (i.e. esnext:main,browser,main). Defaults to a list with the following entries: \"browser\", \"module\", \"main\".")
        private @Nullable String packageJsonEntryNames = null;
        @Option(name="--error_format", usage="Specifies format for error messages.")
        private AbstractCommandLineRunner.CommandLineConfig.ErrorFormatOption errorFormat = AbstractCommandLineRunner.CommandLineConfig.ErrorFormatOption.STANDARD;
        @Option(name="--renaming", handler=BooleanOptionHandler.class, usage="Disables variable renaming. Cannot be used with ADVANCED optimizations.")
        private boolean renaming = true;
        @Option(name="--help_markdown", handler=BooleanOptionHandler.class, hidden=true, usage="Prints markdown formatted flag usage")
        private boolean helpMarkdown = false;
        @Option(name="--instrument_for_coverage_option", usage="Enable code instrumentation to perform code coverage analysis. Options are:\n 1. NONE (default)\n 2. LINE - Instrument code by line.\n 3. BRANCH - Instrument code by branch.\n 4. PRODUCTION - Function Instrumentation on compiled JS code.\n")
        private String instrumentForCoverageOption = "NONE";
        @Option(name="--production_instrumentation_array_name", usage="Name of the global array used by production instrumentation. The array name should be declared as an extern so it is not renamed by the compiler. A functionthat parses the global array should also be included. This flag is to be used intandem with --instrument_code=PRODUCTION")
        private String productionInstrumentationArrayName = "";
        @Option(name="--chunk_output_type", usage="Indicates what format the compiler should use for output chunks. GLOBAL_NAMESPACE is typically used in conjunction with --rename_prefix_namespace. ES_MODULES outputs chunks as proper modules with 'import' and 'export' statements.")
        private CompilerOptions.ChunkOutputType chunkOutputType = CompilerOptions.ChunkOutputType.GLOBAL_NAMESPACE;
        private CompilerOptions.InstrumentOption instrumentCodeParsed = CompilerOptions.InstrumentOption.NONE;
        @Option(name="--allow_dynamic_import", handler=BooleanOptionHandler.class, usage="Indicates that the compiler should allow dynamic import expressions. Dynamic import expressions are not yet fully supported and may lead to broken output code.")
        private boolean allowDynamicImport = true;
        @Option(name="--dynamic_import_alias", usage="Instructs the compiler to replace dynamic imports expressions with a function call using the specified name. Allows dynamic import expressions to be externally polyfilled when the output language level does not natively support them. An alias of 'import' is allowed.")
        private @Nullable String dynamicImportAlias = null;
        @Option(name="--assume_static_inheritance_is_not_used", handler=BooleanOptionHandler.class, usage="Assume that static (class-side) inheritance is not being used and that static methods will not be referenced via `this` or through subclasses. This enables optimizations that could break code that did those things.")
        private boolean assumeStaticInheritanceIsNotUsed = true;
        @Option(name="--assume_no_prototype_method_enumeration", handler=BooleanOptionHandler.class, usage="Assume that prototype method enumeration is not being used. This allows the compiler to move a prototype method declaration into a deeper chunk without creating stub functions in a parent chunk.")
        private boolean assumeNoPrototypeMethodEnumeration = false;
        @Argument
        private List<String> arguments = new ArrayList<String>();
        private final CmdLineParser parser = new CmdLineParser((Object)this);
        private static final ImmutableMultimap<String, String> categories = new ImmutableMultimap.Builder().putAll((Object)"Basic Usage", (Iterable)ImmutableList.of((Object)"compilation_level", (Object)"env", (Object)"externs", (Object)"js", (Object)"js_output_file", (Object)"language_in", (Object)"language_out", (Object)"warning_level")).putAll((Object)"Warning and Error Management", (Iterable)ImmutableList.of((Object)"conformance_configs", (Object)"error_format", (Object)"extra_annotation_name", (Object)"hide_warnings_for", (Object)"jscomp_error", (Object)"jscomp_off", (Object)"jscomp_warning", (Object)"strict_mode_input", (Object)"warnings_allowlist_file")).putAll((Object)"Output", (Iterable)ImmutableList.of((Object)"assume_function_wrapper", (Object)"debug", (Object)"emit_use_strict", (Object)"export_local_property_definitions", (Object)"formatting", (Object)"generate_exports", (Object)"isolation_mode", (Object)"output_wrapper", (Object)"output_wrapper_file", (Object)"rename_variable_prefix")).putAll((Object)"Dependency Management", (Iterable)ImmutableList.of((Object)"dependency_mode", (Object)"entry_point")).putAll((Object)"JS Modules", (Iterable)ImmutableList.of((Object)"dynamic_import_alias", (Object)"js_module_root", (Object)"module_resolution", (Object)"process_common_js_modules", (Object)"package_json_entry_names")).putAll((Object)"Library and Framework Specific", (Iterable)ImmutableList.of((Object)"angular_pass", (Object)"force_inject_library", (Object)"inject_libraries", (Object)"polymer_version", (Object)"process_closure_primitives", (Object)"rewrite_polyfills", (Object)"isolate_polyfills")).putAll((Object)"Code Splitting", (Iterable)ImmutableList.of((Object)"chunk", (Object)"chunk_output_path_prefix", (Object)"chunk_output_type", (Object)"chunk_wrapper", (Object)"rename_prefix_namespace")).putAll((Object)"Reports", (Iterable)ImmutableList.of((Object)"create_source_map", (Object)"output_manifest", (Object)"output_chunk_dependencies", (Object)"property_renaming_report", (Object)"source_map_input", (Object)"source_map_include_content", (Object)"source_map_location_mapping", (Object)"variable_renaming_report")).putAll((Object)"Miscellaneous", (Iterable)ImmutableList.of((Object)"assume_static_inheritance_is_not_used", (Object)"browser_featureset_year", (Object)"charset", (Object)"checks_only", (Object)"define", (Object)"flagfile", (Object)"help", (Object)"json_streams", (Object)"third_party", (Object)"use_types_for_optimization", (Object)"version")).build();
        private static final String BOLD_PREFIX = "\u001b[1m";
        private static final String NORMAL_PREFIX = "\u001b[0m";
        private static final String MARKDOWN_CHARS_TO_ESCAPE = "[-*\\`\\[\\]{}\\(\\)#+\\.!<>]";
        private int maxLineLength = 80;
        private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

        Flags() {
        }

        private void parse(List<String> args) throws CmdLineException {
            this.parser.parseArgument(args);
            this.compilationLevelParsed = CompilationLevel.fromString(Ascii.toUpperCase((String)this.compilationLevel));
            if (this.compilationLevelParsed == null) {
                throw new CmdLineException(this.parser, "Bad value for --compilation_level: " + this.compilationLevel);
            }
            this.instrumentCodeParsed = CompilerOptions.InstrumentOption.fromString(Ascii.toUpperCase((String)this.instrumentForCoverageOption));
            if (this.instrumentCodeParsed == null) {
                throw new CmdLineException(this.parser, "Bad value for --instrument_for_coverage_option: " + this.instrumentForCoverageOption);
            }
        }

        private void printUsage(PrintStream ps) {
            OutputStreamWriter outputStream = new OutputStreamWriter((OutputStream)ps, StandardCharsets.UTF_8);
            boolean isFirst = true;
            for (Map.Entry entry : categories.asMap().entrySet()) {
                String prefix = "\n\n";
                Object suffix = "";
                if (isFirst) {
                    isFirst = false;
                    prefix = "";
                }
                if (((String)entry.getKey()).equals("Warning and Error Management")) {
                    suffix = this.helpMarkdown ? "\n## Available Error Groups\n\n  - " + "accessControls, checkPrototypalTypes, checkRegExp, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es5Strict, externsValidation, functionParams, globalThis, invalidCasts, lintVarDeclarations, misplacedTypeAnnotation, missingOverride, missingPolyfill, missingProperties, missingProvide, missingRequire, missingReturn, missingSourcesWarnings, moduleLoad, moduleImport, msgDescriptions, nonStandardJsDocs, partialAlias, polymer, reportUnknownTypes, strictCheckTypes, strictMissingProperties, strictModuleDepCheck, strictPrimitiveOperators, suspiciousCode, typeInvalidation, undefinedVars, underscore, unknownDefines, unusedLocalVariables, unusedPrivateMembers, uselessCode, untranspilableFeatures,visibility".replace(", ", "\n  - ") : "\n\u001b[1mAvailable Error Groups: \u001b[0maccessControls, checkPrototypalTypes, checkRegExp, checkTypes, checkVars, conformanceViolations, const, constantProperty, deprecated, deprecatedAnnotations, duplicateMessage, es5Strict, externsValidation, functionParams, globalThis, invalidCasts, lintVarDeclarations, misplacedTypeAnnotation, missingOverride, missingPolyfill, missingProperties, missingProvide, missingRequire, missingReturn, missingSourcesWarnings, moduleLoad, moduleImport, msgDescriptions, nonStandardJsDocs, partialAlias, polymer, reportUnknownTypes, strictCheckTypes, strictMissingProperties, strictModuleDepCheck, strictPrimitiveOperators, suspiciousCode, typeInvalidation, undefinedVars, underscore, unknownDefines, unusedLocalVariables, unusedPrivateMembers, uselessCode, untranspilableFeatures,visibility";
                }
                if (this.helpMarkdown) {
                    this.maxLineLength = 5000;
                    this.parser.setUsageWidth(this.maxLineLength);
                }
                this.printCategoryUsage((String)entry.getKey(), (Collection)entry.getValue(), outputStream, prefix, (String)suffix);
            }
            ps.flush();
        }

        private void printCategoryUsage(String categoryName, Collection<String> options, OutputStreamWriter outputStream, String prefix, String suffix) {
            try {
                if (prefix != null) {
                    this.printStringLineWrapped(prefix, outputStream);
                }
                if (this.helpMarkdown) {
                    outputStream.write("# " + categoryName + "\n");
                    for (String optionName : options) {
                        StringWriter stringWriter = new StringWriter();
                        this.parser.printUsage((Writer)stringWriter, null, optionHandler -> {
                            if (optionHandler.option instanceof NamedOptionDef) {
                                return !optionHandler.option.hidden() && optionName.equals(((NamedOptionDef)optionHandler.option).name().replaceFirst("^--", ""));
                            }
                            return false;
                        });
                        stringWriter.flush();
                        String rawOptionUsage = stringWriter.toString();
                        Matcher optionNameMatches = Pattern.compile(" *--([a-z0-9_]+)").matcher(rawOptionUsage);
                        int delimiterIndex = rawOptionUsage.indexOf(" : ");
                        if (delimiterIndex > 0) {
                            outputStream.write("\n**" + rawOptionUsage.substring(0, delimiterIndex).trim() + "**  \n");
                            String optionDescription = rawOptionUsage.substring(delimiterIndex + 3).replaceAll(MARKDOWN_CHARS_TO_ESCAPE, "\\\\$0").trim();
                            outputStream.write(optionDescription + "\n");
                        } else {
                            outputStream.write(rawOptionUsage.replaceAll(MARKDOWN_CHARS_TO_ESCAPE, "\\\\$0"));
                        }
                        outputStream.flush();
                    }
                } else {
                    outputStream.write(BOLD_PREFIX + categoryName + ":\n\u001b[0m");
                    this.parser.printUsage((Writer)outputStream, null, optionHandler -> {
                        if (optionHandler.option instanceof NamedOptionDef) {
                            return !optionHandler.option.hidden() && options.contains(((NamedOptionDef)optionHandler.option).name().replaceFirst("^--", ""));
                        }
                        return false;
                    });
                }
                if (suffix != null) {
                    this.printStringLineWrapped(suffix, outputStream);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void printStringLineWrapped(String input, OutputStreamWriter outputStream) throws IOException {
            if (input.length() < this.maxLineLength) {
                outputStream.write(input);
                return;
            }
            int endIndex = this.maxLineLength;
            String subString = input.substring(0, this.maxLineLength);
            Matcher whitespaceMatcher = WHITESPACE_PATTERN.matcher(subString);
            boolean foundMatch = false;
            while (whitespaceMatcher.find()) {
                endIndex = whitespaceMatcher.start();
                foundMatch = true;
            }
            outputStream.write(input.substring(0, endIndex) + "\n");
            this.printStringLineWrapped("    " + input.substring(foundMatch ? endIndex + 1 : endIndex), outputStream);
        }

        private static void printShortUsageAfterErrors(PrintStream ps) {
            ps.print("Sample usage: ");
            ps.println("--compilation_level (-O) VAL --externs VAL --js VAL --js_output_file VAL --warning_level (-W) [QUIET | DEFAULT | VERBOSE]");
            ps.println("Run with --help for all options and details");
            ps.flush();
        }

        protected List<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> getMixedJsSources() throws CmdLineException, IOException {
            ArrayList<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>> mixedSources = new ArrayList<AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>>();
            HashSet<String> excludes = new HashSet<String>();
            for (AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType> source : mixedJsSources) {
                if (source.getValue().endsWith(".zip")) {
                    mixedSources.add(source);
                    continue;
                }
                if (source.getValue().startsWith("!")) {
                    for (String filename : CommandLineRunner.findJsFiles((Collection<String>)ImmutableList.of((Object)source.getValue().substring(1)))) {
                        excludes.add(filename);
                        mixedSources.remove(new AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>(AbstractCommandLineRunner.JsSourceType.JS, filename));
                    }
                    continue;
                }
                for (String filename : CommandLineRunner.findJsFiles(Collections.singletonList(source.getValue()), true)) {
                    if (excludes.contains(filename)) continue;
                    mixedSources.add(new AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>(AbstractCommandLineRunner.JsSourceType.JS, filename));
                }
            }
            List<String> fromArguments = CommandLineRunner.findJsFiles(this.arguments);
            for (String filename : fromArguments) {
                mixedSources.add(new AbstractCommandLineRunner.FlagEntry<AbstractCommandLineRunner.JsSourceType>(AbstractCommandLineRunner.JsSourceType.JS, filename));
            }
            if (!mixedJsSources.isEmpty() && !this.arguments.isEmpty() && mixedSources.isEmpty()) {
                throw new CmdLineException(this.parser, "No inputs matched");
            }
            return mixedSources;
        }

        List<SourceMap.LocationMapping> getSourceMapLocationMappings() throws CmdLineException {
            ImmutableList.Builder locationMappings = ImmutableList.builder();
            ImmutableMap<String, String> split = this.splitPipeParts(this.sourceMapLocationMapping, "--source_map_location_mapping");
            for (Map.Entry mapping : split.entrySet()) {
                locationMappings.add((Object)new SourceMap.PrefixLocationMapping((String)mapping.getKey(), (String)mapping.getValue()));
            }
            return locationMappings.build();
        }

        ImmutableMap<String, String> getSourceMapInputs() throws CmdLineException {
            return this.splitPipeParts(this.sourceMapInputs, "--source_map_input");
        }

        private ImmutableMap<String, String> splitPipeParts(Iterable<String> input, String flagName) throws CmdLineException {
            ImmutableMap.Builder result = new ImmutableMap.Builder();
            Splitter splitter = Splitter.on((char)'|').limit(2);
            for (String inputSourceMap : input) {
                List parts = splitter.splitToList((CharSequence)inputSourceMap);
                if (parts.size() != 2) {
                    throw new CmdLineException(this.parser, "Bad value for " + flagName + " (duplicate key): " + input);
                }
                result.put((Object)((String)parts.get(0)), (Object)((String)parts.get(1)));
            }
            return result.buildOrThrow();
        }

        List<String> getPackageJsonEntryNames() throws CmdLineException {
            return Splitter.on((char)',').splitToList((CharSequence)this.packageJsonEntryNames);
        }

        private static class MultiFlagSetter<T>
        implements Setter<String> {
            private final Setter<? super String> proxy;
            private final T flag;
            private final List<AbstractCommandLineRunner.FlagEntry<T>> entries;

            private MultiFlagSetter(Setter<? super String> proxy, T flag, List<AbstractCommandLineRunner.FlagEntry<T>> entries) {
                this.proxy = proxy;
                this.flag = flag;
                this.entries = entries;
            }

            public boolean isMultiValued() {
                return this.proxy.isMultiValued();
            }

            public Class<String> getType() {
                return this.proxy.getType();
            }

            public void addValue(String value) throws CmdLineException {
                String normalizedValue = value;
                if (value != null && value.length() > 0 && (value.substring(0, 1).equals("'") || value.substring(0, 1).equals("\"")) && value.substring(value.length() - 1).equals(value.substring(0, 1))) {
                    normalizedValue = value.substring(1, value.length() - 1);
                }
                this.proxy.addValue((Object)normalizedValue);
                this.entries.add(new AbstractCommandLineRunner.FlagEntry<T>(this.flag, normalizedValue));
            }

            public FieldSetter asFieldSetter() {
                return this.proxy.asFieldSetter();
            }

            public AnnotatedElement asAnnotatedElement() {
                return this.proxy.asAnnotatedElement();
            }
        }

        public static class JsZipOptionHandler
        extends StringOptionHandler {
            @Keep
            public JsZipOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter<AbstractCommandLineRunner.JsSourceType>(setter, AbstractCommandLineRunner.JsSourceType.JS_ZIP, mixedJsSources));
            }
        }

        public static class JsOptionHandler
        extends StringOptionHandler {
            @Keep
            public JsOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter<AbstractCommandLineRunner.JsSourceType>(setter, AbstractCommandLineRunner.JsSourceType.JS, mixedJsSources));
            }
        }

        public static class WarningGuardOffOptionHandler
        extends StringOptionHandler {
            @Keep
            public WarningGuardOffOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter<CheckLevel>(setter, CheckLevel.OFF, guardLevels));
            }
        }

        public static class WarningGuardWarningOptionHandler
        extends StringOptionHandler {
            @Keep
            public WarningGuardWarningOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter<CheckLevel>(setter, CheckLevel.WARNING, guardLevels));
            }
        }

        public static class WarningGuardErrorOptionHandler
        extends StringOptionHandler {
            @Keep
            public WarningGuardErrorOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super(parser, option, new MultiFlagSetter<CheckLevel>(setter, CheckLevel.ERROR, guardLevels));
            }
        }

        public static class BooleanOptionHandler
        extends OptionHandler<Boolean> {
            private static final ImmutableSet<String> TRUES = ImmutableSet.of((Object)"true", (Object)"on", (Object)"yes", (Object)"1");
            private static final ImmutableSet<String> FALSES = ImmutableSet.of((Object)"false", (Object)"off", (Object)"no", (Object)"0");

            @Keep
            public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
                super(parser, option, setter);
            }

            public int parseArguments(Parameters params) throws CmdLineException {
                String param = null;
                try {
                    param = params.getParameter(0);
                }
                catch (CmdLineException e) {
                    param = null;
                }
                if (param == null) {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                String lowerParam = Ascii.toLowerCase((String)param);
                if (TRUES.contains((Object)lowerParam)) {
                    this.setter.addValue((Object)true);
                } else if (FALSES.contains((Object)lowerParam)) {
                    this.setter.addValue((Object)false);
                } else {
                    this.setter.addValue((Object)true);
                    return 0;
                }
                return 1;
            }

            public String getDefaultMetaVariable() {
                return null;
            }
        }
    }
}

