/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.Xid;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.nullness.Nullable;

final class ClosureRewriteModule
implements CompilerPass {
    static final DiagnosticType INVALID_MODULE_ID_ARG = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_MODULE_ID_ARG", "goog.module parameter must be a string literal");
    static final DiagnosticType INVALID_PROVIDE_NAMESPACE = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_PROVIDE_NAMESPACE", "goog.provide parameter must be a string literal.");
    static final DiagnosticType INVALID_PROVIDE_CALL = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_PROVIDE_CALL", "goog.provide can not be called in goog.module.");
    static final DiagnosticType INVALID_GET_ALIAS = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_GET_ALIAS", "goog.module.get should not be aliased.");
    static final DiagnosticType INVALID_EXPORT_COMPUTED_PROPERTY = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_EXPORT_COMPUTED_PROPERTY", "Computed properties are not yet supported in goog.module exports.");
    static final DiagnosticType USELESS_USE_STRICT_DIRECTIVE = DiagnosticType.disabled("JSC_USELESS_USE_STRICT_DIRECTIVE", "'use strict' is unnecessary in goog.module files.");
    static final DiagnosticType IMPORT_INLINING_SHADOWS_VAR = DiagnosticType.error("JSC_IMPORT_INLINING_SHADOWS_VAR", "Inlining of reference to import \"{1}\" shadows var \"{0}\".");
    static final DiagnosticType ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT = DiagnosticType.error("JSC_ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT", "Destructuring import only allowed for importing module with named exports.\nSee https://github.com/google/closure-compiler/wiki/goog.module-style");
    static final DiagnosticType ILLEGAL_DESTRUCTURING_NOT_EXPORTED = DiagnosticType.error("JSC_ILLEGAL_DESTRUCTURING_NOT_EXPORTED", "Destructuring import reference to name \"{0}\" was not exported in module {1}");
    static final DiagnosticType LOAD_MODULE_FN_MISSING_RETURN = DiagnosticType.error("JSC_LOAD_MODULE_FN_MISSING_RETURN", "goog.loadModule function should end with 'return exports;'");
    static final DiagnosticType ILLEGAL_MODULE_RENAMING_CONFLICT = DiagnosticType.error("JSC_ILLEGAL_MODULE_RENAMING_CONFLICT", "Internal compiler error: rewritten module global name {0} is already in use.");
    static final DiagnosticType ILLEGAL_STMT_OF_GOOG_REQUIRE_DYNAMIC_IN_AWAIT = DiagnosticType.error("ILLEGAL_STMT_OF_GOOG_REQUIRE_DYNAMIC_IN_AWAIT", "Illegal use of dynamic import: LHS of await goog.requireDynamic() must be a destructing LHS or name, and it must be in a declaration statement.");
    static final String MODULE_EXPORTS_PREFIX = "module$exports$";
    private static final String MODULE_CONTENTS_PREFIX = "module$contents$";
    private static final Node GOOG_FORWARDDECLARE = IR.getprop(IR.name("goog"), "forwardDeclare");
    private static final Node GOOG_LOADMODULE = IR.getprop(IR.name("goog"), "loadModule");
    private static final Node GOOG_MODULE = IR.getprop(IR.name("goog"), "module");
    private static final Node GOOG_MODULE_DECLARELEGACYNAMESPACE = IR.getprop(GOOG_MODULE, "declareLegacyNamespace");
    private static final Node GOOG_MODULE_GET = IR.getprop(GOOG_MODULE.cloneTree(), "get");
    private static final Node GOOG_PROVIDE = IR.getprop(IR.name("goog"), "provide");
    private static final Node GOOG_REQUIRE = IR.getprop(IR.name("goog"), "require");
    private static final Node GOOG_REQUIRETYPE = IR.getprop(IR.name("goog"), "requireType");
    private static final Node GOOG_REQUIREDYNAMIC = IR.getprop(IR.name("goog"), "requireDynamic");
    private static final String GOOG_REQUIREDYNAMIC_NAME = "goog.requireDynamic";
    private static final String IMPORT_HANDLER_NAME = "importHandler_";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final boolean preserveSugar;
    private final LinkedHashMap<String, Node> syntheticExterns = new LinkedHashMap();
    private @Nullable Scope globalScope = null;
    private final Deque<ScriptDescription> scriptStack = new ArrayDeque<ScriptDescription>();
    private @Nullable ScriptDescription currentScript = null;
    private final GlobalRewriteState rewriteState = new GlobalRewriteState();
    private final Set<String> legacyScriptNamespacesAndPrefixes = new LinkedHashSet<String>();
    private final List<UnrecognizedRequire> unrecognizedRequires = new ArrayList<UnrecognizedRequire>();
    private final ArrayList<Node> googModuleGetCalls = new ArrayList();
    private final ArrayList<Node> googRequireDynamicCalls = new ArrayList();
    private final @Nullable TypedScope globalTypedScope;

    static String getBinaryModuleNamespace(String namespaceId) {
        return MODULE_EXPORTS_PREFIX + namespaceId.replace('.', '$');
    }

    private void rewriteJsdoc(JSDocInfo info, Scope scope) {
        ReplaceJsDocRefs replacer = new ReplaceJsDocRefs(scope);
        for (Node typeNode : info.getTypeNodes()) {
            NodeUtil.visitPreOrder(typeNode, replacer);
        }
    }

    ClosureRewriteModule(AbstractCompiler compiler, PreprocessorSymbolTable preprocessorSymbolTable, @Nullable TypedScope globalTypedScope) {
        Preconditions.checkArgument((globalTypedScope == null || globalTypedScope.isGlobal() ? 1 : 0) != 0);
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.preserveSugar = compiler.getOptions().shouldPreserveGoogModule();
        this.globalTypedScope = globalTypedScope;
    }

    @Override
    public void process(Node externs, Node root) {
        ArrayDeque<ScriptDescription> scriptDescriptions = new ArrayDeque<ScriptDescription>();
        for (Node parent : ImmutableList.of((Object)externs, (Object)root)) {
            for (Node script = parent.getFirstChild(); script != null; script = script.getNext()) {
                Preconditions.checkState((boolean)script.isScript(), (Object)script);
                NodeTraversal.traverse(this.compiler, script, new UnwrapGoogLoadModule());
                this.pushScript(new ScriptDescription());
                this.currentScript.rootNode = script;
                scriptDescriptions.addLast(this.currentScript);
                NodeTraversal.traverse(this.compiler, script, new ScriptPreprocessor());
                NodeTraversal.traverse(this.compiler, script, new ScriptRecorder());
                this.popScript();
            }
        }
        this.reportUnrecognizedRequires();
        if (this.compiler.hasHaltingErrors()) {
            return;
        }
        NodeTraversal.traverseRoots(this.compiler, new ScriptUpdater(scriptDescriptions), externs, root);
        this.declareSyntheticExterns();
        this.googModuleGetCalls.forEach(this::updateGoogModuleGetCall);
        this.googRequireDynamicCalls.forEach(this::updateGoogRequireDynamicCall);
    }

    private void declareSyntheticExterns() {
        ImmutableList vars = (ImmutableList)this.syntheticExterns.values().stream().filter(lhs -> !this.isNameInGlobalScope(lhs.getString())).map(lhs -> IR.var(this.astFactory.createNameWithUnknownType(lhs.getString())).srcrefTree((Node)lhs)).collect(ImmutableList.toImmutableList());
        if (vars.isEmpty()) {
            return;
        }
        Node root = this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
        vars.forEach(root::addChildToBack);
    }

    private boolean isNameInGlobalScope(String name) {
        return this.legacyScriptNamespacesAndPrefixes.contains(name) || this.globalScope.getVar(name) != null;
    }

    private void preprocessExportDeclaration(NodeTraversal t, Node n) {
        if (!(ClosureRewriteModule.isGoogModuleExportsRef(t, n) && ClosureRewriteModule.isAssignTarget(n) && n.getGrandparent().isExprResult())) {
            return;
        }
        Preconditions.checkState((this.currentScript.defaultExport == null ? 1 : 0) != 0);
        Node exportRhs = n.getNext();
        if (NodeUtil.isNamedExportsLiteral(exportRhs)) {
            Node insertionPoint = n.getGrandparent();
            for (Node key = exportRhs.getFirstChild(); key != null; key = key.getNext()) {
                String exportName = key.getString();
                JSDocInfo jsdoc = key.getJSDocInfo();
                Node rhs = key.removeFirstChild();
                Node lhs = this.astFactory.createGetProp(this.astFactory.createName("exports", AstFactory.type(n)), exportName, AstFactory.type(rhs)).srcrefTree(key);
                Node newExport = IR.exprResult(this.astFactory.createAssign(lhs, rhs).srcref(key).setJSDocInfo(jsdoc)).srcref(key);
                newExport.insertAfter(insertionPoint);
                insertionPoint = newExport;
            }
            n.getGrandparent().detach();
        }
    }

    private void recordModuleBody(Node moduleRoot) {
        this.pushScript(new ScriptDescription());
        this.currentScript.rootNode = moduleRoot;
        this.currentScript.isModule = true;
    }

    private void recordGoogModule(NodeTraversal t, Node call) {
        String namespaceId;
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isStringLit()) {
            t.report(namespaceIdNode, INVALID_MODULE_ID_ARG, new String[0]);
            return;
        }
        this.currentScript.namespaceId = namespaceId = namespaceIdNode.getString();
        this.currentScript.contentsPrefix = ClosureRewriteModule.toModuleContentsPrefix(namespaceId);
        Node scriptNode = NodeUtil.getEnclosingScript(this.currentScript.rootNode);
        this.rewriteState.scriptDescriptionsByGoogModuleNamespace.put(namespaceId, this.currentScript);
        this.rewriteState.namespaceIdsByScriptNode.put((Object)scriptNode, (Object)namespaceId);
    }

    private void recordGoogDeclareLegacyNamespace() {
        this.currentScript.declareLegacyNamespace = true;
        this.updateLegacyScriptNamespacesAndPrefixes(this.currentScript.namespaceId);
    }

    private void updateLegacyScriptNamespacesAndPrefixes(String namespace) {
        this.legacyScriptNamespacesAndPrefixes.add(namespace);
        int dot = namespace.lastIndexOf(46);
        while (dot != -1) {
            namespace = namespace.substring(0, dot);
            this.legacyScriptNamespacesAndPrefixes.add(namespace);
            dot = namespace.lastIndexOf(46);
        }
    }

    private void recordGoogProvide(NodeTraversal t, Node call) {
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isStringLit()) {
            t.report(namespaceIdNode, INVALID_PROVIDE_NAMESPACE, new String[0]);
            return;
        }
        String namespaceId = namespaceIdNode.getString();
        if (this.currentScript.isModule) {
            t.report(namespaceIdNode, INVALID_PROVIDE_CALL, new String[0]);
        }
        Node scriptNode = NodeUtil.getEnclosingScript(call);
        this.rewriteState.providedNamespaces.add(namespaceId);
        this.rewriteState.namespaceIdsByScriptNode.put((Object)scriptNode, (Object)namespaceId);
        this.updateLegacyScriptNamespacesAndPrefixes(namespaceId);
    }

    private void recordGoogRequire(NodeTraversal t, Node call, boolean mustBeOrdered) {
        ClosureRewriteModule.maybeSplitMultiVar(call);
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isStringLit()) {
            t.report(namespaceIdNode, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
            return;
        }
        String namespaceId = namespaceIdNode.getString();
        boolean targetIsAModule = this.rewriteState.containsModule(namespaceId);
        boolean targetIsALegacyScript = this.rewriteState.providedNamespaces.contains(namespaceId);
        if (this.currentScript.isModule && !targetIsAModule && !targetIsALegacyScript) {
            this.unrecognizedRequires.add(new UnrecognizedRequire(call, namespaceId, mustBeOrdered));
        }
    }

    private void recordGoogRequireType(NodeTraversal t, Node call) {
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isStringLit()) {
            t.report(namespaceIdNode, ClosurePrimitiveErrors.INVALID_REQUIRE_TYPE_NAMESPACE, new String[0]);
            return;
        }
        this.recordGoogRequire(t, call, false);
    }

    private void recordGoogForwardDeclare(NodeTraversal t, Node call) {
        Node namespaceNode = call.getLastChild();
        if (!call.hasTwoChildren() || !namespaceNode.isStringLit()) {
            t.report(namespaceNode, ClosurePrimitiveErrors.INVALID_FORWARD_DECLARE_NAMESPACE, new String[0]);
            return;
        }
        boolean mustBeOrdered = false;
        this.recordGoogRequire(t, call, mustBeOrdered);
    }

    private void recordGoogRequireDynamic(NodeTraversal t, Node call) {
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isStringLit()) {
            t.report(namespaceIdNode, ClosurePrimitiveErrors.INVALID_REQUIRE_DYNAMIC, new String[0]);
            return;
        }
        String namespaceId = namespaceIdNode.getString();
        if (!this.rewriteState.containsModule(namespaceId)) {
            this.unrecognizedRequires.add(new UnrecognizedRequire(call, namespaceId, false));
        }
        this.googRequireDynamicCalls.add(call);
    }

    private void recordGoogModuleGet(NodeTraversal t, Node call) {
        boolean isFillingAnAlias;
        Node namespaceIdNode = call.getLastChild();
        if (!call.hasTwoChildren() || !namespaceIdNode.isStringLit()) {
            t.report(namespaceIdNode, ClosurePrimitiveErrors.INVALID_GET_NAMESPACE, new String[0]);
            return;
        }
        String namespaceId = namespaceIdNode.getString();
        if (!this.rewriteState.containsModule(namespaceId)) {
            this.unrecognizedRequires.add(new UnrecognizedRequire(call, namespaceId, false));
        }
        this.googModuleGetCalls.add(call);
        Node maybeAssign = call.getParent();
        boolean bl = isFillingAnAlias = maybeAssign.isAssign() && maybeAssign.getFirstChild().isName() && maybeAssign.getParent().isExprResult();
        if (!isFillingAnAlias || !this.currentScript.isModule) {
            return;
        }
        String aliasName = call.getParent().getFirstChild().getString();
        Var aliasVar = (Var)t.getScope().getVar(aliasName);
        if (aliasVar == null) {
            return;
        }
        Node aliasVarNodeRhs = NodeUtil.getRValueOfLValue(aliasVar.getNode());
        if (aliasVarNodeRhs == null || !NodeUtil.isCallTo(aliasVarNodeRhs, GOOG_FORWARDDECLARE) || !namespaceId.equals(aliasVarNodeRhs.getLastChild().getString())) {
            return;
        }
        this.compiler.reportChangeToEnclosingScope(maybeAssign);
        maybeAssign.getParent().detach();
        this.googModuleGetCalls.remove(this.googModuleGetCalls.size() - 1);
    }

    private void recordTopLevelClassOrFunctionName(Node classOrFunctionNode) {
        Node nameNode = classOrFunctionNode.getFirstChild();
        if (nameNode.isName() && !Strings.isNullOrEmpty((String)nameNode.getString())) {
            String name = nameNode.getString();
            this.currentScript.topLevelNames.add(name);
        }
    }

    private void recordTopLevelVarNames(Node varNode) {
        NodeUtil.visitLhsNodesInNode(varNode, lhs -> this.currentScript.topLevelNames.add(lhs.getString()));
    }

    private void maybeRecordExportDeclaration(NodeTraversal t, Node n) {
        ExportDefinition defaultExport;
        Node exportRhs;
        if (!(this.currentScript.isModule && ClosureRewriteModule.isGoogModuleExportsRef(t, n) && ClosureRewriteModule.isAssignTarget(n))) {
            return;
        }
        if (this.currentScript.defaultExport != null) {
            ExportDefinition previousExport = this.currentScript.defaultExport;
            String localName = previousExport.getLocalName();
            if (localName != null && this.currentScript.namesToInlineByAlias.containsKey(localName)) {
                this.currentScript.namesToInlineByAlias.remove(localName);
            }
            this.currentScript.defaultExportLocalName = null;
        }
        Preconditions.checkState((!NodeUtil.isNamedExportsLiteral(exportRhs = n.getNext()) ? 1 : 0) != 0, (Object)"Exports object should have been converted already");
        this.currentScript.willCreateExportsObject = true;
        this.currentScript.defaultExport = defaultExport = ExportDefinition.newDefaultExport(t, exportRhs);
        if (!this.currentScript.declareLegacyNamespace && defaultExport.hasInlinableName(this.currentScript.exportsToInline.keySet())) {
            String localName;
            this.currentScript.defaultExportLocalName = localName = defaultExport.getLocalName();
            this.recordExportToInline(defaultExport);
        }
    }

    private void updateModuleBodyEarly(Node moduleScopeRoot) {
        this.pushScript(this.currentScript.removeFirstChildScript());
        this.currentScript.rootNode = moduleScopeRoot;
    }

    private void updateGoogModule(NodeTraversal t, Node call) {
        if (!this.currentScript.isModule) {
            this.compiler.reportChangeToEnclosingScope(call);
            Node undefined = this.astFactory.createVoid(this.astFactory.createNumber(0.0)).srcrefTree(call);
            call.replaceWith(undefined);
            return;
        }
        if (this.currentScript.declareLegacyNamespace) {
            call.getFirstChild().setString("provide");
            this.compiler.reportChangeToEnclosingScope(call);
        }
        if (!this.currentScript.willCreateExportsObject) {
            Preconditions.checkState((!this.currentScript.hasCreatedExportObject ? 1 : 0) != 0, (Object)this.currentScript);
            this.exportTheEmptyBinaryNamespaceAt(NodeUtil.getEnclosingStatement(call), AddAt.AFTER, t);
        }
        if (!this.currentScript.declareLegacyNamespace && !this.preserveSugar) {
            this.compiler.reportChangeToEnclosingScope(call);
            NodeUtil.getEnclosingStatement(call).detach();
        }
    }

    private static void updateGoogDeclareLegacyNamespace(Node call) {
        NodeUtil.getEnclosingStatement(call).detach();
    }

    private void updateGoogRequire(NodeTraversal t, Node call) {
        Node namespaceIdNode = call.getLastChild();
        Node statementNode = NodeUtil.getEnclosingStatement(call);
        String namespaceId = namespaceIdNode.getString();
        boolean targetIsNonLegacyGoogModule = this.rewriteState.containsModule(namespaceId) && !this.rewriteState.isLegacyModule(namespaceId);
        boolean importHasAlias = NodeUtil.isNameDeclaration(statementNode);
        boolean isDestructuring = statementNode.getFirstChild().isDestructuringLhs();
        boolean currentScriptIsAModule = this.currentScript.isModule;
        boolean requireDirectlyStoredInAlias = NodeUtil.isNameDeclaration(call.getGrandparent());
        if (currentScriptIsAModule && requireDirectlyStoredInAlias && this.isTopLevel(t, statementNode, ScopeType.EXEC_CONTEXT)) {
            Node lhs = call.getParent();
            String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(namespaceId);
            if (exportedNamespace != null) {
                if (lhs.isName()) {
                    String aliasName = statementNode.getFirstChild().getString();
                    this.recordNameToInline(aliasName, exportedNamespace, namespaceId);
                    this.maybeAddAliasToSymbolTable(statementNode.getFirstChild(), this.currentScript.namespaceId);
                } else if (lhs.isDestructuringLhs() && lhs.getFirstChild().isObjectPattern()) {
                    this.maybeWarnForInvalidDestructuring(t, lhs.getParent(), namespaceId);
                    for (Node importSpec = lhs.getFirstFirstChild(); importSpec != null; importSpec = importSpec.getNext()) {
                        Preconditions.checkState((boolean)importSpec.hasChildren(), (Object)importSpec);
                        String importedProperty = importSpec.getString();
                        Node aliasNode = importSpec.getFirstChild();
                        String aliasName = aliasNode.getString();
                        String fullName = exportedNamespace + "." + importedProperty;
                        this.recordNameToInline(aliasName, fullName, null);
                        this.maybeAddAliasToSymbolTable(aliasNode, this.currentScript.namespaceId);
                        this.safeSetString(aliasNode, this.currentScript.contentsPrefix + aliasName);
                    }
                } else {
                    throw new RuntimeException("Illegal goog.module import: " + lhs);
                }
            }
        }
        if (this.currentScript.isModule || targetIsNonLegacyGoogModule) {
            if (isDestructuring) {
                if (!this.preserveSugar) {
                    this.compiler.reportChangeToEnclosingScope(statementNode);
                    statementNode.detach();
                }
            } else if (targetIsNonLegacyGoogModule) {
                Preconditions.checkState((boolean)this.isTopLevel(t, statementNode, ScopeType.EXEC_CONTEXT), (String)"Unexpected non-top-level require at %s", (Object)call);
                if (!(!importHasAlias && this.rewriteState.isLegacyModule(namespaceId) || this.preserveSugar)) {
                    this.compiler.reportChangeToEnclosingScope(statementNode);
                    statementNode.detach();
                }
            } else {
                call.detach();
                statementNode.replaceWith(IR.exprResult(call));
                this.compiler.reportChangeToEnclosingScope(call);
            }
        }
    }

    private void maybeWarnForInvalidDestructuring(NodeTraversal t, Node importNode, String importedNamespace) {
        Preconditions.checkArgument((boolean)importNode.getFirstChild().isDestructuringLhs(), (Object)importNode);
        ScriptDescription importedModule = this.rewriteState.scriptDescriptionsByGoogModuleNamespace.get(importedNamespace);
        if (importedModule == null) {
            return;
        }
        if (importedModule.defaultExport != null) {
            t.report(importNode, ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT, new String[0]);
            return;
        }
        Node objPattern = importNode.getFirstFirstChild();
        for (Node key = objPattern.getFirstChild(); key != null; key = key.getNext()) {
            String exportName = key.getString();
            if (importedModule.namedExports.contains(exportName)) continue;
            t.report(importNode, ILLEGAL_DESTRUCTURING_NOT_EXPORTED, exportName, importedNamespace);
        }
    }

    private void updateGoogForwardDeclare(NodeTraversal t, Node call) {
        this.updateGoogRequire(t, call);
    }

    private void updateGoogRequireDynamicCall(Node call) {
        Node parent = call.getParent();
        Preconditions.checkState((parent.isAwait() || parent.isGetProp() && parent.getString().equals("then") ? 1 : 0) != 0, (Object)"goog.requireDynamic() in only allowed in await/then expression");
        if (parent.isAwait()) {
            this.updateGoogRequireDynamicCallInAwait(call);
        } else {
            this.updateGoogRequireDynamicCallInThen(call);
        }
    }

    private void updateGoogRequireDynamicCallInThen(Node call) {
        Node namespaceIdNode = call.getSecondChild();
        String namespaceId = namespaceIdNode.getString();
        String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(namespaceId);
        Preconditions.checkState((exportedNamespace != null ? 1 : 0) != 0, (Object)"Exported namespace for goog.requireDynamic() canot be null");
        Node getProp = call.getParent();
        Node thenCallNode = getProp.getParent();
        Preconditions.checkState((thenCallNode != null && thenCallNode.isCall() ? 1 : 0) != 0, (Object)"must be a 'then' call expression");
        Node argNode = this.astFactory.createString(this.namespaceIdToXid(namespaceId)).srcref(namespaceIdNode);
        namespaceIdNode.replaceWith(argNode);
        Node calleeNode = call.getFirstChild();
        Preconditions.checkState((boolean)calleeNode.matchesQualifiedName(GOOG_REQUIREDYNAMIC_NAME), (Object)calleeNode);
        calleeNode.setString(IMPORT_HANDLER_NAME);
        Node exportedNamespaceNameNode = this.astFactory.createName(this.globalTypedScope, exportedNamespace).srcrefTree(call);
        exportedNamespaceNameNode.setOriginalName(namespaceId);
        Node functionNode = thenCallNode.getSecondChild();
        Preconditions.checkState((functionNode != null && functionNode.isFunction() ? 1 : 0) != 0, (Object)"must be a function in `then`");
        Node paramListNode = functionNode.getSecondChild();
        Preconditions.checkState((paramListNode.getChildCount() == 1 ? 1 : 0) != 0, (Object)"function must have only one parameter");
        Node functionBody = paramListNode.getNext();
        Node objectPatternOrNameNode = paramListNode.getOnlyChild();
        Preconditions.checkState((objectPatternOrNameNode.isObjectPattern() || objectPatternOrNameNode.isName() ? 1 : 0) != 0, (Object)"parameter of callback function must be object pattern or name");
        objectPatternOrNameNode.detach();
        paramListNode.removeChildren();
        CompilerOptions.LanguageMode languageIn = this.compiler.getOptions().getLanguageIn();
        Preconditions.checkState((boolean)languageIn.toFeatureSet().contains(FeatureSet.Feature.CONST_DECLARATIONS), (String)"'%s' does not contain '%s'", (Object)((Object)languageIn), (Object)((Object)FeatureSet.Feature.CONST_DECLARATIONS));
        Node enclosingScript = NodeUtil.getEnclosingScript(call);
        NodeUtil.addFeatureToScript(enclosingScript, FeatureSet.Feature.CONST_DECLARATIONS, this.compiler);
        Node declarationNode = objectPatternOrNameNode.isObjectPattern() ? this.astFactory.createSingleConstObjectPatternDeclaration(objectPatternOrNameNode, exportedNamespaceNameNode).srcrefTreeIfMissing(call) : this.astFactory.createSingleConstNameDeclaration(objectPatternOrNameNode.getString(), exportedNamespaceNameNode).srcrefTreeIfMissing(call);
        if (functionBody.isBlock()) {
            functionBody.addChildToFront(declarationNode);
            this.compiler.reportChangeToEnclosingScope(declarationNode);
        } else {
            Node returnStmt = this.astFactory.createReturn(functionBody.detach());
            Node newBlock = this.astFactory.createBlock(returnStmt).srcrefTree(call);
            newBlock.insertAfter(paramListNode);
            newBlock.addChildToFront(declarationNode);
            this.compiler.reportChangeToEnclosingScope(newBlock);
        }
        this.compiler.reportChangeToEnclosingScope(call);
    }

    private void updateGoogRequireDynamicCallInAwait(Node call) {
        Node declarationStatement;
        Node namespaceIdNode = call.getSecondChild();
        String namespaceId = namespaceIdNode.getString();
        String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(namespaceId);
        Preconditions.checkState((exportedNamespace != null ? 1 : 0) != 0, (Object)"Exported namespace for goog.requireDynamic() cannot be null");
        Node existingAwait = call.getParent();
        Preconditions.checkState((boolean)existingAwait.isAwait(), (Object)"Only goog.requireDynamic() in await expression is supported now");
        Node awaitParent = existingAwait.getParent();
        if (awaitParent == null || !awaitParent.isDestructuringLhs() && !awaitParent.isName()) {
            this.compiler.report(JSError.make(call, ILLEGAL_STMT_OF_GOOG_REQUIRE_DYNAMIC_IN_AWAIT, new String[0]));
        }
        if (!NodeUtil.isNameDeclaration(declarationStatement = awaitParent.getParent()) || !NodeUtil.isStatement(declarationStatement)) {
            this.compiler.report(JSError.make(call, ILLEGAL_STMT_OF_GOOG_REQUIRE_DYNAMIC_IN_AWAIT, new String[0]));
        }
        Node exportedNamespaceNameNode = this.astFactory.createQName((StaticScope)this.globalTypedScope, exportedNamespace).srcrefTree(call);
        exportedNamespaceNameNode.setJSType(this.rewriteState.getGoogModuleNamespaceType(namespaceId));
        exportedNamespaceNameNode.setOriginalName(namespaceId);
        Node argNode = this.astFactory.createString(this.namespaceIdToXid(namespaceId)).srcref(namespaceIdNode);
        namespaceIdNode.replaceWith(argNode);
        Node calleeNode = call.getFirstChild();
        Preconditions.checkState((boolean)calleeNode.matchesQualifiedName(GOOG_REQUIREDYNAMIC_NAME), (Object)calleeNode);
        calleeNode.setString(IMPORT_HANDLER_NAME);
        existingAwait.replaceWith(exportedNamespaceNameNode);
        Node awaitStatement = this.astFactory.exprResult(existingAwait).srcref(existingAwait);
        awaitStatement.insertBefore(declarationStatement);
        this.compiler.reportChangeToEnclosingScope(call);
    }

    private String namespaceIdToXid(String namespaceId) {
        Xid.HashFunction hashFunction = this.compiler.getOptions().chunkIdHashFunction;
        Xid xid = hashFunction == null ? new Xid() : new Xid(hashFunction);
        return xid.get(namespaceId);
    }

    private void updateGoogModuleGetCall(Node call) {
        Node namespaceIdNode = call.getSecondChild();
        String namespaceId = namespaceIdNode.getString();
        String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(namespaceId);
        if (exportedNamespace != null) {
            this.compiler.reportChangeToEnclosingScope(call);
            Node exportedNamespaceName = this.astFactory.createQNameFromTypedScope(this.globalTypedScope, exportedNamespace).srcrefTree(call);
            exportedNamespaceName.setJSType(this.rewriteState.getGoogModuleNamespaceType(namespaceId));
            exportedNamespaceName.setOriginalName(namespaceId);
            call.replaceWith(exportedNamespaceName);
        }
    }

    private void recordExportsPropertyAssignment(NodeTraversal t, Node getpropNode) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = getpropNode.getParent();
        Preconditions.checkState((parent.isAssign() || parent.isExprResult() ? 1 : 0) != 0, (Object)parent);
        Node exportsNameNode = getpropNode.getFirstChild();
        Preconditions.checkState((boolean)exportsNameNode.getString().equals("exports"), (Object)exportsNameNode);
        if (t.inModuleScope()) {
            String exportName = getpropNode.getString();
            this.currentScript.namedExports.add(exportName);
            Node exportRhs = getpropNode.getNext();
            ExportDefinition namedExport = ExportDefinition.newNamedExport(t, exportName, exportRhs);
            if (!this.currentScript.declareLegacyNamespace && this.currentScript.defaultExport == null && namedExport.hasInlinableName(this.currentScript.exportsToInline.keySet())) {
                this.recordExportToInline(namedExport);
                parent.getParent().detach();
            }
        }
    }

    private void updateExportsPropertyAssignment(Node getpropNode, NodeTraversal t) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = getpropNode.getParent();
        Preconditions.checkState((parent.isAssign() || parent.isExprResult() ? 1 : 0) != 0, (Object)parent);
        Node exportsNameNode = getpropNode.getFirstChild();
        Preconditions.checkState((boolean)exportsNameNode.getString().equals("exports"));
        String exportedNamespace = this.currentScript.getExportedNamespace();
        this.safeSetMaybeQualifiedString(exportsNameNode, exportedNamespace, false);
        Node jsdocNode = parent.isAssign() ? parent : getpropNode;
        ClosureRewriteModule.markConstAndCopyJsDoc(jsdocNode, jsdocNode);
        if (!this.currentScript.hasCreatedExportObject) {
            this.exportTheEmptyBinaryNamespaceAt(NodeUtil.getEnclosingStatement(parent), AddAt.BEFORE, t);
        }
    }

    private void maybeUpdateTopLevelName(NodeTraversal t, Node nameNode) {
        Node destructuringLhsNode;
        String name = nameNode.getString();
        if (!this.currentScript.isModule || !this.currentScript.topLevelNames.contains(name)) {
            return;
        }
        Var var = (Var)t.getScope().getVar(name);
        if (var == null || ((Scope)var.getScope()).getRootNode() != this.currentScript.rootNode) {
            return;
        }
        if (var.getNameNode() == nameNode && nameNode.getParent().isStringKey() && nameNode.getGrandparent().isObjectPattern() && (NodeUtil.isCallTo((destructuringLhsNode = nameNode.getGrandparent().getParent()).getLastChild(), GOOG_REQUIRE) || NodeUtil.isCallTo(destructuringLhsNode.getLastChild(), GOOG_REQUIRETYPE))) {
            return;
        }
        boolean nameIsAnAlias = this.currentScript.namesToInlineByAlias.containsKey(name);
        if (nameIsAnAlias && var.getNode() != nameNode) {
            this.maybeAddAliasToSymbolTable(nameNode, this.currentScript.namespaceId);
            AliasName inline = this.currentScript.namesToInlineByAlias.get(name);
            String namespaceToInline = inline.newName;
            if (namespaceToInline.equals(this.currentScript.getBinaryNamespace())) {
                this.currentScript.hasCreatedExportObject = true;
            }
            boolean isModuleNamespace = inline.namespaceId != null && this.rewriteState.scriptDescriptionsByGoogModuleNamespace.containsKey(inline.namespaceId) && !this.rewriteState.scriptDescriptionsByGoogModuleNamespace.get((Object)inline.namespaceId).willCreateExportsObject;
            this.safeSetMaybeQualifiedString(nameNode, namespaceToInline, isModuleNamespace);
            if (namespaceToInline.indexOf(46) != -1) {
                String firstQualifiedName = namespaceToInline.substring(0, namespaceToInline.indexOf(46));
                Var shadowedVar = (Var)t.getScope().getVar(firstQualifiedName);
                if (shadowedVar == null || shadowedVar.isGlobal() || ((Scope)shadowedVar.getScope()).isModuleScope()) {
                    return;
                }
                t.report(shadowedVar.getNode(), IMPORT_INLINING_SHADOWS_VAR, shadowedVar.getName(), namespaceToInline);
            }
            return;
        }
        this.safeSetString(nameNode, this.currentScript.contentsPrefix + name);
    }

    private void maybeUpdateExportObjectLiteral(NodeTraversal t, Node n) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = n.getParent();
        Node rhs = parent.getLastChild();
        if (rhs.isObjectLit()) {
            for (Node c = rhs.getFirstChild(); c != null; c = c.getNext()) {
                if (c.isComputedProp()) {
                    t.report(c, INVALID_EXPORT_COMPUTED_PROPERTY, new String[0]);
                    continue;
                }
                if (!c.isStringKey()) continue;
                Node value = c.getFirstChild();
                this.maybeUpdateExportDeclToNode(t, c, value);
            }
        }
    }

    private void maybeUpdateExportDeclToNode(NodeTraversal t, Node target, Node value) {
        if (!this.currentScript.isModule) {
            return;
        }
        if (value.isName()) {
            JSDocInfo info;
            StaticScope varScope;
            Scope currentScope = t.getScope();
            Var v = (Var)t.getScope().getVar(value.getString());
            if (v != null && ((AbstractScope)(varScope = v.getScope())).getDepth() == currentScope.getDepth() && (info = v.getJSDocInfo()) != null && info.hasTypedefType()) {
                JSDocInfo.Builder builder = JSDocInfo.Builder.copyFrom(info);
                target.setJSDocInfo(builder.build());
                return;
            }
        }
        ClosureRewriteModule.markConstAndCopyJsDoc(target, target);
    }

    private void maybeUpdateExportDeclaration(NodeTraversal t, Node n) {
        Node jsdocNode;
        if (!(this.currentScript.isModule && ClosureRewriteModule.isGoogModuleExportsRef(t, n) && ClosureRewriteModule.isAssignTarget(n))) {
            return;
        }
        Node assignNode = n.getParent();
        Node rhs = assignNode.getLastChild();
        if (rhs != this.currentScript.defaultExport.rhs) {
            assignNode.replaceWith(rhs.detach());
            return;
        }
        if (!this.currentScript.declareLegacyNamespace && this.currentScript.defaultExportLocalName != null) {
            assignNode.getParent().detach();
            Node binaryNamespaceName = this.astFactory.createName(this.currentScript.getBinaryNamespace(), AstFactory.type(n));
            this.declareGlobalVariable(binaryNamespaceName, t);
            return;
        }
        if (this.currentScript.declareLegacyNamespace) {
            Node legacyQname = this.astFactory.createQName((StaticScope)this.globalTypedScope, this.currentScript.namespaceId).srcrefTree(n);
            legacyQname.setJSType(n.getJSType());
            n.replaceWith(legacyQname);
            jsdocNode = assignNode;
        } else {
            rhs.detach();
            Node exprResultNode = assignNode.getParent();
            Node binaryNamespaceName = this.astFactory.createName(this.currentScript.getBinaryNamespace(), AstFactory.type(n));
            binaryNamespaceName.setOriginalName("exports");
            this.declareGlobalVariable(binaryNamespaceName, t);
            Node exportsObjectCreationNode = IR.var(binaryNamespaceName, rhs);
            exportsObjectCreationNode.srcrefTreeIfMissing(exprResultNode);
            exportsObjectCreationNode.putBooleanProp(Node.IS_NAMESPACE, true);
            exprResultNode.replaceWith(exportsObjectCreationNode);
            jsdocNode = exportsObjectCreationNode;
            this.currentScript.hasCreatedExportObject = true;
        }
        ClosureRewriteModule.markConstAndCopyJsDoc(assignNode, jsdocNode);
        this.compiler.reportChangeToEnclosingScope(jsdocNode);
        this.maybeUpdateExportObjectLiteral(t, rhs);
    }

    private void maybeUpdateExportNameRef(NodeTraversal t, Node n) {
        if (!this.currentScript.isModule || !ClosureRewriteModule.isGoogModuleExportsRef(t, n) || n.getParent() == null) {
            return;
        }
        if (n.getParent().isParamList()) {
            return;
        }
        if (this.currentScript.declareLegacyNamespace) {
            Node legacyQname = this.astFactory.createQName((StaticScope)this.globalTypedScope, this.currentScript.namespaceId).srcrefTree(n);
            legacyQname.setJSType(n.getJSType());
            n.replaceWith(legacyQname);
            this.compiler.reportChangeToEnclosingScope(legacyQname);
            return;
        }
        this.safeSetString(n, this.currentScript.getBinaryNamespace());
        Preconditions.checkState((this.currentScript.willCreateExportsObject || this.currentScript.hasCreatedExportObject ? 1 : 0) != 0);
    }

    void updateModuleBody(Node moduleBody) {
        Preconditions.checkArgument((moduleBody.isModuleBody() && moduleBody.getParent().getBooleanProp(Node.GOOG_MODULE) ? 1 : 0) != 0, (Object)moduleBody);
        moduleBody.setToken(Token.BLOCK);
        NodeUtil.tryMergeBlock(moduleBody, true);
        for (ExportDefinition export : this.currentScript.exportsToInline.values()) {
            Node nameNode = export.nameDecl.getNameNode();
            this.safeSetMaybeQualifiedString(nameNode, this.currentScript.getBinaryNamespace() + export.getExportPostfix(), false);
        }
        Preconditions.checkState((boolean)this.currentScript.isModule, (Object)this.currentScript);
        Preconditions.checkState((this.currentScript.declareLegacyNamespace || this.currentScript.hasCreatedExportObject ? 1 : 0) != 0, (Object)this.currentScript);
        this.popScript();
    }

    private void pushScript(ScriptDescription newCurrentScript) {
        this.currentScript = newCurrentScript;
        if (!this.scriptStack.isEmpty()) {
            ScriptDescription parentScript = this.scriptStack.peek();
            parentScript.addChildScript(this.currentScript);
        }
        this.scriptStack.addFirst(this.currentScript);
    }

    private void popScript() {
        this.scriptStack.removeFirst();
        this.currentScript = this.scriptStack.peekFirst();
    }

    private void exportTheEmptyBinaryNamespaceAt(Node atNode, AddAt addAt, NodeTraversal t) {
        if (this.currentScript.declareLegacyNamespace) {
            return;
        }
        String binaryNamespaceString = this.currentScript.getBinaryNamespace();
        AstFactory.Type moduleType = AstFactory.type(this.currentScript.rootNode);
        Node binaryNamespaceName = this.astFactory.createName(binaryNamespaceString, moduleType);
        binaryNamespaceName.setOriginalName(this.currentScript.namespaceId);
        this.declareGlobalVariable(binaryNamespaceName, t);
        Node binaryNamespaceExportNode = IR.var(binaryNamespaceName, this.astFactory.createObjectLit(new Node[0]));
        if (addAt == AddAt.BEFORE) {
            binaryNamespaceExportNode.insertBefore(atNode);
        } else if (addAt == AddAt.AFTER) {
            binaryNamespaceExportNode.insertAfter(atNode);
        }
        binaryNamespaceExportNode.putBooleanProp(Node.IS_NAMESPACE, true);
        binaryNamespaceExportNode.srcrefTree(atNode);
        ClosureRewriteModule.markConst(binaryNamespaceExportNode);
        this.compiler.reportChangeToEnclosingScope(binaryNamespaceExportNode);
        this.currentScript.hasCreatedExportObject = true;
    }

    static void checkAndSetStrictModeDirective(NodeTraversal t, Node n) {
        Preconditions.checkState((boolean)n.isScript(), (Object)n);
        if (n.isUseStrict()) {
            t.report(n, USELESS_USE_STRICT_DIRECTIVE, new String[0]);
        } else {
            n.setUseStrict(true);
        }
    }

    private static void markConst(Node n) {
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(n.getJSDocInfo());
        builder.recordConstancy();
        n.setJSDocInfo(builder.build());
    }

    private static void maybeSplitMultiVar(Node rhsNode) {
        Node statementNode = rhsNode.getGrandparent();
        if (!statementNode.isVar() || !statementNode.hasMoreThanOneChild()) {
            return;
        }
        Node nameNode = rhsNode.getParent();
        nameNode.detach();
        rhsNode.detach();
        IR.var(nameNode, rhsNode).insertBefore(statementNode);
    }

    private static void markConstAndCopyJsDoc(Node from, Node target) {
        JSDocInfo info = from.getJSDocInfo();
        JSDocInfo.Builder builder = JSDocInfo.Builder.maybeCopyFrom(info);
        builder.recordConstancy();
        target.setJSDocInfo(builder.build());
    }

    private void recordExportToInline(ExportDefinition exportDefinition) {
        Preconditions.checkState((boolean)exportDefinition.hasInlinableName(this.currentScript.exportsToInline.keySet()), (String)"exportDefinition: %s\n\nexportsToInline keys: %s", (Object)exportDefinition, this.currentScript.exportsToInline.keySet());
        Preconditions.checkState((null == this.currentScript.exportsToInline.put(exportDefinition.nameDecl, exportDefinition) ? 1 : 0) != 0, (String)"Already found a mapping for inlining export: %s", (Object)exportDefinition.nameDecl);
        String localName = exportDefinition.getLocalName();
        String fullExportedName = this.currentScript.getBinaryNamespace() + exportDefinition.getExportPostfix();
        this.recordNameToInline(localName, fullExportedName, null);
    }

    private void recordNameToInline(String aliasName, String newName, @Nullable String namespaceId) {
        Preconditions.checkNotNull((Object)aliasName);
        Preconditions.checkNotNull((Object)newName);
        this.currentScript.namesToInlineByAlias.put(aliasName, new AliasName(newName, namespaceId));
    }

    private void reportUnrecognizedRequires() {
        for (UnrecognizedRequire unrecognizedRequire : this.unrecognizedRequires) {
            String namespaceId = unrecognizedRequire.namespaceId;
            Node requireNode = unrecognizedRequire.requireNode;
            boolean targetGoogModuleExists = this.rewriteState.containsModule(namespaceId);
            boolean targetLegacyScriptExists = this.rewriteState.providedNamespaces.contains(namespaceId);
            if (targetGoogModuleExists || targetLegacyScriptExists || this.preserveSugar || NodeUtil.getEnclosingScript(requireNode) == null) continue;
            this.compiler.reportChangeToEnclosingScope(requireNode);
            Node enclosingStatement = NodeUtil.getEnclosingStatement(requireNode);
            if (!NodeUtil.isNameDeclaration(enclosingStatement)) {
                requireNode.replaceWith(this.astFactory.createNull().srcref(requireNode));
                continue;
            }
            enclosingStatement.detach();
            NodeUtil.visitLhsNodesInNode(enclosingStatement, lhs -> this.syntheticExterns.putIfAbsent(lhs.getString(), (Node)lhs));
        }
    }

    private void safeSetString(Node n, String newString) {
        Node changeScope;
        if (n.getString().equals(newString)) {
            return;
        }
        String originalName = n.getString();
        n.setString(newString);
        if (n.getOriginalName() == null) {
            n.setOriginalName(originalName);
        }
        if ((changeScope = NodeUtil.getEnclosingChangeScopeRoot(n)) != null) {
            this.compiler.reportChangeToChangeScope(changeScope);
        }
    }

    private void safeSetMaybeQualifiedString(Node nameNode, String newString, boolean isModuleNamespace) {
        if (!newString.contains(".")) {
            this.safeSetString(nameNode, newString);
            Node parent = nameNode.getParent();
            if (isModuleNamespace && parent.isGetProp() && nameNode.getGrandparent().isCall() && parent.isFirstChildOf(nameNode.getGrandparent())) {
                nameNode.getGrandparent().putBooleanProp(Node.FREE_CALL, true);
            }
            return;
        }
        Node nameParent = nameNode.getParent();
        Node newQualifiedName = this.astFactory.createQNameFromTypedScope(this.globalTypedScope, newString).srcrefTree(nameNode);
        newQualifiedName.setJSType(nameNode.getJSType());
        boolean replaced = ClosureRewriteModule.safeSetStringIfDeclaration(nameParent, nameNode, newQualifiedName);
        if (replaced) {
            return;
        }
        nameNode.replaceWith(newQualifiedName);
        if (newQualifiedName.hasChildren()) {
            newQualifiedName.getFirstChild().makeNonIndexableRecursive();
        }
        this.compiler.reportChangeToEnclosingScope(newQualifiedName);
    }

    private static boolean safeSetStringIfDeclaration(Node nameParent, Node nameNode, Node newQualifiedName) {
        JSDocInfo jsdoc = nameParent.getJSDocInfo();
        switch (nameParent.getToken()) {
            case CLASS: 
            case FUNCTION: {
                if (!NodeUtil.isStatement(nameParent) || nameParent.getFirstChild() != nameNode) {
                    return false;
                }
                Node placeholder = IR.empty();
                nameParent.replaceWith(placeholder);
                Node newDeclaration = NodeUtil.getDeclarationFromName(newQualifiedName, nameParent, Token.VAR, jsdoc);
                if (NodeUtil.isExprAssign(newDeclaration)) {
                    Node assign = newDeclaration.getOnlyChild();
                    assign.setJSType(nameNode.getJSType());
                    ClosureRewriteModule.updateSourceInfoForExportedTopLevelVariable(assign, nameNode);
                }
                nameParent.setJSDocInfo(null);
                newDeclaration.srcrefTreeIfMissing(nameParent);
                placeholder.replaceWith(newDeclaration);
                NodeUtil.removeName(nameParent);
                return true;
            }
            case CONST: 
            case LET: 
            case VAR: {
                Node newStatement;
                Node rhs;
                Node node = rhs = nameNode.hasChildren() ? nameNode.getLastChild().detach() : null;
                if (jsdoc == null) {
                    jsdoc = nameNode.getJSDocInfo();
                }
                if (NodeUtil.isExprAssign(newStatement = NodeUtil.getDeclarationFromName(newQualifiedName, rhs, Token.VAR, jsdoc))) {
                    Node assign = newStatement.getOnlyChild();
                    assign.setJSType(nameNode.getJSType());
                    ClosureRewriteModule.updateSourceInfoForExportedTopLevelVariable(assign, nameNode);
                    if (nameParent.isConst()) {
                        JSDocInfo.Builder jsdocBuilder = JSDocInfo.Builder.maybeCopyFrom(jsdoc);
                        jsdocBuilder.recordConstancy();
                        jsdoc = jsdocBuilder.build();
                        assign.setJSDocInfo(jsdoc);
                    }
                }
                newStatement.srcrefTreeIfMissing(nameParent);
                NodeUtil.replaceDeclarationChild(nameNode, newStatement);
                return true;
            }
            case OBJECT_PATTERN: 
            case ARRAY_PATTERN: 
            case PARAM_LIST: {
                throw new RuntimeException("Not supported");
            }
        }
        return false;
    }

    private static void updateSourceInfoForExportedTopLevelVariable(Node assign, Node sourceName) {
        Preconditions.checkState((boolean)assign.isAssign());
        Preconditions.checkState((boolean)sourceName.isName());
        Node getProp = assign.getFirstChild();
        if (!getProp.isGetProp()) {
            return;
        }
        String name = sourceName.getOriginalName();
        if (name == null) {
            name = sourceName.getString();
        }
        sourceName = sourceName.cloneNode();
        sourceName.setLength(name.length());
        getProp.srcrefTree(sourceName);
    }

    private boolean isTopLevel(NodeTraversal t, Node n, ScopeType scopeType) {
        if (scopeType == ScopeType.EXEC_CONTEXT) {
            return t.inGlobalScope() || t.getClosestHoistScopeRoot() == this.currentScript.rootNode;
        }
        return n.getParent() == this.currentScript.rootNode;
    }

    private static String toModuleContentsPrefix(String namespaceId) {
        return MODULE_CONTENTS_PREFIX + namespaceId.replace('.', '$') + "_";
    }

    public static boolean isModuleExport(String name) {
        return name.startsWith(MODULE_EXPORTS_PREFIX);
    }

    public static boolean isModuleContent(String name) {
        return name.startsWith(MODULE_CONTENTS_PREFIX);
    }

    private static boolean isGoogModuleExportsRef(NodeTraversal t, Node target) {
        if (!target.isName() || !target.matchesName("exports")) {
            return false;
        }
        Var exportsVar = (Var)t.getScope().getVar("exports");
        return exportsVar != null && exportsVar.isGoogModuleExports();
    }

    private static boolean isExportPropertyAssignment(NodeTraversal t, Node n) {
        Node target = n.getFirstChild();
        return (ClosureRewriteModule.isAssignTarget(n) || ClosureRewriteModule.isTypedefTarget(n)) && ClosureRewriteModule.isGoogModuleExportsRef(t, target);
    }

    private static boolean isAssignTarget(Node n) {
        Node parent = n.getParent();
        return parent.isAssign() && parent.getFirstChild() == n;
    }

    private static boolean isTypedefTarget(Node n) {
        Node parent = n.getParent();
        return parent.isExprResult() && parent.getFirstChild() == n;
    }

    private void maybeAddAliasToSymbolTable(Node n, String module) {
        if (this.preprocessorSymbolTable != null) {
            n.putBooleanProp(Node.MODULE_ALIAS, true);
            String nodeName = n.isStringLit() ? n.getString() : this.preprocessorSymbolTable.getQualifiedName(n);
            String name = "alias_" + module + "_" + nodeName;
            this.preprocessorSymbolTable.addReference(n, name);
        }
    }

    private void declareGlobalVariable(Node n, NodeTraversal t) {
        Preconditions.checkState((boolean)n.isName());
        if (this.globalTypedScope == null) {
            return;
        }
        String name = n.getString();
        if (this.globalTypedScope.hasOwnSlot(name)) {
            t.report(t.getCurrentScript(), ILLEGAL_MODULE_RENAMING_CONFLICT, name);
        } else {
            JSType type = (JSType)Preconditions.checkNotNull((Object)n.getJSType());
            this.globalTypedScope.declare(name, n, type, t.getInput(), false);
        }
    }

    private class UnwrapGoogLoadModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private UnwrapGoogLoadModule() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case SCRIPT: {
                    return true;
                }
                case EXPR_RESULT: {
                    Node call = n.getFirstChild();
                    if (NodeUtil.isCallTo(call, GOOG_LOADMODULE) && call.getLastChild().isFunction()) {
                        parent.putBooleanProp(Node.GOOG_MODULE, true);
                        Node functionNode = call.getLastChild();
                        ClosureRewriteModule.this.compiler.reportFunctionDeleted(functionNode);
                        Node moduleBody = functionNode.getLastChild().detach();
                        moduleBody.setToken(Token.MODULE_BODY);
                        Node exportsParameter = NodeUtil.getFunctionParameters(functionNode).getOnlyChild();
                        moduleBody.setJSType(exportsParameter.getJSType());
                        n.replaceWith(moduleBody);
                        Node returnNode = moduleBody.getLastChild();
                        if (!returnNode.isReturn()) {
                            ClosureRewriteModule.this.compiler.report(JSError.make(moduleBody, LOAD_MODULE_FN_MISSING_RETURN, new String[0]));
                        } else {
                            returnNode.detach();
                        }
                        t.reportCodeChange();
                    }
                    return false;
                }
            }
            return false;
        }
    }

    private static final class GlobalRewriteState {
        private final Map<String, ScriptDescription> scriptDescriptionsByGoogModuleNamespace = new LinkedHashMap<String, ScriptDescription>();
        private final Multimap<Node, String> namespaceIdsByScriptNode = HashMultimap.create();
        private final Set<String> providedNamespaces = new LinkedHashSet<String>();

        private GlobalRewriteState() {
        }

        boolean containsModule(String namespaceId) {
            return this.scriptDescriptionsByGoogModuleNamespace.containsKey(namespaceId);
        }

        boolean isLegacyModule(String namespaceId) {
            Preconditions.checkArgument((boolean)this.containsModule(namespaceId));
            return this.scriptDescriptionsByGoogModuleNamespace.get((Object)namespaceId).declareLegacyNamespace;
        }

        @Nullable String getBinaryNamespace(String namespaceId) {
            ScriptDescription script = this.scriptDescriptionsByGoogModuleNamespace.get(namespaceId);
            return script == null ? null : script.getBinaryNamespace();
        }

        @Nullable JSType getGoogModuleNamespaceType(String namespaceId) {
            ScriptDescription googModule = this.scriptDescriptionsByGoogModuleNamespace.get(namespaceId);
            return googModule == null ? null : googModule.rootNode.getJSType();
        }

        private @Nullable String getExportedNamespaceOrScript(String namespaceId) {
            if (this.providedNamespaces.contains(namespaceId)) {
                return namespaceId;
            }
            ScriptDescription script = this.scriptDescriptionsByGoogModuleNamespace.get(namespaceId);
            return script == null ? null : script.getExportedNamespace();
        }
    }

    private final class ReplaceJsDocRefs
    implements NodeUtil.Visitor {
        private final Scope scope;

        ReplaceJsDocRefs(Scope scope) {
            this.scope = scope;
        }

        @Override
        public void visit(Node typeRefNode) {
            if (!typeRefNode.isStringLit()) {
                return;
            }
            String typeName = typeRefNode.getString();
            int dot = typeName.indexOf(46);
            String rootOfType = dot == -1 ? typeName : typeName.substring(0, dot);
            Var rootVar = (Var)this.scope.getVar(rootOfType);
            if (rootVar != null && !((Scope)((Scope)rootVar.getScope()).getClosestHoistScope()).isGlobal() && !((Scope)rootVar.getScope()).isModuleScope()) {
                return;
            }
            if (ClosureRewriteModule.this.currentScript.namesToInlineByAlias.containsKey(rootOfType)) {
                if (ClosureRewriteModule.this.preprocessorSymbolTable != null) {
                    Node moduleOnlyNode = typeRefNode.cloneNode();
                    ClosureRewriteModule.this.safeSetString(moduleOnlyNode, rootOfType);
                    moduleOnlyNode.setLength(rootOfType.length());
                    ClosureRewriteModule.this.maybeAddAliasToSymbolTable(moduleOnlyNode, ClosureRewriteModule.this.currentScript.namespaceId);
                }
                String aliasedNamespace = ClosureRewriteModule.this.currentScript.namesToInlineByAlias.get((Object)rootOfType).newName;
                String remainder = dot == -1 ? "" : typeName.substring(dot);
                ClosureRewriteModule.this.safeSetString(typeRefNode, aliasedNamespace + remainder);
            } else if (ClosureRewriteModule.this.currentScript.isModule && ClosureRewriteModule.this.currentScript.topLevelNames.contains(rootOfType)) {
                ClosureRewriteModule.this.safeSetString(typeRefNode, ClosureRewriteModule.this.currentScript.contentsPrefix + typeName);
            } else if (ClosureRewriteModule.this.currentScript.isModule && rootOfType.equals("exports")) {
                String namespace = ClosureRewriteModule.this.currentScript.getBinaryNamespace();
                String remainder = dot == -1 ? "" : typeName.substring(dot);
                ClosureRewriteModule.this.safeSetString(typeRefNode, namespace + remainder);
            } else {
                this.rewriteIfClosureNamespaceRef(typeName, typeRefNode);
            }
        }

        private void rewriteIfClosureNamespaceRef(String typeName, Node typeRefNode) {
            String prefixTypeName = typeName;
            String suffix = "";
            while (true) {
                String binaryNamespaceIfModule = ClosureRewriteModule.this.rewriteState.getBinaryNamespace(prefixTypeName);
                if (ClosureRewriteModule.this.legacyScriptNamespacesAndPrefixes.contains(prefixTypeName) && binaryNamespaceIfModule == null) {
                    return;
                }
                if (binaryNamespaceIfModule != null) {
                    ClosureRewriteModule.this.safeSetString(typeRefNode, binaryNamespaceIfModule + suffix);
                    return;
                }
                if (!prefixTypeName.contains(".")) break;
                prefixTypeName = prefixTypeName.substring(0, prefixTypeName.lastIndexOf(46));
                suffix = typeName.substring(prefixTypeName.length());
            }
        }
    }

    private class ScriptUpdater
    implements NodeTraversal.Callback {
        final Deque<ScriptDescription> scriptDescriptions;

        ScriptUpdater(Deque<ScriptDescription> scriptDescriptions) {
            this.scriptDescriptions = scriptDescriptions;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    ScriptDescription currentDescription = this.scriptDescriptions.removeFirst();
                    Preconditions.checkState((currentDescription.rootNode == n ? 1 : 0) != 0);
                    if (n.isFromExterns() && !NodeUtil.isFromTypeSummary(n)) {
                        return false;
                    }
                    Preconditions.checkState((boolean)ClosureRewriteModule.this.scriptStack.isEmpty());
                    ClosureRewriteModule.this.pushScript(currentDescription);
                    t.getScope();
                    if (ClosureRewriteModule.this.globalScope != null) break;
                    ClosureRewriteModule.this.globalScope = (Scope)t.getScope().getGlobalScope();
                    break;
                }
                case MODULE_BODY: {
                    if (parent.getBooleanProp(Node.GOOG_MODULE)) {
                        ClosureRewriteModule.this.updateModuleBodyEarly(n);
                        break;
                    }
                    return false;
                }
                case CALL: {
                    Node method = n.getFirstChild();
                    if (!method.isGetProp()) break;
                    if (method.matchesQualifiedName(GOOG_MODULE)) {
                        ClosureRewriteModule.this.updateGoogModule(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                        ClosureRewriteModule.updateGoogDeclareLegacyNamespace(n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRE) || method.matchesQualifiedName(GOOG_REQUIRETYPE)) {
                        ClosureRewriteModule.this.updateGoogRequire(t, n);
                        break;
                    }
                    if (!method.matchesQualifiedName(GOOG_FORWARDDECLARE) || parent.isExprResult()) break;
                    ClosureRewriteModule.this.updateGoogForwardDeclare(t, n);
                    break;
                }
                case GETPROP: {
                    if (!ClosureRewriteModule.isExportPropertyAssignment(t, n)) break;
                    ClosureRewriteModule.this.updateExportsPropertyAssignment(n, t);
                    break;
                }
            }
            if (n.getJSDocInfo() != null) {
                ClosureRewriteModule.this.rewriteJsdoc(n.getJSDocInfo(), t.getScope());
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    ClosureRewriteModule.this.updateModuleBody(n);
                    break;
                }
                case NAME: {
                    ClosureRewriteModule.this.maybeUpdateTopLevelName(t, n);
                    ClosureRewriteModule.this.maybeUpdateExportDeclaration(t, n);
                    t.getScope();
                    ClosureRewriteModule.this.maybeUpdateExportNameRef(t, n);
                    break;
                }
                case SCRIPT: {
                    Preconditions.checkState((ClosureRewriteModule.this.currentScript.rootNode == n ? 1 : 0) != 0);
                    ClosureRewriteModule.this.popScript();
                    break;
                }
            }
        }
    }

    private class ScriptRecorder
    implements NodeTraversal.Callback {
        private ScriptRecorder() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    ClosureRewriteModule.this.recordModuleBody(n);
                    break;
                }
                case CALL: {
                    Node method = n.getFirstChild();
                    if (!method.isGetProp()) break;
                    if (method.matchesQualifiedName(GOOG_MODULE)) {
                        ClosureRewriteModule.this.recordGoogModule(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                        ClosureRewriteModule.this.recordGoogDeclareLegacyNamespace();
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_PROVIDE)) {
                        ClosureRewriteModule.this.recordGoogProvide(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRE)) {
                        ClosureRewriteModule.this.recordGoogRequire(t, n, true);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRETYPE)) {
                        ClosureRewriteModule.this.recordGoogRequireType(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIREDYNAMIC)) {
                        ClosureRewriteModule.this.recordGoogRequireDynamic(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_FORWARDDECLARE) && !parent.isExprResult()) {
                        ClosureRewriteModule.this.recordGoogForwardDeclare(t, n);
                        break;
                    }
                    if (!method.matchesQualifiedName(GOOG_MODULE_GET)) break;
                    ClosureRewriteModule.this.recordGoogModuleGet(t, n);
                    break;
                }
                case CLASS: 
                case FUNCTION: {
                    if (!ClosureRewriteModule.this.isTopLevel(t, n, ScopeType.BLOCK)) break;
                    ClosureRewriteModule.this.recordTopLevelClassOrFunctionName(n);
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    if (!ClosureRewriteModule.this.isTopLevel(t, n, n.isVar() ? ScopeType.EXEC_CONTEXT : ScopeType.BLOCK)) break;
                    ClosureRewriteModule.this.recordTopLevelVarNames(n);
                    break;
                }
                case GETPROP: {
                    if (!ClosureRewriteModule.isExportPropertyAssignment(t, n)) break;
                    ClosureRewriteModule.this.recordExportsPropertyAssignment(t, n);
                    break;
                }
                case NAME: {
                    ClosureRewriteModule.this.maybeRecordExportDeclaration(t, n);
                    break;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isModuleBody()) {
                ClosureRewriteModule.this.popScript();
            }
        }
    }

    private class ScriptPreprocessor
    extends NodeTraversal.AbstractPreOrderCallback {
        private ScriptPreprocessor() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case MODULE_BODY: {
                    return true;
                }
                case SCRIPT: {
                    if (NodeUtil.isGoogModuleFile(n)) {
                        ClosureRewriteModule.checkAndSetStrictModeDirective(t, n);
                    }
                    return true;
                }
                case NAME: {
                    ClosureRewriteModule.this.preprocessExportDeclaration(t, n);
                    return true;
                }
            }
            return !parent.isScript();
        }
    }

    private static final class ScriptDescription {
        boolean isModule;
        boolean declareLegacyNamespace;
        String namespaceId;
        String contentsPrefix;
        final Set<String> topLevelNames = new LinkedHashSet<String>();
        final Deque<ScriptDescription> childScripts = new ArrayDeque<ScriptDescription>();
        final Map<String, AliasName> namesToInlineByAlias = new LinkedHashMap<String, AliasName>();
        boolean willCreateExportsObject;
        boolean hasCreatedExportObject;
        ExportDefinition defaultExport;
        @Nullable String defaultExportLocalName;
        final Set<String> namedExports = new LinkedHashSet<String>();
        final Map<Var, ExportDefinition> exportsToInline = new LinkedHashMap<Var, ExportDefinition>();
        Node rootNode;

        private ScriptDescription() {
        }

        public void addChildScript(ScriptDescription childScript) {
            this.childScripts.addLast(childScript);
        }

        public ScriptDescription removeFirstChildScript() {
            return this.childScripts.removeFirst();
        }

        @Nullable String getBinaryNamespace() {
            if (!this.isModule || this.declareLegacyNamespace) {
                return null;
            }
            return ClosureRewriteModule.getBinaryModuleNamespace(this.namespaceId);
        }

        @Nullable String getExportedNamespace() {
            if (this.declareLegacyNamespace) {
                return this.namespaceId;
            }
            return this.getBinaryNamespace();
        }
    }

    private static class AliasName {
        final String newName;
        final @Nullable String namespaceId;

        AliasName(String newName, @Nullable String namespaceId) {
            this.newName = newName;
            this.namespaceId = namespaceId;
        }
    }

    private static final class ExportDefinition {
        @Nullable String exportName;
        @Nullable Node rhs;
        @Nullable Var nameDecl;
        private static final ImmutableSet<Token> INLINABLE_NAME_PARENTS = Sets.immutableEnumSet((Enum)Token.VAR, (Enum[])new Token[]{Token.CONST, Token.LET, Token.FUNCTION, Token.CLASS});

        private ExportDefinition() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("exportName", (Object)this.exportName).add("rhs", (Object)this.rhs).add("nameDecl", (Object)this.nameDecl).omitNullValues().toString();
        }

        static ExportDefinition newDefaultExport(NodeTraversal t, Node rhs) {
            return ExportDefinition.newNamedExport(t, null, rhs);
        }

        static ExportDefinition newNamedExport(NodeTraversal t, @Nullable String name, Node rhs) {
            ExportDefinition newExport = new ExportDefinition();
            newExport.exportName = name;
            newExport.rhs = rhs;
            if (rhs != null && (rhs.isName() || rhs.isStringKey())) {
                newExport.nameDecl = (Var)t.getScope().getVar(rhs.getString());
            }
            return newExport;
        }

        String getExportPostfix() {
            if (this.exportName == null) {
                return "";
            }
            return "." + this.exportName;
        }

        boolean hasInlinableName(Set<Var> exportedNames) {
            if (this.nameDecl == null || exportedNames.contains(this.nameDecl) || !INLINABLE_NAME_PARENTS.contains((Object)this.nameDecl.getParentNode().getToken()) || NodeUtil.isFunctionDeclaration(this.nameDecl.getParentNode())) {
                return false;
            }
            Node initialValue = this.nameDecl.getInitialValue();
            if (initialValue == null || !initialValue.isCall()) {
                return true;
            }
            Node method = initialValue.getFirstChild();
            if (!method.isGetProp()) {
                return true;
            }
            Node maybeGoog = method.getFirstChild();
            if (!maybeGoog.isName() || !maybeGoog.getString().equals("goog")) {
                return true;
            }
            String name = method.getString();
            return !name.equals("require") && !name.equals("forwardDeclare") && !name.equals("getMsg");
        }

        @Nullable String getLocalName() {
            return this.nameDecl != null ? this.nameDecl.getName() : null;
        }
    }

    private static final class UnrecognizedRequire {
        final Node requireNode;
        final String namespaceId;

        UnrecognizedRequire(Node requireNode, String namespaceId, boolean mustBeOrdered) {
            this.requireNode = requireNode;
            this.namespaceId = namespaceId;
        }
    }

    private static enum ScopeType {
        EXEC_CONTEXT,
        BLOCK;

    }

    private static enum AddAt {
        BEFORE,
        AFTER;

    }
}

