/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.util;

import java.awt.Color;
import java.util.StringJoiner;

public enum ColorScheme {
    STRONG_DARK_RED(new Color(142, 45, 45), new Color(255, 0, 0)),
    STRONG_RED(new Color(255, 23, 45)),
    STRONG_DARK_ORANGE(new Color(255, 90, 14)),
    STRONG_LIGHT_ORANGE(new Color(255, 155, 5)),
    STRONG_YELLOW(new Color(255, 204, 0)),
    STRONG_LIGHT_GREEN(new Color(87, 201, 10)),
    STRONG_DARK_GREEN(new Color(72, 166, 8), new Color(84, 190, 11)),
    STRONG_AQUA(new Color(0, 198, 187)),
    STRONG_BLUE(new Color(41, 144, 255)),
    STRONG_DARK_BLUE(new Color(13, 110, 253), new Color(46, 132, 255)),
    STRONG_PURPLE(new Color(212, 69, 255)),
    PASTEL_RED(new Color(255, 126, 119)),
    PASTEL_ORANGE(new Color(255, 204, 112)),
    PASTEL_YELLOW(new Color(255, 225, 106)),
    PASTEL_GREEN(new Color(119, 221, 119)),
    PASTEL_BLUE(new Color(132, 191, 255)),
    PASTEL_PURPLE(new Color(227, 178, 242)),
    STRONG_DARK(new Color(52, 58, 64)),
    STRONG_GRAY(new Color(99, 99, 99)),
    PASTEL_GRAY(new Color(202, 206, 207)),
    PASTEL_WHITE(new Color(241, 243, 245)),
    CVSS_2(new Color(255, 79, 116)),
    CVSS_3(new Color(45, 156, 231)),
    CVSS_4(new Color(255, 197, 62)),
    TEXT_COLOR_WHITE(new Color(236, 234, 231)),
    TEXT_COLOR_BLACK(new Color(33, 37, 41)),
    TEXT_COLOR(ColorScheme.TEXT_COLOR_BLACK.color, ColorScheme.TEXT_COLOR_WHITE.color),
    TEXT_COLOR_INVERTED(ColorScheme.TEXT_COLOR_WHITE.color, ColorScheme.TEXT_COLOR_BLACK.color),
    BACKGROUND_COLOR(new Color(255, 255, 255), new Color(27, 31, 41));

    private final Color color;
    private final Color darkModeColor;

    private ColorScheme(Color color, Color darkModeColor) {
        this.color = color;
        this.darkModeColor = darkModeColor;
    }

    private ColorScheme(Color color) {
        this(color, color);
    }

    public Color getColor() {
        return this.color;
    }

    public Color getDarkModeColor() {
        return this.darkModeColor;
    }

    public String toHex() {
        return ColorScheme.toHex(this.color);
    }

    public String toDarkModeHex() {
        return ColorScheme.toHex(this.darkModeColor);
    }

    public static String toHex(Color color) {
        if (color == null) {
            return ColorScheme.toHex(ColorScheme.STRONG_PURPLE.color);
        }
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public String toRgb() {
        return ColorScheme.toRgb(this.color);
    }

    public String toDarkModeRgb() {
        return ColorScheme.toRgb(this.darkModeColor);
    }

    public static String toRgb(Color color) {
        if (color == null) {
            return ColorScheme.toRgb(ColorScheme.STRONG_PURPLE.color);
        }
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static Color setOpacity(Color color, float opacity) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), ColorScheme.a(opacity));
    }

    private static int a(float a) {
        return (int)((double)a * 255.0);
    }

    public String getCssRootName() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public Color getTextColor() {
        double lightness = (0.2126 * (double)this.color.getRed() + 0.7152 * (double)this.color.getGreen() + 0.0722 * (double)this.color.getBlue()) / 255.0;
        return lightness < 0.5 ? ColorScheme.TEXT_COLOR_WHITE.color : ColorScheme.TEXT_COLOR_BLACK.color;
    }

    public String getHexTextColor() {
        return ColorScheme.toHex(this.getTextColor());
    }

    public static String cssRoot() {
        StringJoiner rootContent = new StringJoiner(";--");
        for (ColorScheme value : ColorScheme.values()) {
            rootContent.add(value.getCssRootName() + ":" + value.toHex());
            rootContent.add(value.getCssRootName() + "-rgb:" + value.toRgb());
        }
        StringJoiner darkRootContent = new StringJoiner(";--");
        for (ColorScheme value : ColorScheme.values()) {
            darkRootContent.add(value.getCssRootName() + ":" + value.toDarkModeHex());
            darkRootContent.add(value.getCssRootName() + "-rgb:" + value.toDarkModeRgb());
        }
        return ":root, :root.ae-light{--" + rootContent + ";}@media (prefers-color-scheme: dark){:root{--" + darkRootContent + ";}}:root.ae-dark{--" + darkRootContent + ";}";
    }

    public static ColorScheme getColor(String identifier) {
        if (identifier == null) {
            return null;
        }
        identifier = identifier.trim();
        for (ColorScheme value : ColorScheme.values()) {
            if (!value.name().equals(identifier) && !value.getCssRootName().replace("-", "").equals(identifier.toLowerCase().replace("_", "").replace("-", ""))) continue;
            return value;
        }
        return null;
    }

    public static Color deriveColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

