/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v4P0;

import java.util.List;
import java.util.function.Consumer;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0MacroVector;
import org.metaeffekt.core.security.cvss.v4P0.EqOperations;

public class EqOperations36
implements EqOperations {
    private static final EqOperations36 instance36 = new EqOperations36();

    public static EqOperations36 getInstance() {
        return instance36;
    }

    @Override
    public String[] getHighestSeverityVectors(Cvss4P0MacroVector thisMacroVector) {
        return thisMacroVector.getJointEq3AndEq6().getHighestSeverityVectorsUnparsed();
    }

    @Override
    public List<Consumer<Cvss4P0>> getHighestSeverityVectorsFn(Cvss4P0MacroVector thisMacroVector) {
        return thisMacroVector.getJointEq3AndEq6().getApplyHighestSeverityVectors();
    }

    @Override
    public String[] getRelevantAttributes() {
        return new String[]{"VC", "VI", "VA", "CR", "IR", "AR"};
    }

    @Override
    public Cvss4P0MacroVector[] deriveNextLowerMacro(Cvss4P0MacroVector macroVector) {
        int eq3_val = macroVector.getEq3().getLevelAsInt();
        int eq6_val = macroVector.getEq6().getLevelAsInt();
        if (eq3_val == 1 && eq6_val == 1) {
            return new Cvss4P0MacroVector[]{macroVector.deriveNextLower(3)};
        }
        if (eq3_val == 0 && eq6_val == 1) {
            return new Cvss4P0MacroVector[]{macroVector.deriveNextLower(3)};
        }
        if (eq3_val == 1 && eq6_val == 0) {
            return new Cvss4P0MacroVector[]{macroVector.deriveNextLower(6)};
        }
        if (eq3_val == 0 && eq6_val == 0) {
            Cvss4P0MacroVector eq3eq6_next_lower_macro_left = macroVector.deriveNextLower(3);
            Cvss4P0MacroVector eq3eq6_next_lower_macro_right = macroVector.deriveNextLower(6);
            return new Cvss4P0MacroVector[]{eq3eq6_next_lower_macro_left, eq3eq6_next_lower_macro_right};
        }
        return new Cvss4P0MacroVector[]{macroVector.deriveNextLower(3).deriveNextLower(6)};
    }

    @Override
    public double lookupScoresForNextLowerMacro(Cvss4P0MacroVector[] nextLowerMacros) {
        double score_eq3eq6_next_lower_macro_left = Double.NaN;
        double score_eq3eq6_next_lower_macro_right = Double.NaN;
        if (nextLowerMacros.length > 0 && nextLowerMacros[0] != null) {
            score_eq3eq6_next_lower_macro_left = nextLowerMacros[0].getLookupTableScore();
        }
        if (nextLowerMacros.length > 1 && nextLowerMacros[1] != null) {
            score_eq3eq6_next_lower_macro_right = nextLowerMacros[1].getLookupTableScore();
        }
        if (!Double.isNaN(score_eq3eq6_next_lower_macro_left) && !Double.isNaN(score_eq3eq6_next_lower_macro_right)) {
            return Math.max(score_eq3eq6_next_lower_macro_left, score_eq3eq6_next_lower_macro_right);
        }
        if (!Double.isNaN(score_eq3eq6_next_lower_macro_left)) {
            return score_eq3eq6_next_lower_macro_left;
        }
        return score_eq3eq6_next_lower_macro_right;
    }

    @Override
    public int lookupMacroVectorDepth(Cvss4P0MacroVector thisMacroVector) {
        return thisMacroVector.getJointEq3AndEq6().getVectorDepth();
    }
}

