/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v4P0;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0MacroVector;

public class Cvss4P0Lookup {
    private static final Map<String, Double> MACRO_VECTOR_LOOKUP_TABLE = new LinkedHashMap<String, Double>();

    public static double getMacroVectorScore(String macroVector) {
        return MACRO_VECTOR_LOOKUP_TABLE.getOrDefault(macroVector, Double.NaN);
    }

    public static double getMacroVectorScore(Cvss4P0MacroVector macroVector) {
        return MACRO_VECTOR_LOOKUP_TABLE.getOrDefault(macroVector.toString(), Double.NaN);
    }

    static {
        String path = "cvss/cvss-4.0-mv-lookup.json";
        try (InputStream inputStream = Cvss4P0Lookup.class.getClassLoader().getResourceAsStream("cvss/cvss-4.0-mv-lookup.json");){
            if (inputStream == null) {
                throw new IllegalStateException("Cannot find resource: cvss/cvss-4.0-mv-lookup.json");
            }
            String json = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            JSONObject jsonObject = new JSONObject(json);
            jsonObject.keySet().forEach(key -> {
                double score = jsonObject.getDouble(key);
                MACRO_VECTOR_LOOKUP_TABLE.put((String)key, score);
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read resource: cvss/cvss-4.0-mv-lookup.json", e);
        }
    }
}

