/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v3;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSeverityRanges;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.processor.BakedCvssVectorScores;

public abstract class Cvss3
extends MultiScoreCvssVector {
    protected AttackVector attackVector = AttackVector.NULL;
    protected AttackComplexity attackComplexity = AttackComplexity.NULL;
    protected PrivilegesRequired privilegesRequired = PrivilegesRequired.NULL;
    protected UserInteraction userInteraction = UserInteraction.NULL;
    protected Scope scope = Scope.NULL;
    protected CIAImpact confidentialityImpact = CIAImpact.NULL;
    protected CIAImpact integrityImpact = CIAImpact.NULL;
    protected CIAImpact availabilityImpact = CIAImpact.NULL;
    protected ExploitCodeMaturity exploitCodeMaturity = ExploitCodeMaturity.NULL;
    protected RemediationLevel remediationLevel = RemediationLevel.NULL;
    protected ReportConfidence reportConfidence = ReportConfidence.NULL;
    protected AttackVector modifiedAttackVector = AttackVector.NULL;
    protected AttackComplexity modifiedAttackComplexity = AttackComplexity.NULL;
    protected PrivilegesRequired modifiedPrivilegesRequired = PrivilegesRequired.NULL;
    protected UserInteraction modifiedUserInteraction = UserInteraction.NULL;
    protected Scope modifiedScope = Scope.NULL;
    protected CIAImpact modifiedConfidentialityImpact = CIAImpact.NULL;
    protected CIAImpact modifiedIntegrityImpact = CIAImpact.NULL;
    protected CIAImpact modifiedAvailabilityImpact = CIAImpact.NULL;
    protected CIARequirement confidentialityRequirement = CIARequirement.NULL;
    protected CIARequirement integrityRequirement = CIARequirement.NULL;
    protected CIARequirement availabilityRequirement = CIARequirement.NULL;
    protected static final double EXPLOITABILITY_COEFFICIENT = 8.22;
    protected static final double SCOPE_COEFFICIENT = 1.08;
    private static final Map<Class<?>, Map<String, Object>> ATTRIBUTE_CACHE = new HashMap();
    public static final List<Cvss3Attribute> ATTRIBUTE_SEVERITY_ORDER = Arrays.asList(AttackVector.NULL, AttackComplexity.NULL, PrivilegesRequired.NULL, UserInteraction.NULL, Scope.NULL, Scope.UNCHANGED, CIAImpact.NULL, CIAImpact.NONE, AttackVector.PHYSICAL, CIAImpact.LOW, PrivilegesRequired.HIGH, AttackComplexity.HIGH, CIARequirement.LOW, AttackVector.LOCAL, CIAImpact.HIGH, AttackVector.ADJACENT_NETWORK, UserInteraction.REQUIRED, PrivilegesRequired.LOW, AttackComplexity.LOW, AttackVector.NETWORK, PrivilegesRequired.NONE, UserInteraction.NONE, ExploitCodeMaturity.UNPROVEN, ReportConfidence.UNKNOWN, ExploitCodeMaturity.PROOF_OF_CONCEPT, RemediationLevel.OFFICIAL_FIX, RemediationLevel.TEMPORARY_FIX, ReportConfidence.REASONABLE, ExploitCodeMaturity.FUNCTIONAL, RemediationLevel.WORKAROUND, AttackVector.NOT_DEFINED, AttackComplexity.NOT_DEFINED, PrivilegesRequired.NOT_DEFINED, UserInteraction.NOT_DEFINED, Scope.NOT_DEFINED, Scope.CHANGED, CIAImpact.NOT_DEFINED, ExploitCodeMaturity.HIGH, ExploitCodeMaturity.NOT_DEFINED, RemediationLevel.UNAVAILABLE, RemediationLevel.NOT_DEFINED, ReportConfidence.CONFIRMED, ReportConfidence.NOT_DEFINED, ExploitCodeMaturity.NULL, RemediationLevel.NULL, ReportConfidence.NULL, CIARequirement.MEDIUM, CIARequirement.NULL, CIARequirement.NOT_DEFINED, CIARequirement.HIGH);

    public Cvss3() {
    }

    public Cvss3(String vector) {
        super.applyVector(vector);
    }

    public Cvss3(String vector, CvssSource source) {
        super(source);
        super.applyVector(vector);
    }

    public Cvss3(String vector, CvssSource source, JSONObject applicabilityCondition) {
        super(source, applicabilityCondition);
        super.applyVector(vector);
    }

    public Cvss3(String vector, Collection<CvssSource> sources, JSONObject applicabilityCondition) {
        super(sources, applicabilityCondition);
        super.applyVector(vector);
    }

    @Override
    public boolean applyVectorArgument(String identifier, String value) {
        switch (identifier) {
            case "AV": {
                this.attackVector = AttackVector.fromString(value);
                break;
            }
            case "AC": {
                this.attackComplexity = AttackComplexity.fromString(value);
                break;
            }
            case "PR": {
                this.privilegesRequired = PrivilegesRequired.fromString(value);
                break;
            }
            case "UI": {
                this.userInteraction = UserInteraction.fromString(value);
                break;
            }
            case "S": {
                this.scope = Scope.fromString(value);
                break;
            }
            case "C": {
                this.confidentialityImpact = CIAImpact.fromString(value);
                break;
            }
            case "I": {
                this.integrityImpact = CIAImpact.fromString(value);
                break;
            }
            case "A": {
                this.availabilityImpact = CIAImpact.fromString(value);
                break;
            }
            case "E": {
                this.exploitCodeMaturity = ExploitCodeMaturity.fromString(value);
                break;
            }
            case "RL": {
                this.remediationLevel = RemediationLevel.fromString(value);
                break;
            }
            case "RC": {
                this.reportConfidence = ReportConfidence.fromString(value);
                break;
            }
            case "MAV": {
                this.modifiedAttackVector = AttackVector.fromString(value);
                break;
            }
            case "MAC": {
                this.modifiedAttackComplexity = AttackComplexity.fromString(value);
                break;
            }
            case "MPR": {
                this.modifiedPrivilegesRequired = PrivilegesRequired.fromString(value);
                break;
            }
            case "MUI": {
                this.modifiedUserInteraction = UserInteraction.fromString(value);
                break;
            }
            case "MS": {
                this.modifiedScope = Scope.fromString(value);
                break;
            }
            case "MC": {
                this.modifiedConfidentialityImpact = CIAImpact.fromString(value);
                break;
            }
            case "MI": {
                this.modifiedIntegrityImpact = CIAImpact.fromString(value);
                break;
            }
            case "MA": {
                this.modifiedAvailabilityImpact = CIAImpact.fromString(value);
                break;
            }
            case "CR": {
                this.confidentialityRequirement = CIARequirement.fromString(value);
                break;
            }
            case "IR": {
                this.integrityRequirement = CIARequirement.fromString(value);
                break;
            }
            case "AR": {
                this.availabilityRequirement = CIARequirement.fromString(value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Cvss3Attribute getVectorArgument(String identifier) {
        switch (identifier) {
            case "AV": {
                return this.attackVector;
            }
            case "AC": {
                return this.attackComplexity;
            }
            case "PR": {
                return this.privilegesRequired;
            }
            case "UI": {
                return this.userInteraction;
            }
            case "S": {
                return this.scope;
            }
            case "C": {
                return this.confidentialityImpact;
            }
            case "I": {
                return this.integrityImpact;
            }
            case "A": {
                return this.availabilityImpact;
            }
            case "E": {
                return this.exploitCodeMaturity;
            }
            case "RL": {
                return this.remediationLevel;
            }
            case "RC": {
                return this.reportConfidence;
            }
            case "MAV": {
                return this.modifiedAttackVector;
            }
            case "MAC": {
                return this.modifiedAttackComplexity;
            }
            case "MPR": {
                return this.modifiedPrivilegesRequired;
            }
            case "MUI": {
                return this.modifiedUserInteraction;
            }
            case "MS": {
                return this.modifiedScope;
            }
            case "MC": {
                return this.modifiedConfidentialityImpact;
            }
            case "MI": {
                return this.modifiedIntegrityImpact;
            }
            case "MA": {
                return this.modifiedAvailabilityImpact;
            }
            case "CR": {
                return this.confidentialityRequirement;
            }
            case "IR": {
                return this.integrityRequirement;
            }
            case "AR": {
                return this.availabilityRequirement;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cvss3)) {
            return false;
        }
        Cvss3 cvss3 = (Cvss3)o;
        return this.attackVector == cvss3.attackVector && this.attackComplexity == cvss3.attackComplexity && this.privilegesRequired == cvss3.privilegesRequired && this.userInteraction == cvss3.userInteraction && this.scope == cvss3.scope && this.confidentialityImpact == cvss3.confidentialityImpact && this.integrityImpact == cvss3.integrityImpact && this.availabilityImpact == cvss3.availabilityImpact && this.exploitCodeMaturity == cvss3.exploitCodeMaturity && this.remediationLevel == cvss3.remediationLevel && this.reportConfidence == cvss3.reportConfidence && this.modifiedAttackVector == cvss3.modifiedAttackVector && this.modifiedAttackComplexity == cvss3.modifiedAttackComplexity && this.modifiedPrivilegesRequired == cvss3.modifiedPrivilegesRequired && this.modifiedUserInteraction == cvss3.modifiedUserInteraction && this.modifiedScope == cvss3.modifiedScope && this.modifiedConfidentialityImpact == cvss3.modifiedConfidentialityImpact && this.modifiedIntegrityImpact == cvss3.modifiedIntegrityImpact && this.modifiedAvailabilityImpact == cvss3.modifiedAvailabilityImpact && this.confidentialityRequirement == cvss3.confidentialityRequirement && this.integrityRequirement == cvss3.integrityRequirement && this.availabilityRequirement == cvss3.availabilityRequirement;
    }

    @Override
    public double getBaseScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        double impact = this.calculateImpactScore();
        if (impact <= 0.0) {
            return 0.0;
        }
        if (!this.scope.changed) {
            return this.roundUp(Math.min(impact + this.calculateExploitabilityScore(), 10.0));
        }
        return this.roundUp(Math.min(1.08 * (impact + this.calculateExploitabilityScore()), 10.0));
    }

    protected double calculateImpactScore() {
        double iss = this.calculateISS();
        if (this.scope.changed) {
            return 7.52 * (iss - 0.029) - 3.25 * Math.pow(iss - 0.02, 15.0);
        }
        return 6.42 * iss;
    }

    @Override
    public double getImpactScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        double impactScore = this.calculateImpactScore();
        if (impactScore <= 0.0) {
            return 0.0;
        }
        return Cvss3.round(impactScore, 1);
    }

    protected double calculateISS() {
        return 1.0 - (1.0 - this.confidentialityImpact.factor) * (1.0 - this.integrityImpact.factor) * (1.0 - this.availabilityImpact.factor);
    }

    protected double calculateExploitabilityScore() {
        if (this.scope.changed) {
            return 8.22 * this.attackVector.factor * this.attackComplexity.factor * this.privilegesRequired.factorChanged * this.userInteraction.factor;
        }
        return 8.22 * this.attackVector.factor * this.attackComplexity.factor * this.privilegesRequired.factorUnchanged * this.userInteraction.factor;
    }

    @Override
    public double getExploitabilityScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        return Cvss3.round(this.calculateExploitabilityScore(), 1);
    }

    protected double calculateTemporalScore() {
        if (!this.isAnyTemporalDefined()) {
            return Double.NaN;
        }
        double exploitCodeMaturityFactor = this.exploitCodeMaturity == ExploitCodeMaturity.NULL ? ExploitCodeMaturity.NOT_DEFINED.factor : this.exploitCodeMaturity.factor;
        double remediationLevelFactor = this.remediationLevel == RemediationLevel.NULL ? RemediationLevel.NOT_DEFINED.factor : this.remediationLevel.factor;
        double reportConfidenceFactor = this.reportConfidence == ReportConfidence.NULL ? ReportConfidence.NOT_DEFINED.factor : this.reportConfidence.factor;
        double baseScore = this.getBaseScore();
        return baseScore * exploitCodeMaturityFactor * remediationLevelFactor * reportConfidenceFactor;
    }

    @Override
    public double getTemporalScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        if (!this.isAnyTemporalDefined()) {
            return Double.NaN;
        }
        return this.roundUp(this.calculateTemporalScore());
    }

    @Override
    public double getEnvironmentalScore() {
        double reportConfidenceFactor;
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        if (!this.isAnyEnvironmentalDefined()) {
            return Double.NaN;
        }
        double modifiedImpact = this.calculateAdjustedImpact();
        if (modifiedImpact <= 0.0) {
            return 0.0;
        }
        double modifiedExploitability = this.calculateAdjustedExploitability();
        double exploitCodeMaturityFactor = this.exploitCodeMaturity == ExploitCodeMaturity.NULL ? ExploitCodeMaturity.NOT_DEFINED.factor : this.exploitCodeMaturity.factor;
        double remediationLevelFactor = this.remediationLevel == RemediationLevel.NULL ? RemediationLevel.NOT_DEFINED.factor : this.remediationLevel.factor;
        double d = reportConfidenceFactor = this.reportConfidence == ReportConfidence.NULL ? ReportConfidence.NOT_DEFINED.factor : this.reportConfidence.factor;
        if (this.isModifiedScope()) {
            return this.roundUp(this.roundUp(Math.min(modifiedImpact + modifiedExploitability, 10.0)) * exploitCodeMaturityFactor * remediationLevelFactor * reportConfidenceFactor);
        }
        return this.roundUp(this.roundUp(Math.min(1.08 * (modifiedImpact + modifiedExploitability), 10.0)) * exploitCodeMaturityFactor * remediationLevelFactor * reportConfidenceFactor);
    }

    protected double calculateMISS() {
        double mii;
        double mci;
        double d = this.modifiedConfidentialityImpact == CIAImpact.NULL || this.modifiedConfidentialityImpact == CIAImpact.NOT_DEFINED ? (this.confidentialityImpact == CIAImpact.NULL ? CIAImpact.NOT_DEFINED.factor : this.confidentialityImpact.factor) : (mci = this.modifiedConfidentialityImpact.factor);
        double d2 = this.modifiedIntegrityImpact == CIAImpact.NULL || this.modifiedIntegrityImpact == CIAImpact.NOT_DEFINED ? (this.integrityImpact == CIAImpact.NULL ? CIAImpact.NOT_DEFINED.factor : this.integrityImpact.factor) : (mii = this.modifiedIntegrityImpact.factor);
        double mai = this.modifiedAvailabilityImpact == CIAImpact.NULL || this.modifiedAvailabilityImpact == CIAImpact.NOT_DEFINED ? (this.availabilityImpact == CIAImpact.NULL ? CIAImpact.NOT_DEFINED.factor : this.availabilityImpact.factor) : this.modifiedAvailabilityImpact.factor;
        double crFactor = this.confidentialityRequirement == CIARequirement.NULL && (this.integrityRequirement != CIARequirement.NULL || this.availabilityRequirement != CIARequirement.NULL) ? CIARequirement.NOT_DEFINED.factor : this.confidentialityRequirement.factor;
        double irFactor = this.integrityRequirement == CIARequirement.NULL && (this.confidentialityRequirement != CIARequirement.NULL || this.availabilityRequirement != CIARequirement.NULL) ? CIARequirement.NOT_DEFINED.factor : this.integrityRequirement.factor;
        double arFactor = this.availabilityRequirement == CIARequirement.NULL && (this.confidentialityRequirement != CIARequirement.NULL || this.integrityRequirement != CIARequirement.NULL) ? CIARequirement.NOT_DEFINED.factor : this.availabilityRequirement.factor;
        return Math.min(1.0 - (1.0 - crFactor * mci) * (1.0 - irFactor * mii) * (1.0 - arFactor * mai), 0.915);
    }

    protected abstract double calculateAdjustedImpact();

    @Override
    public double getAdjustedImpactScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        if (!this.isAnyEnvironmentalDefined()) {
            return Double.NaN;
        }
        return Math.max(0.0, Cvss3.round(this.calculateAdjustedImpact(), 1));
    }

    protected double calculateAdjustedExploitability() {
        double mui;
        double mav = this.modifiedAttackVector == AttackVector.NULL || this.modifiedAttackVector == AttackVector.NOT_DEFINED ? this.attackVector.factor : this.modifiedAttackVector.factor;
        double mac = this.modifiedAttackComplexity == AttackComplexity.NULL || this.modifiedAttackComplexity == AttackComplexity.NOT_DEFINED ? this.attackComplexity.factor : this.modifiedAttackComplexity.factor;
        double d = mui = this.modifiedUserInteraction == UserInteraction.NULL || this.modifiedUserInteraction == UserInteraction.NOT_DEFINED ? this.userInteraction.factor : this.modifiedUserInteraction.factor;
        double mpr = this.isModifiedScope() ? (this.modifiedPrivilegesRequired == PrivilegesRequired.NULL || this.modifiedPrivilegesRequired == PrivilegesRequired.NOT_DEFINED ? this.privilegesRequired.factorUnchanged : this.modifiedPrivilegesRequired.factorUnchanged) : (this.modifiedPrivilegesRequired == PrivilegesRequired.NULL || this.modifiedPrivilegesRequired == PrivilegesRequired.NOT_DEFINED ? this.privilegesRequired.factorChanged : this.modifiedPrivilegesRequired.factorChanged);
        return 8.22 * mav * mac * mpr * mui;
    }

    protected boolean isModifiedScope() {
        return this.modifiedScope != Scope.NULL && this.modifiedScope != Scope.NOT_DEFINED && !this.modifiedScope.changed || (this.modifiedScope == Scope.NULL || this.modifiedScope == Scope.NOT_DEFINED) && !this.scope.changed;
    }

    @Override
    public double getOverallScore() {
        if (this.isAnyEnvironmentalDefined()) {
            return this.getEnvironmentalScore();
        }
        if (this.isAnyTemporalDefined()) {
            return this.getTemporalScore();
        }
        return this.getBaseScore();
    }

    @Override
    public CvssSeverityRanges.SeverityRange getDefaultSeverityCategory() {
        return this.getSeverityCategory(CvssSeverityRanges.CVSS_3_SEVERITY_RANGES);
    }

    @Override
    public boolean isBaseFullyDefined() {
        return this.attackVector != AttackVector.NULL && this.attackComplexity != AttackComplexity.NULL && this.privilegesRequired != PrivilegesRequired.NULL && this.userInteraction != UserInteraction.NULL && this.scope != Scope.NULL && this.confidentialityImpact != CIAImpact.NULL && this.integrityImpact != CIAImpact.NULL && this.availabilityImpact != CIAImpact.NULL;
    }

    @Override
    public boolean isAnyBaseDefined() {
        return this.attackVector != AttackVector.NULL || this.attackComplexity != AttackComplexity.NULL || this.privilegesRequired != PrivilegesRequired.NULL || this.userInteraction != UserInteraction.NULL || this.scope != Scope.NULL || this.confidentialityImpact != CIAImpact.NULL || this.integrityImpact != CIAImpact.NULL || this.availabilityImpact != CIAImpact.NULL;
    }

    @Override
    public boolean isAnyTemporalDefined() {
        return this.exploitCodeMaturity != ExploitCodeMaturity.NULL || this.remediationLevel != RemediationLevel.NULL || this.reportConfidence != ReportConfidence.NULL;
    }

    @Override
    public boolean isTemporalFullyDefined() {
        return this.exploitCodeMaturity != ExploitCodeMaturity.NULL && this.remediationLevel != RemediationLevel.NULL && this.reportConfidence != ReportConfidence.NULL;
    }

    @Override
    public boolean isAnyEnvironmentalDefined() {
        return this.modifiedAttackVector != AttackVector.NULL || this.modifiedAttackComplexity != AttackComplexity.NULL || this.modifiedPrivilegesRequired != PrivilegesRequired.NULL || this.modifiedUserInteraction != UserInteraction.NULL || this.modifiedScope != Scope.NULL || this.modifiedConfidentialityImpact != CIAImpact.NULL || this.modifiedIntegrityImpact != CIAImpact.NULL || this.modifiedAvailabilityImpact != CIAImpact.NULL || this.confidentialityRequirement != CIARequirement.NULL || this.integrityRequirement != CIARequirement.NULL || this.availabilityRequirement != CIARequirement.NULL;
    }

    @Override
    public boolean isEnvironmentalFullyDefined() {
        return this.modifiedAttackVector != AttackVector.NULL && this.modifiedAttackComplexity != AttackComplexity.NULL && this.modifiedPrivilegesRequired != PrivilegesRequired.NULL && this.modifiedUserInteraction != UserInteraction.NULL && this.modifiedScope != Scope.NULL && this.modifiedConfidentialityImpact != CIAImpact.NULL && this.modifiedIntegrityImpact != CIAImpact.NULL && this.modifiedAvailabilityImpact != CIAImpact.NULL && this.confidentialityRequirement != CIARequirement.NULL && this.integrityRequirement != CIARequirement.NULL && this.availabilityRequirement != CIARequirement.NULL;
    }

    @Override
    public void clearTemporal() {
        this.exploitCodeMaturity = ExploitCodeMaturity.NULL;
        this.remediationLevel = RemediationLevel.NULL;
        this.reportConfidence = ReportConfidence.NULL;
    }

    @Override
    public void clearEnvironmental() {
        this.modifiedAttackVector = AttackVector.NULL;
        this.modifiedAttackComplexity = AttackComplexity.NULL;
        this.modifiedPrivilegesRequired = PrivilegesRequired.NULL;
        this.modifiedUserInteraction = UserInteraction.NULL;
        this.modifiedScope = Scope.NULL;
        this.modifiedConfidentialityImpact = CIAImpact.NULL;
        this.modifiedIntegrityImpact = CIAImpact.NULL;
        this.modifiedAvailabilityImpact = CIAImpact.NULL;
        this.confidentialityRequirement = CIARequirement.NULL;
        this.integrityRequirement = CIARequirement.NULL;
        this.availabilityRequirement = CIARequirement.NULL;
    }

    @Override
    public BakedCvssVectorScores bakeScores() {
        return BakedCvssVectorScores.fromNullableCvss(this);
    }

    @Override
    public Map<String, CvssVector.CvssVectorAttribute[]> getAttributes() {
        LinkedHashMap<String, CvssVector.CvssVectorAttribute[]> attributes = new LinkedHashMap<String, CvssVector.CvssVectorAttribute[]>();
        attributes.put("AV", AttackVector.values());
        attributes.put("AC", AttackComplexity.values());
        attributes.put("PR", PrivilegesRequired.values());
        attributes.put("UI", UserInteraction.values());
        attributes.put("S", Scope.values());
        attributes.put("C", CIAImpact.values());
        attributes.put("I", CIAImpact.values());
        attributes.put("A", CIAImpact.values());
        attributes.put("E", ExploitCodeMaturity.values());
        attributes.put("RL", RemediationLevel.values());
        attributes.put("RC", ReportConfidence.values());
        attributes.put("MAV", AttackVector.values());
        attributes.put("MAC", AttackComplexity.values());
        attributes.put("MPR", PrivilegesRequired.values());
        attributes.put("MUI", UserInteraction.values());
        attributes.put("MS", Scope.values());
        attributes.put("MC", CIAImpact.values());
        attributes.put("MI", CIAImpact.values());
        attributes.put("MA", CIAImpact.values());
        attributes.put("CR", CIARequirement.values());
        attributes.put("IR", CIARequirement.values());
        attributes.put("AR", CIARequirement.values());
        return attributes;
    }

    public String getAttackComplexity() {
        return this.attackComplexity.identifier;
    }

    public String getAttackVector() {
        return this.attackVector.identifier;
    }

    public String getAvailabilityImpact() {
        return this.availabilityImpact.identifier;
    }

    public String getConfidentialityImpact() {
        return this.confidentialityImpact.identifier;
    }

    public String getIntegrityImpact() {
        return this.integrityImpact.identifier;
    }

    public String getModifiedAttackComplexity() {
        return this.modifiedAttackComplexity.identifier;
    }

    public String getExploitCodeMaturity() {
        return this.exploitCodeMaturity.identifier;
    }

    public String getModifiedAttackVector() {
        return this.modifiedAttackVector.identifier;
    }

    public String getModifiedAvailabilityImpact() {
        return this.modifiedAvailabilityImpact.identifier;
    }

    public String getModifiedConfidentialityImpact() {
        return this.modifiedConfidentialityImpact.identifier;
    }

    public String getModifiedIntegrityImpact() {
        return this.modifiedIntegrityImpact.identifier;
    }

    public String getPrivilegesRequired() {
        return this.privilegesRequired.identifier;
    }

    public String getAvailabilityRequirement() {
        return this.availabilityRequirement.identifier;
    }

    public String getConfidentialityRequirement() {
        return this.confidentialityRequirement.identifier;
    }

    public String getModifiedPrivilegesRequired() {
        return this.modifiedPrivilegesRequired.identifier;
    }

    public String getIntegrityRequirement() {
        return this.integrityRequirement.identifier;
    }

    public String getRemediationLevel() {
        return this.remediationLevel.identifier;
    }

    public String getReportConfidence() {
        return this.reportConfidence.identifier;
    }

    public String getModifiedScope() {
        return this.modifiedScope.identifier;
    }

    public String getScope() {
        return this.scope.identifier;
    }

    public String getUserInteraction() {
        return this.userInteraction.identifier;
    }

    public String getModifiedUserInteraction() {
        return this.modifiedUserInteraction.identifier;
    }

    public void setAttackComplexity(AttackComplexity attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    public void setAttackVector(AttackVector attackVector) {
        this.attackVector = attackVector;
    }

    public void setAvailabilityImpact(CIAImpact availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    public void setAvailabilityRequirement(CIARequirement availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    public void setConfidentialityImpact(CIAImpact confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public void setConfidentialityRequirement(CIARequirement confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public void setExploitCodeMaturity(ExploitCodeMaturity exploitCodeMaturity) {
        this.exploitCodeMaturity = exploitCodeMaturity;
    }

    public void setIntegrityImpact(CIAImpact integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public void setIntegrityRequirement(CIARequirement integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public void setModifiedAttackComplexity(AttackComplexity modifiedAttackComplexity) {
        this.modifiedAttackComplexity = modifiedAttackComplexity;
    }

    public void setModifiedAttackVector(AttackVector modifiedAttackVector) {
        this.modifiedAttackVector = modifiedAttackVector;
    }

    public void setModifiedAvailabilityImpact(CIAImpact modifiedAvailabilityImpact) {
        this.modifiedAvailabilityImpact = modifiedAvailabilityImpact;
    }

    public void setModifiedConfidentialityImpact(CIAImpact modifiedConfidentialityImpact) {
        this.modifiedConfidentialityImpact = modifiedConfidentialityImpact;
    }

    public void setModifiedIntegrityImpact(CIAImpact modifiedIntegrityImpact) {
        this.modifiedIntegrityImpact = modifiedIntegrityImpact;
    }

    public void setModifiedPrivilegesRequired(PrivilegesRequired modifiedPrivilegesRequired) {
        this.modifiedPrivilegesRequired = modifiedPrivilegesRequired;
    }

    public void setModifiedScope(Scope modifiedScope) {
        this.modifiedScope = modifiedScope;
    }

    public void setModifiedUserInteraction(UserInteraction modifiedUserInteraction) {
        this.modifiedUserInteraction = modifiedUserInteraction;
    }

    public void setPrivilegesRequired(PrivilegesRequired privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    public void setRemediationLevel(RemediationLevel remediationLevel) {
        this.remediationLevel = remediationLevel;
    }

    public void setReportConfidence(ReportConfidence reportConfidence) {
        this.reportConfidence = reportConfidence;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    protected static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public abstract double roundUp(double var1);

    @Override
    public String getNistFirstWebEditorLink() {
        String vectorString = this.toString(!this.isAnyEnvironmentalDefined());
        if (this.isAnyEnvironmentalDefined() || this.isAnyTemporalDefined()) {
            return String.format("https://www.first.org/cvss/calculator/3.1#%s", vectorString);
        }
        return String.format("https://nvd.nist.gov/vuln-metrics/cvss/v3-calculator?vector=%s&version=3.1", vectorString.replace(this.getName() + "/", ""));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean filterUndefinedProperties) {
        StringBuilder vector = new StringBuilder();
        vector.append(this.getName()).append('/');
        this.appendIfValid(vector, "AV", this.attackVector.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "AC", this.attackComplexity.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "PR", this.privilegesRequired.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "UI", this.userInteraction.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "S", this.scope.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "C", this.confidentialityImpact.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "I", this.integrityImpact.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "A", this.availabilityImpact.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "E", this.exploitCodeMaturity.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "RL", this.remediationLevel.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "RC", this.reportConfidence.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "CR", this.confidentialityRequirement.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "IR", this.integrityRequirement.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "AR", this.availabilityRequirement.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MAV", this.modifiedAttackVector.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MAC", this.modifiedAttackComplexity.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MPR", this.modifiedPrivilegesRequired.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MUI", this.modifiedUserInteraction.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MS", this.modifiedScope.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MC", this.modifiedConfidentialityImpact.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MI", this.modifiedIntegrityImpact.shortIdentifier, filterUndefinedProperties);
        this.appendIfValid(vector, "MA", this.modifiedAvailabilityImpact.shortIdentifier, filterUndefinedProperties);
        if (vector.length() > 0 && vector.charAt(vector.length() - 1) == '/') {
            vector.setLength(vector.length() - 1);
        }
        return vector.toString();
    }

    private void appendIfValid(StringBuilder builder, String prefix, String value, boolean filterUndefinedProperties) {
        if (!(value == null || filterUndefinedProperties && value.equals("X"))) {
            if (builder.length() > 0 && builder.charAt(builder.length() - 1) != '/') {
                builder.append('/');
            }
            builder.append(prefix).append(':').append(value);
        }
    }

    @Override
    public int size() {
        int size = 0;
        if (this.attackVector != AttackVector.NOT_DEFINED && this.attackVector != AttackVector.NULL) {
            ++size;
        }
        if (this.attackComplexity != AttackComplexity.NOT_DEFINED && this.attackComplexity != AttackComplexity.NULL) {
            ++size;
        }
        if (this.privilegesRequired != PrivilegesRequired.NOT_DEFINED && this.privilegesRequired != PrivilegesRequired.NULL) {
            ++size;
        }
        if (this.userInteraction != UserInteraction.NOT_DEFINED && this.userInteraction != UserInteraction.NULL) {
            ++size;
        }
        if (this.scope != Scope.NOT_DEFINED && this.scope != Scope.NULL) {
            ++size;
        }
        if (this.confidentialityImpact != CIAImpact.NOT_DEFINED && this.confidentialityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.integrityImpact != CIAImpact.NOT_DEFINED && this.integrityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.availabilityImpact != CIAImpact.NOT_DEFINED && this.availabilityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.exploitCodeMaturity != ExploitCodeMaturity.NOT_DEFINED && this.exploitCodeMaturity != ExploitCodeMaturity.NULL) {
            ++size;
        }
        if (this.remediationLevel != RemediationLevel.NOT_DEFINED && this.remediationLevel != RemediationLevel.NULL) {
            ++size;
        }
        if (this.reportConfidence != ReportConfidence.NOT_DEFINED && this.reportConfidence != ReportConfidence.NULL) {
            ++size;
        }
        if (this.modifiedAttackVector != AttackVector.NOT_DEFINED && this.modifiedAttackVector != AttackVector.NULL) {
            ++size;
        }
        if (this.modifiedAttackComplexity != AttackComplexity.NOT_DEFINED && this.modifiedAttackComplexity != AttackComplexity.NULL) {
            ++size;
        }
        if (this.modifiedPrivilegesRequired != PrivilegesRequired.NOT_DEFINED && this.modifiedPrivilegesRequired != PrivilegesRequired.NULL) {
            ++size;
        }
        if (this.modifiedUserInteraction != UserInteraction.NOT_DEFINED && this.modifiedUserInteraction != UserInteraction.NULL) {
            ++size;
        }
        if (this.modifiedScope != Scope.NOT_DEFINED && this.modifiedScope != Scope.NULL) {
            ++size;
        }
        if (this.modifiedConfidentialityImpact != CIAImpact.NOT_DEFINED && this.modifiedConfidentialityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.modifiedIntegrityImpact != CIAImpact.NOT_DEFINED && this.modifiedIntegrityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.modifiedAvailabilityImpact != CIAImpact.NOT_DEFINED && this.modifiedAvailabilityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.confidentialityRequirement != CIARequirement.NOT_DEFINED && this.confidentialityRequirement != CIARequirement.NULL) {
            ++size;
        }
        if (this.integrityRequirement != CIARequirement.NOT_DEFINED && this.integrityRequirement != CIARequirement.NULL) {
            ++size;
        }
        if (this.availabilityRequirement != CIARequirement.NOT_DEFINED && this.availabilityRequirement != CIARequirement.NULL) {
            ++size;
        }
        return size;
    }

    @Override
    protected <T extends CvssVector> T cloneInternal(T clone) {
        super.cloneInternal(clone);
        if (!(clone instanceof Cvss3)) {
            return clone;
        }
        Cvss3 clone3 = (Cvss3)clone;
        clone3.attackVector = this.attackVector;
        clone3.attackComplexity = this.attackComplexity;
        clone3.privilegesRequired = this.privilegesRequired;
        clone3.userInteraction = this.userInteraction;
        clone3.scope = this.scope;
        clone3.confidentialityImpact = this.confidentialityImpact;
        clone3.integrityImpact = this.integrityImpact;
        clone3.availabilityImpact = this.availabilityImpact;
        clone3.exploitCodeMaturity = this.exploitCodeMaturity;
        clone3.remediationLevel = this.remediationLevel;
        clone3.reportConfidence = this.reportConfidence;
        clone3.modifiedAttackVector = this.modifiedAttackVector;
        clone3.modifiedAttackComplexity = this.modifiedAttackComplexity;
        clone3.modifiedPrivilegesRequired = this.modifiedPrivilegesRequired;
        clone3.modifiedUserInteraction = this.modifiedUserInteraction;
        clone3.modifiedScope = this.modifiedScope;
        clone3.modifiedConfidentialityImpact = this.modifiedConfidentialityImpact;
        clone3.modifiedIntegrityImpact = this.modifiedIntegrityImpact;
        clone3.modifiedAvailabilityImpact = this.modifiedAvailabilityImpact;
        clone3.confidentialityRequirement = this.confidentialityRequirement;
        clone3.integrityRequirement = this.integrityRequirement;
        clone3.availabilityRequirement = this.availabilityRequirement;
        return clone;
    }

    @Override
    public void completeVector() {
        this.cleanupTemporalVectorParts();
        this.cleanupEnvironmentalVectorParts();
    }

    protected void cleanupTemporalVectorParts() {
        if (this.isAnyTemporalDefined()) {
            this.exploitCodeMaturity = this.exploitCodeMaturity == ExploitCodeMaturity.NULL ? ExploitCodeMaturity.NOT_DEFINED : this.exploitCodeMaturity;
            this.remediationLevel = this.remediationLevel == RemediationLevel.NULL ? RemediationLevel.NOT_DEFINED : this.remediationLevel;
            ReportConfidence reportConfidence = this.reportConfidence = this.reportConfidence == ReportConfidence.NULL ? ReportConfidence.NOT_DEFINED : this.reportConfidence;
        }
        if (this.isTemporalAllPartsNotDefined()) {
            this.clearTemporal();
        }
    }

    protected void cleanupEnvironmentalVectorParts() {
        if (this.isAnyEnvironmentalDefined()) {
            this.modifiedAttackVector = this.modifiedAttackVector == AttackVector.NULL ? AttackVector.NOT_DEFINED : this.modifiedAttackVector;
            this.modifiedAttackComplexity = this.modifiedAttackComplexity == AttackComplexity.NULL ? AttackComplexity.NOT_DEFINED : this.modifiedAttackComplexity;
            this.modifiedPrivilegesRequired = this.modifiedPrivilegesRequired == PrivilegesRequired.NULL ? PrivilegesRequired.NOT_DEFINED : this.modifiedPrivilegesRequired;
            this.modifiedUserInteraction = this.modifiedUserInteraction == UserInteraction.NULL ? UserInteraction.NOT_DEFINED : this.modifiedUserInteraction;
            this.modifiedScope = this.modifiedScope == Scope.NULL ? Scope.NOT_DEFINED : this.modifiedScope;
            this.modifiedConfidentialityImpact = this.modifiedConfidentialityImpact == CIAImpact.NULL ? CIAImpact.NOT_DEFINED : this.modifiedConfidentialityImpact;
            this.modifiedIntegrityImpact = this.modifiedIntegrityImpact == CIAImpact.NULL ? CIAImpact.NOT_DEFINED : this.modifiedIntegrityImpact;
            this.modifiedAvailabilityImpact = this.modifiedAvailabilityImpact == CIAImpact.NULL ? CIAImpact.NOT_DEFINED : this.modifiedAvailabilityImpact;
            this.confidentialityRequirement = this.confidentialityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED : this.confidentialityRequirement;
            this.integrityRequirement = this.integrityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED : this.integrityRequirement;
            CIARequirement cIARequirement = this.availabilityRequirement = this.availabilityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED : this.availabilityRequirement;
        }
        if (this.isEnvironmentalAllPartsNotDefined()) {
            this.clearEnvironmental();
        }
    }

    protected boolean isTemporalAllPartsNotDefined() {
        return this.exploitCodeMaturity == ExploitCodeMaturity.NOT_DEFINED && this.remediationLevel == RemediationLevel.NOT_DEFINED && this.reportConfidence == ReportConfidence.NOT_DEFINED;
    }

    protected boolean isEnvironmentalAllPartsNotDefined() {
        return this.modifiedAttackVector == AttackVector.NOT_DEFINED && this.modifiedAttackComplexity == AttackComplexity.NOT_DEFINED && this.modifiedPrivilegesRequired == PrivilegesRequired.NOT_DEFINED && this.modifiedUserInteraction == UserInteraction.NOT_DEFINED && this.modifiedScope == Scope.NOT_DEFINED && this.modifiedConfidentialityImpact == CIAImpact.NOT_DEFINED && this.modifiedIntegrityImpact == CIAImpact.NOT_DEFINED && this.modifiedAvailabilityImpact == CIAImpact.NOT_DEFINED && this.confidentialityRequirement == CIARequirement.NOT_DEFINED && this.integrityRequirement == CIARequirement.NOT_DEFINED && this.availabilityRequirement == CIARequirement.NOT_DEFINED;
    }

    public abstract <T extends Cvss3> Optional<T> optionalParse(String var1);

    public static interface Cvss3Attribute
    extends CvssVector.CvssVectorAttribute {
        @Override
        default public boolean isSet() {
            return !this.getIdentifier().equals("NOT_DEFINED") && !this.getIdentifier().equals("NULL");
        }

        public static <T extends Cvss3Attribute> T fromString(String part, Class<T> clazz, T defaultValue) {
            Map<String, Cvss3Attribute> cache;
            if (ATTRIBUTE_CACHE.containsKey(clazz)) {
                cache = (Map)ATTRIBUTE_CACHE.get(clazz);
            } else {
                cache = new HashMap();
                ATTRIBUTE_CACHE.put(clazz, cache);
            }
            if (cache.containsKey(part)) {
                return (T)((Cvss3Attribute)cache.get(part));
            }
            for (Cvss3Attribute value : (Cvss3Attribute[])clazz.getEnumConstants()) {
                if (value.getShortIdentifier().equalsIgnoreCase(part)) {
                    cache.put(part, value);
                    return (T)value;
                }
                if (!value.getIdentifier().equalsIgnoreCase(part)) continue;
                cache.put(part, value);
                return (T)value;
            }
            cache.put(part, defaultValue);
            return defaultValue;
        }
    }

    public static enum CIARequirement implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        LOW("LOW", "L", 0.5),
        MEDIUM("MEDIUM", "M", 1.0),
        HIGH("HIGH", "H", 1.5);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private CIARequirement(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static CIARequirement fromString(String part) {
            return Cvss3Attribute.fromString(part, CIARequirement.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum ReportConfidence implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        UNKNOWN("UNKNOWN", "U", 0.92),
        REASONABLE("REASONABLE", "R", 0.96),
        CONFIRMED("CONFIRMED", "C", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private ReportConfidence(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static ReportConfidence fromString(String part) {
            return Cvss3Attribute.fromString(part, ReportConfidence.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum RemediationLevel implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        OFFICIAL_FIX("OFFICIAL_FIX", "O", 0.95),
        TEMPORARY_FIX("TEMPORARY_FIX", "T", 0.96),
        WORKAROUND("WORKAROUND", "W", 0.97),
        UNAVAILABLE("UNAVAILABLE", "U", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private RemediationLevel(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static RemediationLevel fromString(String part) {
            return Cvss3Attribute.fromString(part, RemediationLevel.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum ExploitCodeMaturity implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        UNPROVEN("UNPROVEN", "U", 0.91),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT", "P", 0.94),
        FUNCTIONAL("FUNCTIONAL", "F", 0.97),
        HIGH("HIGH", "H", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private ExploitCodeMaturity(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static ExploitCodeMaturity fromString(String part) {
            return Cvss3Attribute.fromString(part, ExploitCodeMaturity.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum CIAImpact implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        NONE("NONE", "N", 0.0),
        LOW("LOW", "L", 0.22),
        HIGH("HIGH", "H", 0.56);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private CIAImpact(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static CIAImpact fromString(String part) {
            return Cvss3Attribute.fromString(part, CIAImpact.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum Scope implements Cvss3Attribute
    {
        NULL("NULL", "X", false),
        NOT_DEFINED("NOT_DEFINED", "X", false),
        CHANGED("CHANGED", "C", true),
        UNCHANGED("UNCHANGED", "U", false);

        public final String identifier;
        public final String shortIdentifier;
        public final boolean changed;
        public static final double SCOPE_CHANGED_FACTOR = 7.52;
        public static final double SCOPE_UNCHANGED_FACTOR = 6.42;

        private Scope(String identifier, String shortIdentifier, boolean changed) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.changed = changed;
        }

        public static Scope fromString(String part) {
            return Cvss3Attribute.fromString(part, Scope.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum UserInteraction implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        REQUIRED("REQUIRED", "R", 0.62),
        NONE("NONE", "N", 0.85);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private UserInteraction(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static UserInteraction fromString(String part) {
            return Cvss3Attribute.fromString(part, UserInteraction.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum PrivilegesRequired implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0, 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0, 1.0),
        HIGH("HIGH", "H", 0.27, 0.5),
        LOW("LOW", "L", 0.62, 0.68),
        NONE("NONE", "N", 0.85, 0.85);

        public final String identifier;
        public final String shortIdentifier;
        public final double factorUnchanged;
        public final double factorChanged;

        private PrivilegesRequired(String identifier, String shortIdentifier, double factorUnchanged, double factorChanged) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factorUnchanged = factorUnchanged;
            this.factorChanged = factorChanged;
        }

        public static PrivilegesRequired fromString(String part) {
            return Cvss3Attribute.fromString(part, PrivilegesRequired.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum AttackComplexity implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        LOW("LOW", "L", 0.77),
        HIGH("HIGH", "H", 0.44);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private AttackComplexity(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static AttackComplexity fromString(String part) {
            return Cvss3Attribute.fromString(part, AttackComplexity.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum AttackVector implements Cvss3Attribute
    {
        NULL("NULL", "X", 0.0),
        NOT_DEFINED("NOT_DEFINED", "X", 1.0),
        NETWORK("NETWORK", "N", 0.85),
        ADJACENT_NETWORK("ADJACENT_NETWORK", "A", 0.62),
        LOCAL("LOCAL", "L", 0.55),
        PHYSICAL("PHYSICAL", "P", 0.2);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private AttackVector(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static AttackVector fromString(String part) {
            return Cvss3Attribute.fromString(part, AttackVector.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }
}

