/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.v2;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSeverityRanges;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.processor.BakedCvssVectorScores;

public final class Cvss2
extends MultiScoreCvssVector {
    private AccessVector accessVector = AccessVector.NULL;
    private AccessComplexity accessComplexity = AccessComplexity.NULL;
    private Authentication authentication = Authentication.NULL;
    private CIAImpact confidentialityImpact = CIAImpact.NULL;
    private CIAImpact integrityImpact = CIAImpact.NULL;
    private CIAImpact availabilityImpact = CIAImpact.NULL;
    private Exploitability exploitability = Exploitability.NULL;
    private RemediationLevel remediationLevel = RemediationLevel.NULL;
    private ReportConfidence reportConfidence = ReportConfidence.NULL;
    private CollateralDamagePotential collateralDamagePotential = CollateralDamagePotential.NULL;
    private TargetDistribution targetDistribution = TargetDistribution.NULL;
    private CIARequirement confidentialityRequirement = CIARequirement.NULL;
    private CIARequirement integrityRequirement = CIARequirement.NULL;
    private CIARequirement availabilityRequirement = CIARequirement.NULL;
    private static final Map<Class<?>, Map<String, Object>> ATTRIBUTE_CACHE = new HashMap();
    public static final List<Cvss2Attribute> ATTRIBUTE_SEVERITY_ORDER = Arrays.asList(AccessVector.NULL, AccessComplexity.NULL, Authentication.NULL, CIAImpact.NULL, CIAImpact.NONE, Exploitability.NULL, RemediationLevel.NULL, ReportConfidence.NULL, CollateralDamagePotential.NULL, CollateralDamagePotential.NONE, CollateralDamagePotential.NOT_DEFINED, TargetDistribution.NULL, TargetDistribution.NONE, CIARequirement.NULL, CollateralDamagePotential.LOW, TargetDistribution.LOW, CIAImpact.PARTIAL, CollateralDamagePotential.LOW_MEDIUM, AccessComplexity.HIGH, AccessVector.LOCAL, CollateralDamagePotential.MEDIUM_HIGH, Authentication.MULTIPLE, CollateralDamagePotential.HIGH, Authentication.SINGLE, AccessComplexity.MEDIUM, AccessVector.ADJACENT_NETWORK, CIAImpact.COMPLETE, Authentication.NONE, AccessComplexity.LOW, TargetDistribution.MEDIUM, Exploitability.UNPROVEN, RemediationLevel.OFFICIAL, Exploitability.PROOF_OF_CONCEPT, RemediationLevel.TEMPORARY, RemediationLevel.WORKAROUND, ReportConfidence.UNCONFIRMED, ReportConfidence.UNCORROBORATED, AccessVector.NETWORK, Exploitability.FUNCTIONAL, Exploitability.HIGH, Exploitability.NOT_DEFINED, RemediationLevel.UNAVAILABLE, RemediationLevel.NOT_DEFINED, ReportConfidence.CONFIRMED, ReportConfidence.NOT_DEFINED, TargetDistribution.HIGH, TargetDistribution.NOT_DEFINED, CIARequirement.LOW, CIARequirement.MEDIUM, CIARequirement.NOT_DEFINED, CIARequirement.HIGH);

    public Cvss2() {
    }

    public Cvss2(String vector) {
        super.applyVector(vector);
    }

    public Cvss2(String vector, CvssSource source) {
        super(source);
        super.applyVector(vector);
    }

    public Cvss2(String vector, CvssSource source, JSONObject applicabilityCondition) {
        super(source, applicabilityCondition);
        super.applyVector(vector);
    }

    public Cvss2(String vector, Collection<CvssSource> sources, JSONObject applicabilityCondition) {
        super(sources, applicabilityCondition);
        super.applyVector(vector);
    }

    @Override
    public boolean applyVectorArgument(String identifier, String value) {
        switch (identifier) {
            case "AV": {
                this.accessVector = AccessVector.fromString(value);
                break;
            }
            case "AC": {
                this.accessComplexity = AccessComplexity.fromString(value);
                break;
            }
            case "Au": 
            case "AU": {
                this.authentication = Authentication.fromString(value);
                break;
            }
            case "C": {
                this.confidentialityImpact = CIAImpact.fromString(value);
                break;
            }
            case "I": {
                this.integrityImpact = CIAImpact.fromString(value);
                break;
            }
            case "A": {
                this.availabilityImpact = CIAImpact.fromString(value);
                break;
            }
            case "E": {
                this.exploitability = Exploitability.fromString(value);
                break;
            }
            case "RL": {
                this.remediationLevel = RemediationLevel.fromString(value);
                break;
            }
            case "RC": {
                this.reportConfidence = ReportConfidence.fromString(value);
                break;
            }
            case "CDP": {
                this.collateralDamagePotential = CollateralDamagePotential.fromString(value);
                break;
            }
            case "TD": {
                this.targetDistribution = TargetDistribution.fromString(value);
                break;
            }
            case "CR": {
                this.confidentialityRequirement = CIARequirement.fromString(value);
                break;
            }
            case "IR": {
                this.integrityRequirement = CIARequirement.fromString(value);
                break;
            }
            case "AR": {
                this.availabilityRequirement = CIARequirement.fromString(value);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Cvss2Attribute getVectorArgument(String identifier) {
        switch (identifier) {
            case "AV": {
                return this.accessVector;
            }
            case "AC": {
                return this.accessComplexity;
            }
            case "Au": 
            case "AU": {
                return this.authentication;
            }
            case "C": {
                return this.confidentialityImpact;
            }
            case "I": {
                return this.integrityImpact;
            }
            case "A": {
                return this.availabilityImpact;
            }
            case "E": {
                return this.exploitability;
            }
            case "RL": {
                return this.remediationLevel;
            }
            case "RC": {
                return this.reportConfidence;
            }
            case "CDP": {
                return this.collateralDamagePotential;
            }
            case "TD": {
                return this.targetDistribution;
            }
            case "CR": {
                return this.confidentialityRequirement;
            }
            case "IR": {
                return this.integrityRequirement;
            }
            case "AR": {
                return this.availabilityRequirement;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cvss2)) {
            return false;
        }
        Cvss2 cvss2 = (Cvss2)o;
        return this.accessVector == cvss2.accessVector && this.accessComplexity == cvss2.accessComplexity && this.authentication == cvss2.authentication && this.confidentialityImpact == cvss2.confidentialityImpact && this.integrityImpact == cvss2.integrityImpact && this.availabilityImpact == cvss2.availabilityImpact && this.exploitability == cvss2.exploitability && this.remediationLevel == cvss2.remediationLevel && this.reportConfidence == cvss2.reportConfidence && this.collateralDamagePotential == cvss2.collateralDamagePotential && this.targetDistribution == cvss2.targetDistribution && this.confidentialityRequirement == cvss2.confidentialityRequirement && this.integrityRequirement == cvss2.integrityRequirement && this.availabilityRequirement == cvss2.availabilityRequirement;
    }

    @Override
    public double getBaseScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        double impact = this.calculateImpactScore();
        return Cvss2.round((0.6 * impact + 0.4 * this.calculateExploitabilityScore() - 1.5) * this.f(impact), 1);
    }

    private double calculateImpactScore() {
        return 10.41 * (1.0 - (1.0 - this.confidentialityImpact.factor) * (1.0 - this.integrityImpact.factor) * (1.0 - this.availabilityImpact.factor));
    }

    @Override
    public double getImpactScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        return Cvss2.round(this.calculateImpactScore(), 1);
    }

    private double calculateExploitabilityScore() {
        return 20.0 * this.accessComplexity.factor * this.authentication.factor * this.accessVector.factor;
    }

    @Override
    public double getExploitabilityScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        return Cvss2.round(this.calculateExploitabilityScore(), 1);
    }

    private double calculateTemporalScore() {
        double baseScore = this.getBaseScore();
        double exp = this.exploitability == Exploitability.NULL ? Exploitability.NOT_DEFINED.factor : this.exploitability.factor;
        double rem = this.remediationLevel == RemediationLevel.NULL ? RemediationLevel.NOT_DEFINED.factor : this.remediationLevel.factor;
        double rep = this.reportConfidence == ReportConfidence.NULL ? ReportConfidence.NOT_DEFINED.factor : this.reportConfidence.factor;
        return baseScore * exp * rem * rep;
    }

    @Override
    public double getTemporalScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        if (!this.isAnyTemporalDefined()) {
            return Double.NaN;
        }
        return Cvss2.round(this.calculateTemporalScore(), 1);
    }

    private double calculateEnvironmentalScore() {
        double col = this.collateralDamagePotential == CollateralDamagePotential.NULL ? CollateralDamagePotential.NOT_DEFINED.factor : this.collateralDamagePotential.factor;
        double tar = this.targetDistribution == TargetDistribution.NULL ? TargetDistribution.NOT_DEFINED.factor : this.targetDistribution.factor;
        double adjustedTemporal = this.calculateAdjustedTemporalScore();
        return (adjustedTemporal + (10.0 - adjustedTemporal) * col) * tar;
    }

    @Override
    public double getEnvironmentalScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        if (!this.isAnyEnvironmentalDefined()) {
            return Double.NaN;
        }
        return Cvss2.round(this.calculateEnvironmentalScore(), 1);
    }

    private double calculateAdjustedTemporalScore() {
        double exp = this.exploitability == Exploitability.NULL ? Exploitability.NOT_DEFINED.factor : this.exploitability.factor;
        double rem = this.remediationLevel == RemediationLevel.NULL ? RemediationLevel.NOT_DEFINED.factor : this.remediationLevel.factor;
        double rep = this.reportConfidence == ReportConfidence.NULL ? ReportConfidence.NOT_DEFINED.factor : this.reportConfidence.factor;
        return this.calculateAdjustedBaseScore() * exp * rem * rep;
    }

    private double f(double impact) {
        if (impact == 0.0) {
            return 0.0;
        }
        return 1.176;
    }

    private double calculateAdjustedBaseScore() {
        double adjustedImpact = this.calculateAdjustedImpact();
        return (0.6 * adjustedImpact + 0.4 * Cvss2.round(this.calculateExploitabilityScore(), 1) - 1.5) * this.f(adjustedImpact);
    }

    private double calculateAdjustedImpact() {
        double confr = this.confidentialityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED.factor : this.confidentialityRequirement.factor;
        double intr = this.integrityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED.factor : this.integrityRequirement.factor;
        double avar = this.availabilityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED.factor : this.availabilityRequirement.factor;
        return Math.min(10.0, 10.41 * (1.0 - (1.0 - this.confidentialityImpact.factor * confr) * (1.0 - this.integrityImpact.factor * intr) * (1.0 - this.availabilityImpact.factor * avar)));
    }

    @Override
    public double getAdjustedImpactScore() {
        if (!this.isBaseFullyDefined()) {
            return Double.NaN;
        }
        if (!this.isAnyEnvironmentalDefined()) {
            return Double.NaN;
        }
        return Cvss2.round(this.calculateAdjustedImpact(), 1);
    }

    @Override
    public double getOverallScore() {
        if (this.isAnyEnvironmentalDefined()) {
            return this.getEnvironmentalScore();
        }
        if (this.isAnyTemporalDefined()) {
            return this.getTemporalScore();
        }
        return this.getBaseScore();
    }

    @Override
    public CvssSeverityRanges.SeverityRange getDefaultSeverityCategory() {
        return this.getSeverityCategory(CvssSeverityRanges.CVSS_2_SEVERITY_RANGES);
    }

    public CvssSeverityRanges.SeverityRange getCvss3SeverityCategory() {
        return this.getSeverityCategory(CvssSeverityRanges.CVSS_3_SEVERITY_RANGES);
    }

    public String getAccessComplexity() {
        return this.accessComplexity.identifier;
    }

    public String getAccessVector() {
        return this.accessVector.identifier;
    }

    public String getAuthentication() {
        return this.authentication.identifier;
    }

    public String getAvailabilityImpact() {
        return this.availabilityImpact.identifier;
    }

    public String getConfidentialityImpact() {
        return this.confidentialityImpact.identifier;
    }

    public String getIntegrityImpact() {
        return this.integrityImpact.identifier;
    }

    public String getCollateralDamagePotential() {
        return this.collateralDamagePotential.identifier;
    }

    public String getExploitability() {
        return this.exploitability.identifier;
    }

    public String getConfidentialityRequirement() {
        return this.confidentialityRequirement.identifier;
    }

    public String getIntegrityRequirement() {
        return this.integrityRequirement.identifier;
    }

    public String getAvailabilityRequirement() {
        return this.availabilityRequirement.identifier;
    }

    public String getRemediationLevel() {
        return this.remediationLevel.identifier;
    }

    public String getReportConfidence() {
        return this.reportConfidence.identifier;
    }

    public String getTargetDistribution() {
        return this.targetDistribution.identifier;
    }

    public void setAccessComplexity(AccessComplexity accessComplexity) {
        this.accessComplexity = accessComplexity;
    }

    public void setAccessVector(AccessVector accessVector) {
        this.accessVector = accessVector;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setAvailabilityImpact(CIAImpact availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    public void setCollateralDamagePotential(CollateralDamagePotential collateralDamagePotential) {
        this.collateralDamagePotential = collateralDamagePotential;
    }

    public void setConfidentialityImpact(CIAImpact confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public void setIntegrityImpact(CIAImpact integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public void setExploitability(Exploitability exploitability) {
        this.exploitability = exploitability;
    }

    public void setRemediationLevel(RemediationLevel remediationLevel) {
        this.remediationLevel = remediationLevel;
    }

    public void setReportConfidence(ReportConfidence reportConfidence) {
        this.reportConfidence = reportConfidence;
    }

    public void setTargetDistribution(TargetDistribution targetDistribution) {
        this.targetDistribution = targetDistribution;
    }

    public void setConfidentialityRequirement(CIARequirement confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public void setIntegrityRequirement(CIARequirement integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public void setAvailabilityRequirement(CIARequirement availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    @Override
    public boolean isBaseFullyDefined() {
        return this.accessVector != AccessVector.NULL && this.accessComplexity != AccessComplexity.NULL && this.authentication != Authentication.NULL && this.confidentialityImpact != CIAImpact.NULL && this.integrityImpact != CIAImpact.NULL && this.availabilityImpact != CIAImpact.NULL;
    }

    @Override
    public boolean isAnyBaseDefined() {
        return this.accessVector != AccessVector.NULL || this.accessComplexity != AccessComplexity.NULL || this.authentication != Authentication.NULL || this.confidentialityImpact != CIAImpact.NULL || this.integrityImpact != CIAImpact.NULL || this.availabilityImpact != CIAImpact.NULL;
    }

    @Override
    public boolean isAnyTemporalDefined() {
        return this.exploitability != Exploitability.NULL || this.remediationLevel != RemediationLevel.NULL || this.reportConfidence != ReportConfidence.NULL;
    }

    @Override
    public boolean isTemporalFullyDefined() {
        return this.exploitability != Exploitability.NULL && this.remediationLevel != RemediationLevel.NULL && this.reportConfidence != ReportConfidence.NULL;
    }

    @Override
    public boolean isAnyEnvironmentalDefined() {
        return this.collateralDamagePotential != CollateralDamagePotential.NULL || this.targetDistribution != TargetDistribution.NULL || this.confidentialityRequirement != CIARequirement.NULL || this.integrityRequirement != CIARequirement.NULL || this.availabilityRequirement != CIARequirement.NULL;
    }

    @Override
    public boolean isEnvironmentalFullyDefined() {
        return this.collateralDamagePotential != CollateralDamagePotential.NULL && this.targetDistribution != TargetDistribution.NULL && this.confidentialityRequirement != CIARequirement.NULL && this.integrityRequirement != CIARequirement.NULL && this.availabilityRequirement != CIARequirement.NULL;
    }

    @Override
    public void clearTemporal() {
        this.exploitability = Exploitability.NULL;
        this.remediationLevel = RemediationLevel.NULL;
        this.reportConfidence = ReportConfidence.NULL;
    }

    @Override
    public void clearEnvironmental() {
        this.collateralDamagePotential = CollateralDamagePotential.NULL;
        this.targetDistribution = TargetDistribution.NULL;
        this.confidentialityRequirement = CIARequirement.NULL;
        this.integrityRequirement = CIARequirement.NULL;
        this.availabilityRequirement = CIARequirement.NULL;
    }

    @Override
    public BakedCvssVectorScores bakeScores() {
        return BakedCvssVectorScores.fromNullableCvss(this);
    }

    @Override
    public Map<String, CvssVector.CvssVectorAttribute[]> getAttributes() {
        LinkedHashMap<String, CvssVector.CvssVectorAttribute[]> attributes = new LinkedHashMap<String, CvssVector.CvssVectorAttribute[]>();
        attributes.put("AV", AccessVector.values());
        attributes.put("AC", AccessComplexity.values());
        attributes.put("Au", Authentication.values());
        attributes.put("C", CIAImpact.values());
        attributes.put("I", CIAImpact.values());
        attributes.put("A", CIAImpact.values());
        attributes.put("E", Exploitability.values());
        attributes.put("RL", RemediationLevel.values());
        attributes.put("RC", ReportConfidence.values());
        attributes.put("CDP", CollateralDamagePotential.values());
        attributes.put("TD", TargetDistribution.values());
        attributes.put("CR", CIARequirement.values());
        attributes.put("IR", CIARequirement.values());
        attributes.put("AR", CIARequirement.values());
        return attributes;
    }

    private static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static String getVersionName() {
        return "CVSS:2.0";
    }

    @Override
    public String getName() {
        return Cvss2.getVersionName();
    }

    @Override
    public String getNistFirstWebEditorLink() {
        return String.format("https://nvd.nist.gov/vuln-metrics/cvss/v2-calculator?vector=(%s)&version=2.0", this);
    }

    @Override
    public String toString(boolean filterUndefinedProperties) {
        StringBuilder vector = new StringBuilder();
        boolean appendAnyways = !filterUndefinedProperties;
        this.appendIfValid(vector, "AV", this.accessVector.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "AC", this.accessComplexity.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "Au", this.authentication.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "C", this.confidentialityImpact.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "I", this.integrityImpact.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "A", this.availabilityImpact.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "E", this.exploitability.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "RL", this.remediationLevel.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "RC", this.reportConfidence.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "CDP", this.collateralDamagePotential.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "TD", this.targetDistribution.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "CR", this.confidentialityRequirement.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "IR", this.integrityRequirement.shortIdentifier, appendAnyways);
        this.appendIfValid(vector, "AR", this.availabilityRequirement.shortIdentifier, appendAnyways);
        if (vector.length() > 0 && vector.charAt(vector.length() - 1) == '/') {
            vector.setLength(vector.length() - 1);
        }
        return vector.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    private void appendIfValid(StringBuilder builder, String prefix, String value, boolean appendAnyways) {
        if (value != null && (appendAnyways || !value.equals("X") && !value.equals("ND"))) {
            if (builder.length() > 0) {
                builder.append('/');
            }
            builder.append(prefix).append(':').append(value);
        }
    }

    @Override
    public int size() {
        int size = 0;
        if (this.accessVector != AccessVector.NULL) {
            ++size;
        }
        if (this.accessComplexity != AccessComplexity.NULL) {
            ++size;
        }
        if (this.authentication != Authentication.NULL) {
            ++size;
        }
        if (this.confidentialityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.integrityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.availabilityImpact != CIAImpact.NULL) {
            ++size;
        }
        if (this.exploitability != Exploitability.NULL) {
            ++size;
        }
        if (this.remediationLevel != RemediationLevel.NULL) {
            ++size;
        }
        if (this.reportConfidence != ReportConfidence.NULL) {
            ++size;
        }
        if (this.collateralDamagePotential != CollateralDamagePotential.NULL) {
            ++size;
        }
        if (this.targetDistribution != TargetDistribution.NULL) {
            ++size;
        }
        if (this.confidentialityRequirement != CIARequirement.NULL) {
            ++size;
        }
        if (this.integrityRequirement != CIARequirement.NULL) {
            ++size;
        }
        if (this.availabilityRequirement != CIARequirement.NULL) {
            ++size;
        }
        return size;
    }

    @Override
    public Cvss2 clone() {
        Cvss2 clone = super.cloneInternal(new Cvss2());
        clone.accessVector = this.accessVector;
        clone.accessComplexity = this.accessComplexity;
        clone.authentication = this.authentication;
        clone.confidentialityImpact = this.confidentialityImpact;
        clone.integrityImpact = this.integrityImpact;
        clone.availabilityImpact = this.availabilityImpact;
        clone.exploitability = this.exploitability;
        clone.remediationLevel = this.remediationLevel;
        clone.reportConfidence = this.reportConfidence;
        clone.collateralDamagePotential = this.collateralDamagePotential;
        clone.targetDistribution = this.targetDistribution;
        clone.confidentialityRequirement = this.confidentialityRequirement;
        clone.integrityRequirement = this.integrityRequirement;
        clone.availabilityRequirement = this.availabilityRequirement;
        return clone;
    }

    @Override
    protected void completeVector() {
        this.cleanupTemporalVectorParts();
        this.cleanupEnvironmentalVectorParts();
    }

    private void cleanupTemporalVectorParts() {
        if (this.isAnyTemporalDefined()) {
            this.exploitability = this.exploitability == Exploitability.NULL ? Exploitability.NOT_DEFINED : this.exploitability;
            this.remediationLevel = this.remediationLevel == RemediationLevel.NULL ? RemediationLevel.NOT_DEFINED : this.remediationLevel;
            ReportConfidence reportConfidence = this.reportConfidence = this.reportConfidence == ReportConfidence.NULL ? ReportConfidence.NOT_DEFINED : this.reportConfidence;
        }
        if (this.isTemporalAllPartsNotDefined()) {
            this.clearTemporal();
        }
    }

    private void cleanupEnvironmentalVectorParts() {
        if (this.isAnyEnvironmentalDefined()) {
            this.collateralDamagePotential = this.collateralDamagePotential == CollateralDamagePotential.NULL ? CollateralDamagePotential.NOT_DEFINED : this.collateralDamagePotential;
            this.targetDistribution = this.targetDistribution == TargetDistribution.NULL ? TargetDistribution.NOT_DEFINED : this.targetDistribution;
            this.confidentialityRequirement = this.confidentialityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED : this.confidentialityRequirement;
            this.integrityRequirement = this.integrityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED : this.integrityRequirement;
            CIARequirement cIARequirement = this.availabilityRequirement = this.availabilityRequirement == CIARequirement.NULL ? CIARequirement.NOT_DEFINED : this.availabilityRequirement;
        }
        if (this.isEnvironmentalAllPartsNotDefined()) {
            this.clearEnvironmental();
        }
    }

    private boolean isTemporalAllPartsNotDefined() {
        return this.exploitability == Exploitability.NOT_DEFINED && this.remediationLevel == RemediationLevel.NOT_DEFINED && this.reportConfidence == ReportConfidence.NOT_DEFINED;
    }

    private boolean isEnvironmentalAllPartsNotDefined() {
        return this.collateralDamagePotential == CollateralDamagePotential.NOT_DEFINED && this.targetDistribution == TargetDistribution.NOT_DEFINED && this.confidentialityRequirement == CIARequirement.NOT_DEFINED && this.integrityRequirement == CIARequirement.NOT_DEFINED && this.availabilityRequirement == CIARequirement.NOT_DEFINED;
    }

    public static Optional<Cvss2> optionalParse(String vector) {
        if (vector == null || StringUtils.isEmpty((CharSequence)CvssVector.normalizeVector(vector))) {
            return Optional.empty();
        }
        return Optional.of(new Cvss2(vector));
    }

    public static interface Cvss2Attribute
    extends CvssVector.CvssVectorAttribute {
        @Override
        default public boolean isSet() {
            return !this.getIdentifier().equals("NOT_DEFINED") && !this.getIdentifier().equals("NULL");
        }

        public static <T extends Cvss2Attribute> T fromString(String part, Class<T> clazz, T defaultValue) {
            Map<String, Cvss2Attribute> cache;
            if (ATTRIBUTE_CACHE.containsKey(clazz)) {
                cache = (Map)ATTRIBUTE_CACHE.get(clazz);
            } else {
                cache = new HashMap();
                ATTRIBUTE_CACHE.put(clazz, cache);
            }
            if (cache.containsKey(part)) {
                return (T)((Cvss2Attribute)cache.get(part));
            }
            for (Cvss2Attribute value : (Cvss2Attribute[])clazz.getEnumConstants()) {
                if (value.getShortIdentifier().equalsIgnoreCase(part)) {
                    cache.put(part, value);
                    return (T)value;
                }
                if (!value.getIdentifier().equalsIgnoreCase(part)) continue;
                cache.put(part, value);
                return (T)value;
            }
            cache.put(part, defaultValue);
            return defaultValue;
        }
    }

    public static enum CIARequirement implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        LOW("LOW", "L", 0.5),
        MEDIUM("MEDIUM", "M", 1.0),
        HIGH("HIGH", "H", 1.51),
        NOT_DEFINED("NOT_DEFINED", "ND", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private CIARequirement(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static CIARequirement fromString(String part) {
            return Cvss2Attribute.fromString(part, CIARequirement.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum TargetDistribution implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        NONE("NONE", "N", 0.0),
        LOW("LOW", "L", 0.25),
        MEDIUM("MEDIUM", "M", 0.75),
        HIGH("HIGH", "H", 1.0),
        NOT_DEFINED("NOT_DEFINED", "ND", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private TargetDistribution(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static TargetDistribution fromString(String part) {
            return Cvss2Attribute.fromString(part, TargetDistribution.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum CollateralDamagePotential implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        NONE("NONE", "N", 0.0),
        LOW("LOW", "L", 0.1),
        LOW_MEDIUM("LOW_MEDIUM", "LM", 0.3),
        MEDIUM_HIGH("MEDIUM_HIGH", "MH", 0.4),
        HIGH("HIGH", "H", 0.5),
        NOT_DEFINED("NOT_DEFINED", "ND", 0.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private CollateralDamagePotential(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static CollateralDamagePotential fromString(String part) {
            return Cvss2Attribute.fromString(part, CollateralDamagePotential.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum ReportConfidence implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        UNCONFIRMED("UNCONFIRMED", "UC", 0.9),
        UNCORROBORATED("UNCORROBORATED", "UR", 0.95),
        CONFIRMED("CONFIRMED", "C", 1.0),
        NOT_DEFINED("NOT_DEFINED", "ND", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private ReportConfidence(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static ReportConfidence fromString(String part) {
            return Cvss2Attribute.fromString(part, ReportConfidence.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum RemediationLevel implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        OFFICIAL("OFFICIAL", "OF", 0.87),
        TEMPORARY("TEMPORARY", "TF", 0.9),
        WORKAROUND("WORKAROUND", "W", 0.95),
        UNAVAILABLE("UNAVAILABLE", "U", 1.0),
        NOT_DEFINED("NOT_DEFINED", "ND", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private RemediationLevel(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static RemediationLevel fromString(String part) {
            return Cvss2Attribute.fromString(part, RemediationLevel.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum Exploitability implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        UNPROVEN("UNPROVEN", "U", 0.85),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT", "POC", 0.9),
        FUNCTIONAL("FUNCTIONAL", "F", 0.95),
        HIGH("HIGH", "H", 1.0),
        NOT_DEFINED("NOT_DEFINED", "ND", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private Exploitability(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static Exploitability fromString(String part) {
            return Cvss2Attribute.fromString(part, Exploitability.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum CIAImpact implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        NONE("NONE", "N", 0.0),
        PARTIAL("PARTIAL", "P", 0.275),
        COMPLETE("COMPLETE", "C", 0.66);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private CIAImpact(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static CIAImpact fromString(String part) {
            return Cvss2Attribute.fromString(part, CIAImpact.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum Authentication implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        MULTIPLE("MULTIPLE", "M", 0.45),
        SINGLE("SINGLE", "S", 0.56),
        NONE("NONE", "N", 0.704);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private Authentication(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static Authentication fromString(String part) {
            return Cvss2Attribute.fromString(part, Authentication.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum AccessComplexity implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        HIGH("HIGH", "H", 0.35),
        MEDIUM("MEDIUM", "M", 0.61),
        LOW("LOW", "L", 0.71);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private AccessComplexity(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static AccessComplexity fromString(String part) {
            return Cvss2Attribute.fromString(part, AccessComplexity.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }

    public static enum AccessVector implements Cvss2Attribute
    {
        NULL("NULL", "X", 0.0),
        LOCAL("LOCAL", "L", 0.395),
        ADJACENT_NETWORK("ADJACENT_NETWORK", "A", 0.646),
        NETWORK("NETWORK", "N", 1.0);

        public final String identifier;
        public final String shortIdentifier;
        public final double factor;

        private AccessVector(String identifier, String shortIdentifier, double factor) {
            this.identifier = identifier;
            this.shortIdentifier = shortIdentifier;
            this.factor = factor;
        }

        public static AccessVector fromString(String part) {
            return Cvss2Attribute.fromString(part, AccessVector.class, NULL);
        }

        @Override
        public String getShortIdentifier() {
            return this.shortIdentifier;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }
}

