/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalCvssCalculatorLinkGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(UniversalCvssCalculatorLinkGenerator.class);
    private String baseUrl = "https://metaeffekt.com/security/cvss/calculator";
    private final List<UniversalCvssCalculatorEntry<?>> entries = new ArrayList();
    private final Set<String> openSections = new LinkedHashSet<String>();
    private final Set<String> cves = new LinkedHashSet<String>();
    private CvssVector selectedVector;

    public <V extends CvssVector> UniversalCvssCalculatorEntry<V> addVectorNullThrowing(V cvssVector, String name, boolean visible) {
        if (cvssVector == null) {
            throw new IllegalArgumentException("CVSS vector to be added must not be null.");
        }
        UniversalCvssCalculatorEntry<V> entry = new UniversalCvssCalculatorEntry<V>(cvssVector, name, visible);
        this.entries.add(entry);
        return entry;
    }

    public <V extends CvssVector> UniversalCvssCalculatorEntry<V> addVectorNullThrowing(V cvssVector) {
        return this.addVectorNullThrowing(cvssVector, cvssVector == null ? "unknown" : cvssVector.getCombinedCvssSource(true).replace("CVSS:", ""), true);
    }

    public <V extends CvssVector> UniversalCvssCalculatorEntry<V> addVector(V cvssVector, String name, boolean visible) {
        if (cvssVector == null) {
            return new UniversalCvssCalculatorEntry<Object>(null, name, visible);
        }
        UniversalCvssCalculatorEntry<V> entry = new UniversalCvssCalculatorEntry<V>(cvssVector, name, visible);
        this.entries.add(entry);
        return entry;
    }

    public <V extends CvssVector> UniversalCvssCalculatorEntry<V> addVector(V cvssVector) {
        return this.addVector(cvssVector, cvssVector == null ? "unknown" : cvssVector.getCombinedCvssSource(true).replace("CVSS:", ""), true);
    }

    public <V extends CvssVector> UniversalCvssCalculatorEntry<V> addVectorForVulnerability(V cvssVector, String vulnerabilityName) {
        List<CvssSource> sources;
        if (StringUtils.isEmpty((CharSequence)vulnerabilityName)) {
            return this.addVector(cvssVector);
        }
        StringBuilder nameBuilder = new StringBuilder();
        if (cvssVector == null) {
            nameBuilder.append("unknown ");
        } else {
            nameBuilder.append(cvssVector.getName().replace("CVSS:", "")).append(" ");
        }
        if (vulnerabilityName.startsWith("CVE-")) {
            nameBuilder.append(vulnerabilityName.replace("CVE-", "")).append(" ");
        } else {
            nameBuilder.append(vulnerabilityName).append(" ");
        }
        if (cvssVector != null && !(sources = cvssVector.getCvssSources()).isEmpty()) {
            StringJoiner sourceJoiner = new StringJoiner(", ", "(", ")");
            for (CvssSource source : sources) {
                String[] parts;
                if (source.getIssuingEntity() != null && KnownCvssEntities.ASSESSMENT != source.getHostingEntity()) {
                    parts = ((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{source.getIssuingEntity().getEmail(), source.getIssuingEntity().getName()})).split("@");
                    sourceJoiner.add(parts[parts.length - 1]);
                    continue;
                }
                if (source.getHostingEntity() == null) continue;
                parts = ((String)StringUtils.firstNonEmpty((CharSequence[])new String[]{source.getHostingEntity().getEmail(), source.getHostingEntity().getName()})).split("@");
                sourceJoiner.add(parts[parts.length - 1]);
            }
            nameBuilder.append(sourceJoiner);
        }
        return this.addVector(cvssVector, nameBuilder.toString().trim(), true);
    }

    public UniversalCvssCalculatorLinkGenerator addOpenSection(String section) {
        this.openSections.add(section);
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator addOpenSections(String ... section) {
        for (String s : section) {
            this.addOpenSection(s);
        }
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator addOpenSections(Collection<String> sections) {
        this.openSections.addAll(sections);
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator setSelectedVectorNullThrowing(CvssVector selectedVector) {
        if (this.findVectorEntryByVector(selectedVector) == null) {
            throw new IllegalArgumentException("Selected vector must be added to the link generator first.");
        }
        this.selectedVector = selectedVector;
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator setSelectedVectorNullThrowing(String selectedVector) {
        UniversalCvssCalculatorEntry<?> foundVector = this.findVectorEntryByName(selectedVector);
        if (foundVector == null) {
            throw new IllegalArgumentException("Selected vector must be added to the link generator first.");
        }
        this.selectedVector = foundVector.getCvssVector();
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator setSelectedVector(CvssVector selectedVector) {
        if (this.findVectorEntryByVector(selectedVector) != null) {
            this.selectedVector = selectedVector;
        }
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator setSelectedVector(String selectedVector) {
        UniversalCvssCalculatorEntry<?> foundVector = this.findVectorEntryByName(selectedVector);
        if (foundVector != null) {
            this.selectedVector = foundVector.getCvssVector();
        }
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public UniversalCvssCalculatorLinkGenerator addCve(String cve) {
        this.cves.add(cve);
        return this;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty() && this.cves.isEmpty();
    }

    protected <V extends CvssVector> UniversalCvssCalculatorEntry<V> findVectorEntryByVector(V searchVector) {
        if (searchVector == null) {
            return null;
        }
        for (UniversalCvssCalculatorEntry<?> entry : this.entries) {
            if (!entry.getCvssVector().equals(searchVector)) continue;
            return entry;
        }
        return null;
    }

    protected UniversalCvssCalculatorEntry<?> findVectorEntryByName(String searchVectorName) {
        if (searchVectorName == null) {
            return null;
        }
        for (UniversalCvssCalculatorEntry<?> entry : this.entries) {
            if (!entry.getName().equals(searchVectorName)) continue;
            return entry;
        }
        return null;
    }

    public String generateOptimizedLink() {
        List<String> candidates = Arrays.asList(this.generateBas64EncodedGzipCompressedLink(), this.generateLink());
        Optional<String> optimizedLink = candidates.stream().filter(Objects::nonNull).filter(link -> link.length() < 2000).min(Comparator.comparingInt(String::length));
        return optimizedLink.orElse(this.generateLink());
    }

    public String generateLink() {
        StringBuilder linkBuilder = new StringBuilder();
        linkBuilder.append(this.baseUrl);
        Map<String, String> parameters = this.generateUrlParameters(true);
        if (!parameters.isEmpty()) {
            linkBuilder.append("?");
            ArrayList<String> parameterStrings = new ArrayList<String>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                parameterStrings.add(entry.getKey() + "=" + entry.getValue());
            }
            linkBuilder.append(String.join((CharSequence)"&", parameterStrings));
        }
        return linkBuilder.toString();
    }

    public String generateBas64EncodedGzipCompressedLink() {
        StringBuilder linkBuilder = new StringBuilder();
        linkBuilder.append(this.baseUrl);
        Map<String, String> parameters = this.generateUrlParameters(false);
        if (!parameters.isEmpty()) {
            String urlEncoded;
            linkBuilder.append("?b64gzip=");
            ArrayList<String> parameterStrings = new ArrayList<String>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                parameterStrings.add(entry.getKey() + "=" + entry.getValue());
            }
            String dataToBeGZipped = String.join((CharSequence)"&", parameterStrings);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(dataToBeGZipped.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOG.error("Failed to compress data: {}", (Object)dataToBeGZipped, (Object)e);
                return this.generateLink();
            }
            String base64Encoded = Base64.getUrlEncoder().withoutPadding().encodeToString(byteArrayOutputStream.toByteArray());
            try {
                urlEncoded = URLEncoder.encode(base64Encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Failed encode parameter value, resuming with default platform encoding: {}", (Object)base64Encoded, (Object)e);
                urlEncoded = URLEncoder.encode(base64Encoded);
            }
            linkBuilder.append(urlEncoded);
        }
        return linkBuilder.toString();
    }

    private Map<String, String> generateUrlParameters(boolean urlEncode) {
        UniversalCvssCalculatorEntry<CvssVector> selectedVectorEntry;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (!this.entries.isEmpty()) {
            JSONArray vectorArray = new JSONArray();
            this.entries.stream().map(UniversalCvssCalculatorEntry::generateCvssVectorArrayEntry).forEach(arg_0 -> ((JSONArray)vectorArray).put(arg_0));
            parameters.put("vector", vectorArray.toString());
        }
        if (!this.openSections.isEmpty()) {
            parameters.put("open", String.join((CharSequence)",", this.openSections));
        }
        if (this.selectedVector != null && (selectedVectorEntry = this.findVectorEntryByVector(this.selectedVector)) != null) {
            parameters.put("selected", selectedVectorEntry.getName());
        }
        if (!this.cves.isEmpty()) {
            parameters.put("cve", String.join((CharSequence)",", this.cves));
        }
        if (urlEncode) {
            for (Map.Entry entry : parameters.entrySet()) {
                try {
                    entry.setValue(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Failed encode parameter value, resuming with default platform encoding: {}", entry.getValue(), (Object)e);
                    entry.setValue(URLEncoder.encode((String)entry.getValue()));
                }
            }
        }
        return parameters;
    }

    public String toString() {
        return this.generateLink();
    }

    public static class UniversalCvssCalculatorEntry<V extends CvssVector> {
        private final V cvssVector;
        private V initialCvssVector;
        private String name;
        private boolean visible;

        public UniversalCvssCalculatorEntry(V cvssVector, String name, boolean visible) {
            this.cvssVector = cvssVector;
            this.name = name;
            this.visible = visible;
        }

        public String getName() {
            return this.name;
        }

        public UniversalCvssCalculatorEntry<V> setName(String name) {
            this.name = name;
            return this;
        }

        public UniversalCvssCalculatorEntry<V> setInitialCvssVector(V initialCvssVector) {
            this.initialCvssVector = initialCvssVector;
            return this;
        }

        public UniversalCvssCalculatorEntry<V> setInitialCvssVectorUnchecked(CvssVector initialCvssVectorUnchecked) {
            this.initialCvssVector = initialCvssVectorUnchecked;
            return this;
        }

        public V getCvssVector() {
            return this.cvssVector;
        }

        public V getInitialCvssVector() {
            return this.initialCvssVector;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public UniversalCvssCalculatorEntry<V> setVisible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public JSONArray generateCvssVectorArrayEntry() {
            JSONArray vectorEntry = new JSONArray();
            vectorEntry.put((Object)this.name);
            vectorEntry.put(this.isVisible());
            vectorEntry.put((Object)(this.cvssVector == null ? "" : this.cvssVector.toString()));
            vectorEntry.put((Object)(this.cvssVector == null ? "CVSS:2.0" : ((CvssVector)this.cvssVector).getName()));
            if (this.initialCvssVector != null) {
                vectorEntry.put((Object)this.initialCvssVector.toString());
            } else {
                vectorEntry.put((Object)null);
            }
            return vectorEntry;
        }
    }
}

