/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.processor.CvssVectorSet;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvssSelector
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(CvssSelector.class);
    private final List<CvssRule> rules;
    private final List<SelectorStatsEvaluator> statsEvaluatorActions;
    private final List<SelectorVectorEvaluator> selectorVectorEvaluators;

    public CvssSelector(List<CvssRule> rules, List<SelectorStatsEvaluator> statsEvaluatorActions, List<SelectorVectorEvaluator> selectorVectorEvaluators) {
        if (rules == null) {
            throw new IllegalArgumentException("rules must not be null");
        }
        if (statsEvaluatorActions == null) {
            throw new IllegalArgumentException("statsEvaluatorActions must not be null");
        }
        if (selectorVectorEvaluators == null) {
            throw new IllegalArgumentException("selectorVectorEvaluators must not be null");
        }
        this.rules = rules;
        this.statsEvaluatorActions = statsEvaluatorActions;
        this.selectorVectorEvaluators = selectorVectorEvaluators;
    }

    public CvssSelector(List<CvssRule> rules) {
        this(rules, Collections.emptyList(), Collections.emptyList());
    }

    public <T extends CvssVector> T selectVector(Collection<T> vectors) {
        CvssVector effective = null;
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (CvssRule rule : this.rules) {
            T chosenVector = rule.getSourceSelector().selectVector(vectors);
            List<SelectorVectorEvaluator> vectorEvaluators = rule.getVectorEvaluators();
            boolean skip = false;
            for (SelectorVectorEvaluator selectorVectorEvaluator : vectorEvaluators) {
                if (!selectorVectorEvaluator.evaluate((CvssVector)chosenVector)) continue;
                EvaluatorAction action = selectorVectorEvaluator.getAction();
                if (action == EvaluatorAction.RETURN_NULL) {
                    return null;
                }
                if (action == EvaluatorAction.FAIL) {
                    throw new IllegalStateException("Evaluator action failed: " + selectorVectorEvaluator + " on " + this);
                }
                if (action == EvaluatorAction.SKIP) {
                    skip = true;
                    break;
                }
                if (action != EvaluatorAction.RETURN_PREVIOUS) continue;
                return (T)effective;
            }
            if (chosenVector == null && vectorEvaluators.isEmpty()) {
                for (SelectorStatsCollector selectorStatsCollector : rule.getStatsCollectors()) {
                    selectorStatsCollector.apply(stats, 0, 1, () -> 0);
                }
                skip = true;
            }
            if (skip) continue;
            if (chosenVector != null) {
                if (effective == null) {
                    effective = ((CvssVector)chosenVector).clone();
                    for (SelectorStatsCollector selectorStatsCollector : rule.getStatsCollectors()) {
                        selectorStatsCollector.apply(stats, 1, 0, effective::size);
                    }
                    continue;
                }
                Pair result = rule.getMergingMethod().mergeVectors(effective, (CvssVector)chosenVector);
                effective = ((CvssVector)result.getLeft()).deriveAddSource(((CvssVector)chosenVector).getCvssSource());
                for (SelectorStatsCollector collector3 : rule.getStatsCollectors()) {
                    collector3.apply(stats, 1, 0, () -> result.getRight());
                }
                continue;
            }
            for (SelectorStatsCollector selectorStatsCollector : rule.getStatsCollectors()) {
                selectorStatsCollector.apply(stats, 0, 1, () -> 0);
            }
        }
        for (SelectorStatsEvaluator statsEvaluatorAction : this.statsEvaluatorActions) {
            Integer value = stats.getOrDefault(statsEvaluatorAction.getAttributeName(), 0);
            if (!statsEvaluatorAction.getComparator().test(value, statsEvaluatorAction.getComparisonValue())) continue;
            EvaluatorAction action = statsEvaluatorAction.getAction();
            if (action == EvaluatorAction.RETURN_NULL) {
                return null;
            }
            if (action != EvaluatorAction.FAIL) continue;
            throw new IllegalStateException("Evaluator action failed: " + statsEvaluatorAction + " on " + this);
        }
        for (SelectorVectorEvaluator vectorEvaluator : this.selectorVectorEvaluators) {
            if (!vectorEvaluator.evaluate(effective)) continue;
            EvaluatorAction action = vectorEvaluator.getAction();
            if (action == EvaluatorAction.RETURN_NULL) {
                return null;
            }
            if (action != EvaluatorAction.FAIL) continue;
            throw new IllegalStateException("Evaluator action failed: " + vectorEvaluator + " on " + this);
        }
        return (T)effective;
    }

    public <T extends CvssVector> T selectVector(Collection<?> vectors, Class<T> vectorClass) {
        List checkVectors = vectors.stream().filter(v -> vectorClass.isAssignableFrom(v.getClass())).map(v -> (CvssVector)v).collect(Collectors.toList());
        return this.selectVector(checkVectors);
    }

    public <T extends CvssVector> T selectVector(CvssVectorSet vectors, Class<T> vectorClass) {
        return this.selectVector(vectors.getCvssVectors(), vectorClass);
    }

    public JSONObject toJson() {
        JSONArray rules = new JSONArray();
        for (CvssRule cvssRule : this.rules) {
            rules.put((Object)cvssRule.toJson());
        }
        JSONArray stats = new JSONArray();
        for (SelectorStatsEvaluator statsEvaluatorAction : this.statsEvaluatorActions) {
            stats.put((Object)statsEvaluatorAction.toJson());
        }
        JSONArray jSONArray = new JSONArray((Collection)this.selectorVectorEvaluators.stream().map(SelectorVectorEvaluator::toJson).collect(Collectors.toList()));
        return new JSONObject().put("rules", (Object)rules).put("stats", (Object)stats).put("vectorEval", (Object)jSONArray);
    }

    public static CvssSelector fromJson(String jsonString) {
        JSONObject json;
        try {
            json = new JSONObject(jsonString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse json string as JSONObject for CvssSelector: " + jsonString, e);
        }
        return CvssSelector.fromJson(json);
    }

    public static CvssSelector fromJson(JSONObject json) {
        List<SelectorStatsEvaluator> statsEvaluatorActions;
        JSONArray jsonStats;
        List<CvssRule> rules;
        JSONArray jsonRules = json.optJSONArray("rules");
        if (jsonRules != null) {
            rules = new ArrayList();
            for (int i = 0; i < jsonRules.length(); ++i) {
                rules.add(CvssRule.fromJson(jsonRules.getJSONObject(i)));
            }
        } else {
            rules = Collections.emptyList();
        }
        if ((jsonStats = json.optJSONArray("stats")) != null) {
            statsEvaluatorActions = new ArrayList();
            for (int i = 0; i < jsonStats.length(); ++i) {
                statsEvaluatorActions.add(SelectorStatsEvaluator.fromJson(jsonStats.getJSONObject(i)));
            }
        } else {
            statsEvaluatorActions = Collections.emptyList();
        }
        return new CvssSelector(rules, statsEvaluatorActions, SelectorVectorEvaluator.fromParentJson(json));
    }

    public List<CvssRule> getRules() {
        return this.rules;
    }

    public List<SelectorStatsEvaluator> getStatsEvaluatorActions() {
        return this.statsEvaluatorActions;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public CvssSelector clone() {
        return new CvssSelector(this.rules.stream().map(CvssRule::clone).collect(Collectors.toList()));
    }

    public String explain() {
        return this.explain(null);
    }

    public String explain(String selectorName) {
        StringBuilder explanation = new StringBuilder();
        Function<String, String> escape = s -> s != null ? s.replace("\\", "\\\\").replace("`", "\\`").replace("*", "\\*").replace("_", "\\_").replace("{", "\\{").replace("}", "\\}").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)").replace("#", "\\#").replace("+", "\\+").replace("-", "\\-").replace(".", "\\.").replace("!", "\\!").replace("|", "\\|").replace("~", "\\~").replace(">", "\\>") : "";
        if (!this.rules.isEmpty()) {
            if (selectorName != null) {
                explanation.append("The [").append(escape.apply(selectorName)).append("]");
            } else {
                explanation.append("The");
            }
            explanation.append(" CVSS Selector contains [").append(this.rules.size()).append("] rule").append(this.rules.size() == 1 ? "" : "s").append(" that will be applied in the following order:\n");
            StringJoiner rulesExplanation = new StringJoiner("\n- ", "- ", "");
            for (CvssRule rule : this.rules) {
                StringBuilder ruleExplanation = new StringBuilder();
                StringJoiner ruleSegmentsJoiner = new StringJoiner(", ");
                for (SourceSelectorEntry source : rule.getSourceSelector().getPreferredSources()) {
                    StringJoiner ruleSegments = new StringJoiner("-", "[", "]");
                    if (source.getHostingEntities().isEmpty()) {
                        ruleSegments.add("*");
                    } else if (source.getHostingEntities().size() == 1) {
                        ruleSegments.add(escape.apply(source.getHostingEntities().get(0).toString()));
                    } else {
                        ruleSegments.add(source.getHostingEntities().stream().map(Object::toString).map(escape).collect(Collectors.joining(" AND ", "(", ")")));
                    }
                    if (source.getIssuingEntityRoles().isEmpty()) {
                        ruleSegments.add("*");
                    } else if (source.getIssuingEntityRoles().size() == 1) {
                        ruleSegments.add(escape.apply(source.getIssuingEntityRoles().get(0).toString()));
                    } else {
                        ruleSegments.add(source.getIssuingEntityRoles().stream().map(Object::toString).map(escape).collect(Collectors.joining(" AND ", "(", ")")));
                    }
                    if (source.getIssuingEntities().isEmpty()) {
                        ruleSegments.add("*");
                    } else if (source.getIssuingEntities().size() == 1) {
                        ruleSegments.add(escape.apply(source.getIssuingEntities().get(0).toString()));
                    } else {
                        ruleSegments.add(source.getIssuingEntities().stream().map(Object::toString).map(escape).collect(Collectors.joining(" AND ", "(", ")")));
                    }
                    ruleSegmentsJoiner.add(ruleSegments.toString());
                }
                if (rule.getSourceSelector().getPreferredSources().size() == 1) {
                    ruleExplanation.append("If present, the ").append(ruleSegmentsJoiner).append(" vector is selected.");
                } else {
                    ruleExplanation.append("The first matching vector is selected: ").append(ruleSegmentsJoiner);
                }
                if (!rule.getVectorEvaluators().isEmpty()) {
                    ruleExplanation.append("\nThe following [").append(rule.getVectorEvaluators().size()).append("]").append(" vector evaluator").append(rule.getVectorEvaluators().size() == 1 ? "" : "s").append(" will be applied to the selected vector before applying it to the resulting vector:\n");
                    StringJoiner vectorEvaluatorsJoiner = new StringJoiner("\n- ", "- ", "");
                    for (SelectorVectorEvaluator vectorEvaluator : rule.getVectorEvaluators()) {
                        Map<VectorEvaluatorOperation, Boolean> operations = vectorEvaluator.getOperations();
                        EvaluatorAction action = vectorEvaluator.getAction();
                        StringBuilder operationsBuilder = new StringBuilder();
                        if (operations.isEmpty()) {
                            operationsBuilder.append("Since no selector is specified, the following is always applied: ");
                        } else {
                            operationsBuilder.append("If the selected vector is ").append(operations.entrySet().stream().map(e -> (String)escape.apply(((VectorEvaluatorOperation)((Object)((Object)e.getKey()))).toPotentiallyInvertedPrettyString((Boolean)e.getValue()))).collect(Collectors.joining("] AND [", "[", "]"))).append(", then ");
                        }
                        if (action == EvaluatorAction.RETURN_NULL) {
                            operationsBuilder.append("[no vector is returned].");
                        } else if (action == EvaluatorAction.RETURN_PREVIOUS) {
                            operationsBuilder.append("the [previous vector is returned].");
                        } else if (action == EvaluatorAction.FAIL) {
                            operationsBuilder.append("the [evaluation fails].");
                        } else if (action == EvaluatorAction.SKIP) {
                            operationsBuilder.append("the [evaluation is skipped].");
                        } else {
                            operationsBuilder.append("[no (known) operation is specified].");
                        }
                        vectorEvaluatorsJoiner.add(operationsBuilder.toString());
                    }
                    ruleExplanation.append(vectorEvaluatorsJoiner);
                }
                ruleExplanation.append("\nFrom the selected vector, ");
                if (rule.getMergingMethod() == MergingMethod.ALL) {
                    ruleExplanation.append("[all] vector components are applied to the resulting vector.");
                } else if (rule.getMergingMethod() == MergingMethod.LOWER) {
                    ruleExplanation.append("only vector components that lead to a [lower or equal] score on the resulting vector are applied.");
                } else if (rule.getMergingMethod() == MergingMethod.HIGHER) {
                    ruleExplanation.append("only vector components that lead to a [higher or equal] score on the resulting vector are applied.");
                } else if (rule.getMergingMethod() == MergingMethod.OVERWRITE) {
                    ruleExplanation.append("the resulting vector is [overwritten].");
                } else {
                    ruleExplanation.append("No (known) operation is specified for the merging method.");
                }
                if (!rule.getStatsCollectors().isEmpty()) {
                    ruleExplanation.append("\nThe following [").append(rule.getStatsCollectors().size()).append("] statistics collector").append(rule.getStatsCollectors().size() == 1 ? "" : "s").append(" will also be applied to the selected vector:\n");
                    StringJoiner statsJoiner = new StringJoiner("\n- ", "- ", "");
                    for (SelectorStatsCollector statsCollector : rule.getStatsCollectors()) {
                        StringBuilder statsExplanation = new StringBuilder();
                        if (statsCollector.getProvider() == StatsCollectorProvider.ABSENCE) {
                            statsExplanation.append("If no vector is returned from the selection, ");
                        } else if (statsCollector.getProvider() == StatsCollectorProvider.PRESENCE) {
                            statsExplanation.append("If a vector is returned from the selection, ");
                        } else if (statsCollector.getProvider() == StatsCollectorProvider.APPLIED_PARTS_COUNT) {
                            statsExplanation.append("If a vector is returned from the selection, ");
                        }
                        if (statsCollector.getSetType() == StatsCollectorSetType.MAX) {
                            statsExplanation.append("the larger value between ");
                        } else if (statsCollector.getSetType() == StatsCollectorSetType.MIN) {
                            statsExplanation.append("the smaller value between ");
                        }
                        if (statsCollector.getProvider() == StatsCollectorProvider.ABSENCE) {
                            statsExplanation.append("[1] ");
                        } else if (statsCollector.getProvider() == StatsCollectorProvider.PRESENCE) {
                            statsExplanation.append("[1] ");
                        } else if (statsCollector.getProvider() == StatsCollectorProvider.APPLIED_PARTS_COUNT) {
                            statsExplanation.append("the [amount of applied vector components] ");
                        }
                        if (statsCollector.getSetType() == StatsCollectorSetType.ADD) {
                            statsExplanation.append("is added to ");
                        } else if (statsCollector.getSetType() == StatsCollectorSetType.SUBTRACT) {
                            statsExplanation.append("is subtracted from ");
                        } else if (statsCollector.getSetType() == StatsCollectorSetType.MAX) {
                            statsExplanation.append("and the previous value is set to ");
                        } else if (statsCollector.getSetType() == StatsCollectorSetType.MIN) {
                            statsExplanation.append("and the previous value is set to ");
                        } else if (statsCollector.getSetType() == StatsCollectorSetType.SET) {
                            statsExplanation.append("is set to ");
                        }
                        statsExplanation.append("the stats collector attribute [").append(escape.apply(statsCollector.getAttributeName())).append("].");
                        statsJoiner.add(statsExplanation);
                    }
                    ruleExplanation.append(statsJoiner);
                }
                rulesExplanation.add(ruleExplanation.toString().replace("\n", "\n  "));
            }
            explanation.append(rulesExplanation);
        } else {
            explanation.append("The CVSS Selector contains no rules. The resulting vector will be [not defined].");
        }
        if (!this.statsEvaluatorActions.isEmpty()) {
            if (explanation.length() > 0) {
                explanation.append("\n\n");
            }
            explanation.append("After finishing the cvss selection, [").append(this.statsEvaluatorActions.size()).append("] statistics evaluator").append(this.statsEvaluatorActions.size() == 1 ? "" : "s").append(" will be applied to the resulting vector:\n");
            StringJoiner statsEvaluatorJoiner = new StringJoiner("\n- ", "- ", "");
            for (SelectorStatsEvaluator statsEvaluatorAction : this.statsEvaluatorActions) {
                StringBuilder statsEvaluatorExplanation = new StringBuilder();
                statsEvaluatorExplanation.append("If the stats collector attribute [").append(escape.apply(statsEvaluatorAction.getAttributeName())).append("] is [").append(statsEvaluatorAction.getComparator().name().replace("_", " ").toLowerCase()).append("] to [").append(statsEvaluatorAction.getComparisonValue()).append("], then ");
                if (statsEvaluatorAction.getAction() == EvaluatorAction.RETURN_NULL) {
                    statsEvaluatorExplanation.append("[no vector is returned].");
                } else if (statsEvaluatorAction.getAction() == EvaluatorAction.FAIL) {
                    statsEvaluatorExplanation.append("the [evaluation fails].");
                } else if (statsEvaluatorAction.getAction() == EvaluatorAction.SKIP) {
                    statsEvaluatorExplanation.append("the [evaluation would be skipped], this action is not supported for stats evaluators however so nothing will happen.");
                } else if (statsEvaluatorAction.getAction() == EvaluatorAction.RETURN_PREVIOUS) {
                    statsEvaluatorExplanation.append("the [previous vector would be returned], this action is not supported for stats evaluators however so nothing will happen.");
                } else {
                    statsEvaluatorExplanation.append("[no (known) operation is specified].");
                }
                statsEvaluatorJoiner.add(statsEvaluatorExplanation);
            }
            explanation.append(statsEvaluatorJoiner);
        }
        if (!this.selectorVectorEvaluators.isEmpty()) {
            if (!this.statsEvaluatorActions.isEmpty()) {
                explanation.append("\nAdditionally, [");
            } else {
                explanation.append("\n\nAfter finishing the cvss selection, [");
            }
            explanation.append(this.selectorVectorEvaluators.size()).append("] vector evaluator").append(this.selectorVectorEvaluators.size() == 1 ? "" : "s").append(" will be applied to the resulting vector:\n");
            StringJoiner vectorEvaluatorsJoiner = new StringJoiner("\n- ", "- ", "");
            for (SelectorVectorEvaluator vectorEvaluator : this.selectorVectorEvaluators) {
                Map<VectorEvaluatorOperation, Boolean> operations = vectorEvaluator.getOperations();
                EvaluatorAction action = vectorEvaluator.getAction();
                StringBuilder operationsBuilder = new StringBuilder();
                if (operations.isEmpty()) {
                    operationsBuilder.append("Since no selector is specified, the following is always applied: ");
                } else {
                    operationsBuilder.append("If the resulting vector is ").append(operations.entrySet().stream().map(e -> (String)escape.apply(((VectorEvaluatorOperation)((Object)((Object)e.getKey()))).toPotentiallyInvertedPrettyString((Boolean)e.getValue()))).collect(Collectors.joining("] AND [", "[", "]"))).append(", then ");
                }
                if (action == EvaluatorAction.RETURN_NULL) {
                    operationsBuilder.append("[no vector is returned].");
                } else if (action == EvaluatorAction.RETURN_PREVIOUS) {
                    operationsBuilder.append("the [previous vector is returned].");
                } else if (action == EvaluatorAction.FAIL) {
                    operationsBuilder.append("the [evaluation fails].");
                } else if (action == EvaluatorAction.SKIP) {
                    operationsBuilder.append("the [evaluation is skipped].");
                } else {
                    operationsBuilder.append("[no (known) operation is specified].");
                }
                vectorEvaluatorsJoiner.add(operationsBuilder.toString());
            }
            explanation.append(vectorEvaluatorsJoiner);
        }
        return explanation.toString().replace("[", "`[").replace("]", "]`");
    }

    public static enum EvaluatorAction {
        FAIL,
        RETURN_NULL,
        SKIP,
        RETURN_PREVIOUS;

    }

    public static enum VectorEvaluatorOperation {
        IS_NULL(Objects::isNull),
        IS_BASE_FULLY_DEFINED(CvssVector::isBaseFullyDefined),
        IS_BASE_PARTIALLY_DEFINED(CvssVector::isAnyBaseDefined),
        IS_ENVIRONMENTAL_PARTIALLY_DEFINED(vector -> vector instanceof MultiScoreCvssVector ? ((MultiScoreCvssVector)vector).isAnyEnvironmentalDefined() : (vector instanceof Cvss4P0 ? ((Cvss4P0)vector).isAnyEnvironmentalDefined() : false)),
        IS_TEMPORAL_PARTIALLY_DEFINED(vector -> vector instanceof MultiScoreCvssVector ? ((MultiScoreCvssVector)vector).isAnyTemporalDefined() : false),
        IS_THREAT_PARTIALLY_DEFINED(vector -> vector instanceof MultiScoreCvssVector ? false : (vector instanceof Cvss4P0 ? ((Cvss4P0)vector).isAnyThreatDefined() : false));

        private final Predicate<CvssVector> predicate;

        private VectorEvaluatorOperation(Predicate<CvssVector> predicate) {
            this.predicate = predicate;
        }

        public boolean test(CvssVector vector) {
            return this.predicate.test(vector);
        }

        public String toPotentiallyInvertedString(boolean inverted) {
            return (inverted ? "not:" : "") + this.name();
        }

        public String toPotentiallyInvertedPrettyString(boolean inverted) {
            return (inverted ? "not " : "") + this.name().toLowerCase().replace("_", " ").replace("is", "").replaceAll(" +", " ").replace("null", "not defined").trim();
        }

        public static Pair<VectorEvaluatorOperation, Boolean> extractPotentiallyInverted(String value) {
            if (value == null) {
                return Pair.of(null, (Object)false);
            }
            if (value.startsWith("not:")) {
                return Pair.of((Object)((Object)VectorEvaluatorOperation.valueOf(value.substring(4))), (Object)true);
            }
            return Pair.of((Object)((Object)VectorEvaluatorOperation.valueOf(value)), (Object)false);
        }
    }

    public static enum StatsEvaluatorOperation {
        EQUAL(Objects::equals),
        SMALLER((left, right) -> left < right),
        SMALLER_OR_EQUAL((left, right) -> left <= right),
        GREATER((left, right) -> left > right),
        GREATER_OR_EQUAL((left, right) -> left >= right);

        private final BiPredicate<Integer, Integer> predicate;

        private StatsEvaluatorOperation(BiPredicate<Integer, Integer> predicate) {
            this.predicate = predicate;
        }

        public boolean test(int left, int right) {
            return this.predicate.test(left, right);
        }
    }

    public static enum StatsCollectorSetType {
        ADD,
        SUBTRACT,
        SET,
        MAX,
        MIN;

    }

    public static enum StatsCollectorProvider {
        PRESENCE,
        ABSENCE,
        APPLIED_PARTS_COUNT;

    }

    public static enum MergingMethod {
        ALL((base, newVector) -> {
            CvssVector clone = base.clone();
            int parts = clone.applyVector(newVector.toString());
            return Pair.of((Object)clone, (Object)parts);
        }),
        LOWER((base, newVector) -> {
            CvssVector clone = base.clone();
            int parts = clone.applyVectorPartsIfLower(newVector.toString(), CvssVector::getOverallScore);
            return Pair.of((Object)clone, (Object)parts);
        }),
        HIGHER((base, newVector) -> {
            CvssVector clone = base.clone();
            int parts = clone.applyVectorPartsIfHigher(newVector.toString(), CvssVector::getOverallScore);
            return Pair.of((Object)clone, (Object)parts);
        }),
        LOWER_METRIC((base, newVector) -> {
            CvssVector clone = base.clone();
            int parts = clone.applyVectorPartsIfMetricsLower(newVector.toString());
            return Pair.of((Object)clone, (Object)parts);
        }),
        HIGHER_METRIC((base, newVector) -> {
            CvssVector clone = base.clone();
            int parts = clone.applyVectorPartsIfMetricsHigher(newVector.toString());
            return Pair.of((Object)clone, (Object)parts);
        }),
        OVERWRITE((base, newVector) -> Pair.of((Object)newVector.clone(), (Object)0));

        private final BiFunction<CvssVector, CvssVector, Pair<CvssVector, Integer>> mergingFunction;

        private MergingMethod(BiFunction<CvssVector, CvssVector, Pair<CvssVector, Integer>> mergingFunction) {
            this.mergingFunction = mergingFunction;
        }

        public <T extends CvssVector> Pair<T, Integer> mergeVectors(CvssVector base, CvssVector newVector) {
            return this.mergingFunction.apply(base, newVector);
        }
    }

    public static class SelectorStatsEvaluator
    implements Cloneable {
        private final String attributeName;
        private final StatsEvaluatorOperation comparator;
        private final EvaluatorAction action;
        private final Integer comparisonValue;

        public SelectorStatsEvaluator(String attributeName, StatsEvaluatorOperation comparator, EvaluatorAction action, Integer comparisonValue) {
            this.attributeName = attributeName;
            this.comparator = comparator;
            this.action = action;
            this.comparisonValue = comparisonValue;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public StatsEvaluatorOperation getComparator() {
            return this.comparator;
        }

        public EvaluatorAction getAction() {
            return this.action;
        }

        public Integer getComparisonValue() {
            return this.comparisonValue;
        }

        public JSONObject toJson() {
            return new JSONObject().put("attribute", (Object)this.attributeName).put("comparator", (Object)this.comparator.name()).put("action", (Object)this.action.name()).put("value", (Object)this.comparisonValue);
        }

        public static SelectorStatsEvaluator fromJson(JSONObject json) {
            return new SelectorStatsEvaluator(json.getString("attribute"), StatsEvaluatorOperation.valueOf(json.getString("comparator")), EvaluatorAction.valueOf(json.getString("action")), json.getInt("value"));
        }

        public String toString() {
            return this.toJson().toString();
        }

        public SelectorStatsEvaluator clone() {
            return new SelectorStatsEvaluator(this.attributeName, this.comparator, this.action, this.comparisonValue);
        }
    }

    public static class SelectorVectorEvaluator
    implements Cloneable {
        private final Map<VectorEvaluatorOperation, Boolean> operations;
        private final EvaluatorAction action;

        public SelectorVectorEvaluator(Map<VectorEvaluatorOperation, Boolean> operations, EvaluatorAction action) {
            this.operations = operations;
            this.action = action;
        }

        public SelectorVectorEvaluator(VectorEvaluatorOperation operation, boolean inverted, EvaluatorAction action) {
            this.operations = Collections.singletonMap(operation, inverted);
            this.action = action;
        }

        public SelectorVectorEvaluator(VectorEvaluatorOperation operation, EvaluatorAction action) {
            this.operations = Collections.singletonMap(operation, false);
            this.action = action;
        }

        public boolean evaluate(CvssVector vector) {
            for (Map.Entry<VectorEvaluatorOperation, Boolean> entry : this.operations.entrySet()) {
                VectorEvaluatorOperation operation = entry.getKey();
                Boolean isInverted = entry.getValue();
                if (vector == null) {
                    if (operation == VectorEvaluatorOperation.IS_NULL) {
                        return isInverted == false;
                    }
                    return isInverted;
                }
                boolean result = operation.test(vector);
                boolean effective = isInverted != result;
                if (effective) continue;
                return false;
            }
            return true;
        }

        public Map<VectorEvaluatorOperation, Boolean> getOperations() {
            return this.operations;
        }

        public EvaluatorAction getAction() {
            return this.action;
        }

        public JSONObject toJson() {
            return new JSONObject().put("action", (Object)this.action.name()).put("and", (Object)new JSONArray((Collection)this.operations.entrySet().stream().map(e -> ((VectorEvaluatorOperation)((Object)((Object)e.getKey()))).toPotentiallyInvertedString((Boolean)e.getValue())).collect(Collectors.toList())));
        }

        public static SelectorVectorEvaluator fromJson(JSONObject json) {
            HashMap<VectorEvaluatorOperation, Boolean> operations = new HashMap<VectorEvaluatorOperation, Boolean>();
            JSONArray jsonOperations = json.getJSONArray("and");
            for (int i = 0; i < jsonOperations.length(); ++i) {
                String operation = jsonOperations.getString(i);
                Pair<VectorEvaluatorOperation, Boolean> pair = VectorEvaluatorOperation.extractPotentiallyInverted(operation);
                operations.put((VectorEvaluatorOperation)((Object)pair.getLeft()), (Boolean)pair.getRight());
            }
            return new SelectorVectorEvaluator(operations, EvaluatorAction.valueOf(json.getString("action")));
        }

        private static List<SelectorVectorEvaluator> fromParentJson(JSONObject json) {
            JSONArray vectorEvaluators = json.optJSONArray("vectorEval");
            if (vectorEvaluators != null) {
                ArrayList<SelectorVectorEvaluator> selectorVectorEvaluators = new ArrayList<SelectorVectorEvaluator>();
                for (int i = 0; i < vectorEvaluators.length(); ++i) {
                    selectorVectorEvaluators.add(SelectorVectorEvaluator.fromJson(vectorEvaluators.getJSONObject(i)));
                }
                return selectorVectorEvaluators;
            }
            return Collections.emptyList();
        }

        public String toString() {
            return this.toJson().toString();
        }

        public SelectorVectorEvaluator clone() {
            return new SelectorVectorEvaluator(new HashMap<VectorEvaluatorOperation, Boolean>(this.operations), this.action);
        }
    }

    public static class SelectorStatsCollector
    implements Cloneable {
        private final String attributeName;
        private final StatsCollectorProvider provider;
        private final StatsCollectorSetType setType;

        public SelectorStatsCollector(String attributeName, StatsCollectorProvider provider, StatsCollectorSetType setType) {
            this.attributeName = attributeName;
            this.provider = provider;
            this.setType = setType;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public StatsCollectorProvider getProvider() {
            return this.provider;
        }

        public StatsCollectorSetType getSetType() {
            return this.setType;
        }

        public void apply(Map<String, Integer> stats, int presence, int absence, Supplier<Integer> sizeSupplier) {
            int value;
            if (this.provider == StatsCollectorProvider.PRESENCE) {
                value = presence;
            } else if (this.provider == StatsCollectorProvider.ABSENCE) {
                value = absence;
            } else if (this.provider == StatsCollectorProvider.APPLIED_PARTS_COUNT) {
                value = sizeSupplier.get();
            } else {
                throw new IllegalStateException("Unknown provider: " + (Object)((Object)this.provider));
            }
            if (this.setType == StatsCollectorSetType.ADD) {
                stats.merge(this.attributeName, value, Integer::sum);
            } else if (this.setType == StatsCollectorSetType.SUBTRACT) {
                stats.merge(this.attributeName, value, (a, b) -> a - b);
            } else if (this.setType == StatsCollectorSetType.SET) {
                stats.put(this.attributeName, value);
            } else if (this.setType == StatsCollectorSetType.MAX) {
                stats.merge(this.attributeName, value, Integer::max);
            } else if (this.setType == StatsCollectorSetType.MIN) {
                stats.merge(this.attributeName, value, Integer::min);
            } else {
                throw new IllegalStateException("Unknown set type: " + (Object)((Object)this.setType));
            }
        }

        public JSONObject toJson() {
            return new JSONObject().put("attribute", (Object)this.attributeName).put("provider", (Object)this.provider.name()).put("setType", (Object)this.setType.name());
        }

        public static SelectorStatsCollector fromJson(JSONObject json) {
            return new SelectorStatsCollector(json.getString("attribute"), StatsCollectorProvider.valueOf(json.getString("provider")), StatsCollectorSetType.valueOf(json.getString("setType")));
        }

        public String toString() {
            return this.toJson().toString();
        }

        public SelectorStatsCollector clone() {
            return new SelectorStatsCollector(this.attributeName, this.provider, this.setType);
        }
    }

    public static class SourceSelectorEntryEntry<T extends CvssSource.EntityNameProvider>
    implements Cloneable {
        private final T value;
        private final boolean inverted;

        public SourceSelectorEntryEntry(T value, boolean inverted) {
            this.value = value;
            this.inverted = inverted;
        }

        public SourceSelectorEntryEntry(T value) {
            this(value, false);
        }

        protected boolean potentiallyInvert(boolean value) {
            return this.inverted != value;
        }

        public boolean matches(CvssSource.EntityNameProvider checkValue) {
            String thisName;
            String checkName = checkValue == null ? null : checkValue.getName();
            String string = thisName = this.value == null ? null : this.value.getName();
            if (checkName == null && thisName == null) {
                return this.potentiallyInvert(true);
            }
            if (SourceSelectorEntry.ANY_ENTITY.getName().equals(thisName)) {
                return this.potentiallyInvert(true);
            }
            if (checkName == null || thisName == null) {
                return this.potentiallyInvert(false);
            }
            if (SourceSelectorEntry.ANY_ENTITY.getName().equals(checkName)) {
                return this.potentiallyInvert(true);
            }
            if (checkName.equals(thisName)) {
                return this.potentiallyInvert(true);
            }
            return this.potentiallyInvert(false);
        }

        public T getValue() {
            return this.value;
        }

        public boolean isInverted() {
            return this.inverted;
        }

        public String toString() {
            return (this.inverted ? "not:" : "") + (this.value == null ? "" : this.value.getName());
        }

        public static <T extends CvssSource.EntityNameProvider> SourceSelectorEntryEntry<T> from(Object value, Function<String, T> extractor) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return SourceSelectorEntryEntry.fromString((String)value, extractor);
            }
            if (value instanceof JSONObject) {
                return SourceSelectorEntryEntry.fromJson((JSONObject)value, extractor);
            }
            throw new IllegalArgumentException("Cannot create SourceSelectorEntryEntry from " + value);
        }

        protected static <T extends CvssSource.EntityNameProvider> SourceSelectorEntryEntry<T> fromString(String value, Function<String, T> extractor) {
            if (value == null) {
                return null;
            }
            if (value.startsWith("not:")) {
                String param = value.substring(4);
                return new SourceSelectorEntryEntry<CvssSource.EntityNameProvider>((CvssSource.EntityNameProvider)extractor.apply(param.isEmpty() ? null : param), true);
            }
            return new SourceSelectorEntryEntry<CvssSource.EntityNameProvider>((CvssSource.EntityNameProvider)extractor.apply(value.isEmpty() ? null : value), false);
        }

        protected static <T extends CvssSource.EntityNameProvider> SourceSelectorEntryEntry<T> fromJson(JSONObject json, Function<String, T> extractor) {
            boolean inverted = json.optBoolean("inverted", false);
            JSONObject valueJson = json.optJSONObject("value");
            if (valueJson == null) {
                throw new IllegalArgumentException("SourceSelectorEntryEntry 'value' must be a JSONObject: " + json);
            }
            return new SourceSelectorEntryEntry<CvssSource.EntityNameProvider>((CvssSource.EntityNameProvider)extractor.apply(valueJson.optString("name", null)), inverted);
        }

        public SourceSelectorEntryEntry<T> clone() {
            return new SourceSelectorEntryEntry<T>(this.value, this.inverted);
        }
    }

    public static class SourceSelectorEntry
    implements Cloneable {
        private final List<SourceSelectorEntryEntry<CvssSource.CvssEntity>> hostingEntities;
        private final List<SourceSelectorEntryEntry<CvssSource.CvssEntity>> issuingEntities;
        private final List<SourceSelectorEntryEntry<CvssSource.CvssIssuingEntityRole>> issuingEntityRoles;
        public static final CvssSource.CvssEntity ANY_ENTITY = new CvssSource.CvssEntity("*");
        public static final CvssSource.CvssIssuingEntityRole ANY_ROLE = new CvssSource.CvssIssuingEntityRole("*");
        public static final CvssSource.CvssEntity EMPTY_ENTITY = null;
        public static final CvssSource.CvssIssuingEntityRole EMPTY_ROLE = null;

        public SourceSelectorEntry(List<SourceSelectorEntryEntry<CvssSource.CvssEntity>> hostingEntities, List<SourceSelectorEntryEntry<CvssSource.CvssIssuingEntityRole>> issuingEntityRoles, List<SourceSelectorEntryEntry<CvssSource.CvssEntity>> issuingEntities) {
            this.hostingEntities = hostingEntities;
            this.issuingEntityRoles = issuingEntityRoles;
            this.issuingEntities = issuingEntities;
        }

        public SourceSelectorEntry(CvssSource.CvssEntity hostingEntity, CvssSource.CvssIssuingEntityRole issuingEntityRole, CvssSource.CvssEntity issuingEntity, boolean invertedHostingEntity, boolean invertedIssuingEntity, boolean invertedIssuingEntityRole) {
            this.hostingEntities = hostingEntity == null && !invertedHostingEntity ? Collections.emptyList() : Collections.singletonList(new SourceSelectorEntryEntry<CvssSource.CvssEntity>(hostingEntity, invertedHostingEntity));
            this.issuingEntityRoles = issuingEntityRole == null && !invertedIssuingEntity ? Collections.emptyList() : Collections.singletonList(new SourceSelectorEntryEntry<CvssSource.CvssIssuingEntityRole>(issuingEntityRole, invertedIssuingEntityRole));
            this.issuingEntities = issuingEntity == null && !invertedIssuingEntityRole ? Collections.emptyList() : Collections.singletonList(new SourceSelectorEntryEntry<CvssSource.CvssEntity>(issuingEntity, invertedIssuingEntity));
        }

        public SourceSelectorEntry(CvssSource.CvssEntity hostingEntity, CvssSource.CvssIssuingEntityRole issuingEntityRole, CvssSource.CvssEntity issuingEntity) {
            this(hostingEntity, issuingEntityRole, issuingEntity, false, false, false);
        }

        public List<SourceSelectorEntryEntry<CvssSource.CvssEntity>> getHostingEntities() {
            return this.hostingEntities;
        }

        public List<SourceSelectorEntryEntry<CvssSource.CvssEntity>> getIssuingEntities() {
            return this.issuingEntities;
        }

        public List<SourceSelectorEntryEntry<CvssSource.CvssIssuingEntityRole>> getIssuingEntityRoles() {
            return this.issuingEntityRoles;
        }

        public boolean matches(CvssSource source) {
            if (source == null) {
                return false;
            }
            boolean matchesHost = this.matchListWithSource(this.hostingEntities, source.getHostingEntity());
            boolean matchesIssuer = this.matchListWithSource(this.issuingEntities, source.getIssuingEntity());
            boolean matchesRole = this.matchListWithSource(this.issuingEntityRoles, source.getIssuingEntityRole());
            return matchesHost && matchesIssuer && matchesRole;
        }

        private <T extends CvssSource.EntityNameProvider> boolean matchListWithSource(List<SourceSelectorEntryEntry<T>> list, T sourceAttribute) {
            if (sourceAttribute == null && list.isEmpty()) {
                return true;
            }
            return !list.isEmpty() && list.stream().allMatch(entry -> entry.matches(sourceAttribute));
        }

        public JSONObject toJson() {
            return new JSONObject().put("host", (Object)new JSONArray((Collection)this.hostingEntities.stream().map(String::valueOf).collect(Collectors.toList()))).put("issuerRole", (Object)new JSONArray((Collection)this.issuingEntityRoles.stream().map(String::valueOf).collect(Collectors.toList()))).put("issuer", (Object)new JSONArray((Collection)this.issuingEntities.stream().map(String::valueOf).collect(Collectors.toList())));
        }

        public static SourceSelectorEntry fromJson(JSONObject json) {
            try {
                ArrayList<SourceSelectorEntryEntry<CvssSource.CvssEntity>> hostingEntities = new ArrayList<SourceSelectorEntryEntry<CvssSource.CvssEntity>>();
                ArrayList<SourceSelectorEntryEntry<CvssSource.CvssIssuingEntityRole>> issuingEntityRoles = new ArrayList<SourceSelectorEntryEntry<CvssSource.CvssIssuingEntityRole>>();
                ArrayList<SourceSelectorEntryEntry<CvssSource.CvssEntity>> issuingEntities = new ArrayList<SourceSelectorEntryEntry<CvssSource.CvssEntity>>();
                JSONArray host = (JSONArray)ObjectUtils.firstNonNull((Object[])new JSONArray[]{json.optJSONArray("host"), json.optJSONArray("hostingEntities")});
                for (int i = 0; i < host.length(); ++i) {
                    hostingEntities.add(SourceSelectorEntryEntry.from(host.get(i), CvssSource.CvssEntity::new));
                }
                JSONArray issuerRole = (JSONArray)ObjectUtils.firstNonNull((Object[])new JSONArray[]{json.optJSONArray("issuerRole"), json.optJSONArray("issuingEntityRoles")});
                for (int i = 0; i < issuerRole.length(); ++i) {
                    issuingEntityRoles.add(SourceSelectorEntryEntry.from(issuerRole.get(i), CvssSource.CvssIssuingEntityRole::new));
                }
                JSONArray issuer = (JSONArray)ObjectUtils.firstNonNull((Object[])new JSONArray[]{json.optJSONArray("issuer"), json.optJSONArray("issuingEntities")});
                for (int i = 0; i < issuer.length(); ++i) {
                    issuingEntities.add(SourceSelectorEntryEntry.from(issuer.get(i), CvssSource.CvssEntity::new));
                }
                return new SourceSelectorEntry(hostingEntities, issuingEntityRoles, issuingEntities);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse SourceSelectorEntry from json: " + json, e);
            }
        }

        private static String getPotentiallyInvertedOrNullName(CvssSource.EntityNameProvider nameProvider, boolean inverted) {
            if (nameProvider == null) {
                return null;
            }
            if (inverted) {
                return "not:" + nameProvider.getName();
            }
            return nameProvider.getName();
        }

        private static <T> Pair<T, Boolean> extractPotentiallyInverted(String value, Function<String, T> extractor) {
            if (value == null) {
                return Pair.of(null, (Object)false);
            }
            if (value.startsWith("not:")) {
                return Pair.of(extractor.apply(value.substring(4)), (Object)true);
            }
            return Pair.of(extractor.apply(value), (Object)false);
        }

        public String toString() {
            return this.toJson().toString();
        }

        public SourceSelectorEntry clone() {
            return new SourceSelectorEntry(this.hostingEntities.stream().map(SourceSelectorEntryEntry::clone).collect(Collectors.toList()), this.issuingEntityRoles.stream().map(SourceSelectorEntryEntry::clone).collect(Collectors.toList()), this.issuingEntities.stream().map(SourceSelectorEntryEntry::clone).collect(Collectors.toList()));
        }
    }

    public static class SourceSelector
    implements Cloneable {
        private final List<SourceSelectorEntry> preferredSources;

        public SourceSelector(List<SourceSelectorEntry> preferredSources) {
            this.preferredSources = preferredSources;
        }

        public SourceSelector(SourceSelectorEntry ... preferredSources) {
            this.preferredSources = Arrays.asList(preferredSources);
        }

        public <T extends CvssVector> T selectVector(Collection<T> vectors) {
            for (SourceSelectorEntry source : this.preferredSources) {
                for (CvssVector vector : vectors) {
                    if (!source.matches(vector.getCvssSource())) continue;
                    return (T)vector;
                }
            }
            return null;
        }

        public CvssVector selectVectorUnchecked(Collection<CvssVector> vectors) {
            for (SourceSelectorEntry source : this.preferredSources) {
                for (CvssVector vector : vectors) {
                    if (!source.matches(vector.getCvssSource())) continue;
                    return vector;
                }
            }
            return null;
        }

        public JSONArray toJson() {
            JSONArray preferredSources = new JSONArray();
            for (SourceSelectorEntry entry : this.preferredSources) {
                preferredSources.put((Object)entry.toJson());
            }
            return preferredSources;
        }

        public static SourceSelector fromJson(Object json) {
            if (json instanceof JSONArray) {
                return SourceSelector.fromJson((JSONArray)json);
            }
            if (json instanceof JSONObject) {
                return SourceSelector.fromJson((JSONObject)json);
            }
            throw new IllegalArgumentException(SourceSelector.class.getSimpleName() + ": json must be either a JSONArray or JSONObject");
        }

        public static SourceSelector fromJson(JSONArray json) {
            if (json == null) {
                throw new IllegalArgumentException(SourceSelector.class.getSimpleName() + ": json must not be null when creating from json");
            }
            ArrayList<SourceSelectorEntry> entries = new ArrayList<SourceSelectorEntry>();
            for (int i = 0; i < json.length(); ++i) {
                entries.add(SourceSelectorEntry.fromJson(json.getJSONObject(i)));
            }
            return new SourceSelector(entries);
        }

        public static SourceSelector fromJson(JSONObject json) {
            JSONArray preferredSources = json.optJSONArray("preferredSources");
            if (preferredSources == null) {
                throw new IllegalArgumentException(SourceSelector.class.getSimpleName() + ": json must contain a 'preferredSources' array");
            }
            return SourceSelector.fromJson(preferredSources);
        }

        public List<SourceSelectorEntry> getPreferredSources() {
            return this.preferredSources;
        }

        public String toString() {
            return this.toJson().toString();
        }

        public SourceSelector clone() {
            return new SourceSelector(this.preferredSources.stream().map(SourceSelectorEntry::clone).collect(Collectors.toList()));
        }
    }

    public static class CvssRule
    implements Cloneable {
        private final SourceSelector sourceSelector;
        private final MergingMethod mergingMethod;
        private final List<SelectorStatsCollector> statsCollectors;
        private final List<SelectorVectorEvaluator> vectorEvaluators;

        public CvssRule(MergingMethod mergingMethod, List<SelectorStatsCollector> statsCollectors, List<SelectorVectorEvaluator> vectorEvaluators, SourceSelector sourceSelector) {
            this.mergingMethod = mergingMethod;
            this.statsCollectors = statsCollectors;
            this.vectorEvaluators = vectorEvaluators;
            this.sourceSelector = sourceSelector;
        }

        public CvssRule(MergingMethod mergingMethod, List<SelectorStatsCollector> statsCollectors, List<SelectorVectorEvaluator> vectorEvaluators, SourceSelectorEntry ... preferredSources) {
            this.mergingMethod = mergingMethod;
            this.statsCollectors = statsCollectors;
            this.vectorEvaluators = vectorEvaluators;
            this.sourceSelector = new SourceSelector(preferredSources);
        }

        public CvssRule(MergingMethod mergingMethod, SourceSelector sourceSelector) {
            this(mergingMethod, Collections.emptyList(), Collections.emptyList(), sourceSelector);
        }

        public CvssRule(MergingMethod mergingMethod, SourceSelectorEntry ... preferredSources) {
            this(mergingMethod, Collections.emptyList(), Collections.emptyList(), preferredSources);
        }

        public JSONObject toJson() {
            JSONArray vectorEvaluators = new JSONArray((Collection)this.vectorEvaluators.stream().map(SelectorVectorEvaluator::toJson).collect(Collectors.toList()));
            return new JSONObject().put("vectorEval", (Object)vectorEvaluators).put("selector", (Object)this.sourceSelector.toJson()).put("stats", (Collection)this.statsCollectors.stream().map(SelectorStatsCollector::toJson).collect(Collectors.toList())).put("method", (Object)this.mergingMethod.name());
        }

        public static CvssRule fromJson(JSONObject json) {
            List<SelectorStatsCollector> statsCollectors;
            JSONArray stats = json.optJSONArray("stats");
            if (stats != null) {
                statsCollectors = new ArrayList();
                for (int i = 0; i < stats.length(); ++i) {
                    statsCollectors.add(SelectorStatsCollector.fromJson(stats.getJSONObject(i)));
                }
            } else {
                statsCollectors = Collections.emptyList();
            }
            try {
                return new CvssRule(MergingMethod.valueOf((String)ObjectUtils.firstNonNull((Object[])new String[]{json.optString("method", null), json.optString("mergingMethod", null)})), statsCollectors, (List<SelectorVectorEvaluator>)SelectorVectorEvaluator.fromParentJson(json), SourceSelector.fromJson(ObjectUtils.firstNonNull((Object[])new Object[]{json.opt("selector"), json.opt("sourceSelector")})));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse CvssRule from json with keys " + json.keySet() + ": " + json, e);
            }
        }

        public SourceSelector getSourceSelector() {
            return this.sourceSelector;
        }

        public MergingMethod getMergingMethod() {
            return this.mergingMethod;
        }

        public List<SelectorStatsCollector> getStatsCollectors() {
            return this.statsCollectors;
        }

        public List<SelectorVectorEvaluator> getVectorEvaluators() {
            return this.vectorEvaluators;
        }

        public String toString() {
            return this.toJson().toString();
        }

        public CvssRule clone() {
            return new CvssRule(this.mergingMethod, this.getStatsCollectors().stream().map(SelectorStatsCollector::clone).collect(Collectors.toList()), this.getVectorEvaluators().stream().map(SelectorVectorEvaluator::clone).collect(Collectors.toList()), this.sourceSelector.clone());
        }
    }
}

