/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.processor.BakedCvssVectorScores;
import org.metaeffekt.core.security.cvss.processor.UniversalCvssCalculatorLinkGenerator;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3;
import org.metaeffekt.core.security.cvss.v3.Cvss3P0;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CvssVector {
    private static final Logger LOG = LoggerFactory.getLogger(CvssVector.class);
    protected final List<CvssSource> sources = new ArrayList<CvssSource>();
    protected final JSONObject applicabilityCondition;
    protected BakedCvssVectorScores bakedScores;
    private static final Pattern PARENTHESIS_PATTERN = Pattern.compile("[()]");
    private static final Pattern CVSS_PATTERN = Pattern.compile("CVSS:\\d+\\.?\\d?");
    public static final String VALUE_NOT_DEFINED = "NOT_DEFINED";
    public static final String VALUE_NULL = "NULL";

    public CvssVector() {
        this.applicabilityCondition = new JSONObject();
    }

    public CvssVector(CvssSource source) {
        this.addSource(source);
        this.applicabilityCondition = new JSONObject();
    }

    public CvssVector(CvssSource source, JSONObject applicabilityCondition) {
        this.addSource(source);
        this.applicabilityCondition = applicabilityCondition;
    }

    public CvssVector(Collection<CvssSource> sources, JSONObject applicabilityCondition) {
        this.addSources(sources);
        this.applicabilityCondition = applicabilityCondition;
    }

    public abstract String getName();

    public String getWebEditorLink() {
        return this.getAeUniversalWebEditorLink().generateOptimizedLink();
    }

    public abstract String getNistFirstWebEditorLink();

    public UniversalCvssCalculatorLinkGenerator getAeUniversalWebEditorLink() {
        UniversalCvssCalculatorLinkGenerator generator = new UniversalCvssCalculatorLinkGenerator();
        generator.addVectorNullThrowing(this);
        generator.setSelectedVectorNullThrowing(this);
        return generator;
    }

    public abstract int size();

    public abstract double getBaseScore();

    public abstract double getOverallScore();

    public abstract boolean isBaseFullyDefined();

    public abstract boolean isAnyBaseDefined();

    protected abstract void completeVector();

    public abstract boolean applyVectorArgument(String var1, String var2);

    public abstract CvssVectorAttribute getVectorArgument(String var1);

    public abstract CvssVector clone();

    protected abstract BakedCvssVectorScores bakeScores();

    public abstract Map<String, CvssVectorAttribute[]> getAttributes();

    public BakedCvssVectorScores getBakedScores() {
        if (this.bakedScores == null) {
            this.bakedScores = this.bakeScores();
        }
        return this.bakedScores;
    }

    public void clearBakedScores() {
        this.bakedScores = null;
    }

    public JSONObject getApplicabilityCondition() {
        return this.applicabilityCondition;
    }

    public void putAllApplicabilityCondition(Map<String, Object> condition) {
        for (String key : condition.keySet()) {
            this.applicabilityCondition.put(key, condition.get(key));
        }
    }

    public void putAllApplicabilityCondition(JSONObject condition) {
        for (String key : condition.keySet()) {
            this.applicabilityCondition.put(key, condition.get(key));
        }
    }

    public CvssVector deriveAddSource(CvssSource source) {
        CvssVector clone = this.clone();
        clone.addSource(source);
        return clone;
    }

    public CvssVector deriveAddSources(Collection<CvssSource> sources) {
        CvssVector clone = this.clone();
        clone.addSources(sources);
        return clone;
    }

    protected void addSource(CvssSource source) {
        Objects.requireNonNull(source, "Vector source must not be null");
        this.sources.add(source);
    }

    protected void addSources(Collection<CvssSource> sources) {
        Objects.requireNonNull(sources, "Vector sources collection must not be null when adding multiple sources");
        sources.forEach(source -> Objects.requireNonNull(source, "Vector source must not be null when adding multiple sources " + sources));
        this.sources.addAll(sources);
    }

    public List<CvssSource> getCvssSources() {
        return this.sources;
    }

    public CvssSource getLatestSource() {
        if (!this.sources.isEmpty()) {
            return this.sources.get(this.sources.size() - 1);
        }
        return null;
    }

    public CvssSource getInitialSource() {
        if (!this.sources.isEmpty()) {
            return this.sources.get(0);
        }
        return null;
    }

    public CvssSource getCvssSource() {
        return this.getInitialSource();
    }

    public String getCombinedCvssSource(boolean includeVersion) {
        return CvssSource.toCombinedColumnHeaderString(this.sources, includeVersion);
    }

    public boolean containsSource(CvssSource source) {
        return this.sources.contains(source);
    }

    public int applyVector(String vector) {
        if (vector == null) {
            return 0;
        }
        String normalizedVector = CvssVector.normalizeVector(vector);
        return this.applyNormalizedVector(normalizedVector);
    }

    protected int applyNormalizedVector(String normalizedVector) {
        if (StringUtils.isEmpty((CharSequence)normalizedVector)) {
            return 0;
        }
        int appliedCount = 0;
        int start = 0;
        int length = normalizedVector.length();
        while (start < length) {
            int end;
            int mid;
            while (start < length && normalizedVector.charAt(start) == '/') {
                ++start;
            }
            if (start >= length) break;
            for (mid = start; mid < length && normalizedVector.charAt(mid) != ':' && normalizedVector.charAt(mid) != '/'; ++mid) {
            }
            if (mid < length && normalizedVector.charAt(mid) == ':') {
                for (end = mid + 1; end < length && normalizedVector.charAt(end) != '/'; ++end) {
                }
                if (this.applyVectorArgument(normalizedVector.substring(start, mid), normalizedVector.substring(mid + 1, end))) {
                    ++appliedCount;
                }
            } else {
                for (end = mid; end < length && normalizedVector.charAt(end) != '/'; ++end) {
                }
                LOG.debug("Unknown vector argument: [{}]", (Object)normalizedVector.substring(start, end));
            }
            start = end;
        }
        this.completeVector();
        this.bakedScores = null;
        return appliedCount;
    }

    int applyVectorPartsIf(String vector, Function<CvssVector, Double> scoreType, boolean lower) {
        if (vector == null) {
            return 0;
        }
        String normalizedVector = CvssVector.normalizeVector(vector);
        if (normalizedVector.isEmpty()) {
            return 0;
        }
        String[] arguments = normalizedVector.split("/");
        int appliedPartsCount = 0;
        for (String argument : arguments) {
            if (StringUtils.isEmpty((CharSequence)argument)) continue;
            String[] parts = argument.split(":", 2);
            CvssVector clone = this.clone();
            double currentScore = scoreType.apply(clone);
            if (parts.length == 2) {
                clone.applyVectorArgument(parts[0], parts[1]);
                clone.completeVector();
                double newScore = scoreType.apply(clone);
                if (lower) {
                    if (!(newScore <= currentScore)) continue;
                    appliedPartsCount += this.applyVectorArgument(parts[0], parts[1]) ? 1 : 0;
                    this.completeVector();
                    continue;
                }
                if (!(newScore >= currentScore)) continue;
                appliedPartsCount += this.applyVectorArgument(parts[0], parts[1]) ? 1 : 0;
                this.completeVector();
                continue;
            }
            LOG.debug("Unknown vector argument: [{}]", (Object)argument);
        }
        this.completeVector();
        this.bakedScores = null;
        return appliedPartsCount;
    }

    int applyVectorPartsIfMetric(String vector, ApplyMetricsPredicate predicate) {
        if (vector == null) {
            return 0;
        }
        String normalizedVector = CvssVector.normalizeVector(vector);
        if (normalizedVector.isEmpty()) {
            return 0;
        }
        String[] arguments = normalizedVector.split("/");
        int appliedPartsCount = 0;
        for (String argument : arguments) {
            if (StringUtils.isEmpty((CharSequence)argument)) continue;
            String[] parts = argument.split(":", 2);
            if (parts.length == 2) {
                CvssVectorAttribute currentAttribute = this.getVectorArgument(parts[0]);
                boolean isSetAttributeModified = parts[0].startsWith("M");
                CvssVectorAttribute unmodifiedAttribute = isSetAttributeModified ? this.getVectorArgument(parts[0].replaceFirst("M", "")) : currentAttribute;
                CvssVectorAttribute modifiedAttribute = isSetAttributeModified ? currentAttribute : this.getVectorArgument("M" + parts[0]);
                this.applyVectorArgument(parts[0], parts[1]);
                CvssVectorAttribute newAttribute = this.getVectorArgument(parts[0]);
                if (predicate.apply(currentAttribute, unmodifiedAttribute, modifiedAttribute, newAttribute, isSetAttributeModified)) {
                    ++appliedPartsCount;
                    continue;
                }
                this.applyVectorArgument(parts[0], currentAttribute.getShortIdentifier());
                continue;
            }
            LOG.debug("Unknown vector argument: [{}]", (Object)argument);
        }
        this.completeVector();
        this.bakedScores = null;
        return appliedPartsCount;
    }

    public int applyVectorPartsIfMetricsLower(String vector) {
        if (vector == null) {
            return 0;
        }
        return this.applyVectorPartsIfMetric(vector, (currentAttribute, unmodifiedAttribute, modifiedAttribute, newAttribute, isNewAttributeModified) -> {
            Pair<Integer, Integer> severityOrder = this.findOldNewSeverityOrder(unmodifiedAttribute, modifiedAttribute, newAttribute, isNewAttributeModified);
            return (Integer)severityOrder.getRight() <= (Integer)severityOrder.getLeft();
        });
    }

    public int applyVectorPartsIfMetricsHigher(String vector) {
        if (vector == null) {
            return 0;
        }
        return this.applyVectorPartsIfMetric(vector, (currentAttribute, unmodifiedAttribute, modifiedAttribute, newAttribute, isNewAttributeModified) -> {
            Pair<Integer, Integer> severityOrder = this.findOldNewSeverityOrder(unmodifiedAttribute, modifiedAttribute, newAttribute, isNewAttributeModified);
            return (Integer)severityOrder.getRight() >= (Integer)severityOrder.getLeft();
        });
    }

    protected Pair<Integer, Integer> findOldNewSeverityOrder(CvssVectorAttribute unmodifiedAttribute, CvssVectorAttribute modifiedAttribute, CvssVectorAttribute newAttribute, boolean isNewAttributeModified) {
        boolean isModifiedAttributeSet = modifiedAttribute != null && modifiedAttribute.isSet();
        CvssVectorAttribute oldAttribute = isModifiedAttributeSet && isNewAttributeModified ? modifiedAttribute : unmodifiedAttribute;
        int oldSeverity = this.determineAttributeSeverityOrder(oldAttribute);
        int newSeverity = this.determineAttributeSeverityOrder(newAttribute);
        return Pair.of((Object)oldSeverity, (Object)newSeverity);
    }

    protected int determineAttributeSeverityOrder(CvssVectorAttribute attribute) {
        if (attribute == null) {
            return -1;
        }
        if (attribute instanceof Cvss4P0.Cvss4P0Attribute) {
            for (int i = 0; i < Cvss4P0.ATTRIBUTE_SEVERITY_ORDER.size(); ++i) {
                if (!Cvss4P0.ATTRIBUTE_SEVERITY_ORDER.get(i).contains(attribute)) continue;
                return i;
            }
        } else {
            if (attribute instanceof Cvss2.Cvss2Attribute) {
                return Cvss2.ATTRIBUTE_SEVERITY_ORDER.indexOf(attribute);
            }
            if (attribute instanceof Cvss3.Cvss3Attribute) {
                return Cvss3.ATTRIBUTE_SEVERITY_ORDER.indexOf(attribute);
            }
        }
        LOG.warn("Unknown attribute type: {}", (Object)attribute);
        return -1;
    }

    public int applyVector(CvssVector vector) {
        if (vector == null) {
            return 0;
        }
        return this.applyVector(vector.toString());
    }

    public CvssVector applyVectorAndReturn(CvssVector vector) {
        if (vector == null) {
            return this;
        }
        this.applyVector(vector.toString());
        return this;
    }

    public <T extends CvssVector> int applyVectorPartsIfLower(T vector, Function<T, Double> scoreType) {
        if (vector == null) {
            return 0;
        }
        return this.applyVectorPartsIf(vector.toString(), scoreType, true);
    }

    public int applyVectorPartsIfLower(String vector, Function<CvssVector, Double> scoreType) {
        if (vector == null) {
            return 0;
        }
        return this.applyVectorPartsIf(vector, scoreType, true);
    }

    public <T extends CvssVector> int applyVectorPartsIfHigher(T vector, Function<T, Double> scoreType) {
        if (vector == null) {
            return 0;
        }
        return this.applyVectorPartsIf(vector.toString(), scoreType, false);
    }

    public int applyVectorPartsIfHigher(String vector, Function<CvssVector, Double> scoreType) {
        if (vector == null) {
            return 0;
        }
        return this.applyVectorPartsIf(vector, scoreType, false);
    }

    protected static String normalizeVector(String vector) {
        String result = vector.toUpperCase();
        result = PARENTHESIS_PATTERN.matcher(result).replaceAll("");
        if (!(result = CVSS_PATTERN.matcher(result).replaceAll("")).isEmpty() && result.charAt(0) == '/') {
            result = result.substring(1);
        }
        return result.trim();
    }

    public static <T extends CvssVector> T parseVectorOnlyIfKnownAttributes(String vector, Supplier<T> constructor) {
        CvssVector cvssVector = (CvssVector)constructor.get();
        String normalizedVector = CvssVector.normalizeVector(vector);
        int knownAttributes = cvssVector.applyNormalizedVector(normalizedVector);
        int allAttributes = normalizedVector.split("/").length;
        return (T)(allAttributes - knownAttributes > 0 ? null : cvssVector);
    }

    public static <T extends CvssVector> String getVersionName(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown or unregistered CVSS version: null");
        }
        if (Cvss2.class.isAssignableFrom(clazz)) {
            return Cvss2.getVersionName();
        }
        if (Cvss3P0.class.isAssignableFrom(clazz)) {
            return Cvss3P0.getVersionName();
        }
        if (Cvss3P1.class.isAssignableFrom(clazz)) {
            return Cvss3P1.getVersionName();
        }
        if (Cvss4P0.class.isAssignableFrom(clazz)) {
            return Cvss4P0.getVersionName();
        }
        throw new IllegalArgumentException("Unknown or unregistered CVSS version: " + clazz.getSimpleName());
    }

    public static Class<? extends CvssVector> classFromVersionName(String versionName) {
        if (versionName == null) {
            throw new IllegalArgumentException("Unknown or unregistered CVSS version: null");
        }
        if (versionName.equals(Cvss2.getVersionName())) {
            return Cvss2.class;
        }
        if (versionName.equals(Cvss3P0.getVersionName())) {
            return Cvss3P0.class;
        }
        if (versionName.equals(Cvss3P1.getVersionName())) {
            return Cvss3P1.class;
        }
        if (versionName.equals(Cvss4P0.getVersionName())) {
            return Cvss4P0.class;
        }
        throw new IllegalArgumentException("Unknown or unregistered CVSS version: " + versionName);
    }

    public static CvssVector parseVector(String vector) {
        return CvssVector.parseVector(vector, false);
    }

    public static CvssVector parseVector(String vector, boolean strict) {
        Supplier<CvssVector> constructor;
        if (vector == null || StringUtils.isEmpty((CharSequence)vector)) {
            return null;
        }
        if (vector.startsWith("CVSS:2.0")) {
            constructor = Cvss2::new;
        } else if (vector.startsWith("CVSS:3.1")) {
            constructor = Cvss3P1::new;
        } else if (vector.startsWith("CVSS:3.0")) {
            constructor = Cvss3P0::new;
        } else if (vector.startsWith("CVSS:4.0")) {
            constructor = Cvss4P0::new;
        } else {
            Cvss2 potentialCvss2Vector = CvssVector.parseVectorOnlyIfKnownAttributes(vector, Cvss2::new);
            if (potentialCvss2Vector != null) {
                return potentialCvss2Vector;
            }
            Cvss3P1 potentialCvss3Vector = CvssVector.parseVectorOnlyIfKnownAttributes(vector, Cvss3P1::new);
            if (potentialCvss3Vector != null) {
                return potentialCvss3Vector;
            }
            Cvss4P0 potentialCvss4P0Vector = CvssVector.parseVectorOnlyIfKnownAttributes(vector, Cvss4P0::new);
            if (potentialCvss4P0Vector != null) {
                return potentialCvss4P0Vector;
            }
            if (vector.startsWith("CVSS:")) {
                LOG.warn("Cannot fully determine CVSS version in vector [{}]", (Object)vector);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to parse non-CVSS vector string [{}]", (Object)vector);
            }
            return null;
        }
        if (strict) {
            return CvssVector.parseVectorOnlyIfKnownAttributes(vector, constructor);
        }
        CvssVector inst = constructor.get();
        inst.applyVector(vector);
        return inst;
    }

    public abstract String toString(boolean var1);

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("sources", (Object)new JSONArray((Object)this.sources.stream().map(CvssSource::toColumnHeaderString).toArray()));
        json.put("vector", (Object)this.toString());
        if (this.applicabilityCondition != null) {
            json.put("condition", (Object)this.applicabilityCondition);
        }
        return json;
    }

    public static CvssVector fromJson(JSONObject json) {
        List<Object> sources;
        if (json.has("source")) {
            CvssSource source = CvssSource.fromColumnHeaderString(json.getString("source"));
            sources = Collections.singletonList(source);
        } else if (json.has("sources")) {
            JSONArray sourcesJson = json.getJSONArray("sources");
            sources = new ArrayList();
            for (int i = 0; i < sourcesJson.length(); ++i) {
                sources.add(CvssSource.fromColumnHeaderString(sourcesJson.getString(i)));
            }
            if (sources.isEmpty()) {
                throw new IllegalArgumentException("No sources found in json [" + json + "]");
            }
        } else {
            sources = Collections.emptyList();
        }
        CvssVector vector = !sources.isEmpty() ? ((CvssSource)sources.get(0)).parseVector(json.getString("vector")) : CvssVector.parseVector(json.getString("vector"));
        if (json.has("condition")) {
            JSONObject condition = json.getJSONObject("condition");
            for (String key : condition.keySet()) {
                vector.getApplicabilityCondition().put(key, condition.get(key));
            }
            vector.addSources(sources);
        } else {
            vector.addSources(sources);
        }
        return vector;
    }

    public static JSONArray toJson(List<CvssVector> vectorsList) {
        JSONArray json = new JSONArray();
        vectorsList.forEach(sourcedCvssVector -> json.put((Object)sourcedCvssVector.toJson()));
        return json;
    }

    public static List<CvssVector> fromJson(JSONArray json) {
        ArrayList<CvssVector> vectorsList = new ArrayList<CvssVector>();
        for (int i = 0; i < json.length(); ++i) {
            vectorsList.add(CvssVector.fromJson(json.getJSONObject(i)));
        }
        return vectorsList;
    }

    protected <T extends CvssVector> T cloneInternal(T clone) {
        clone.sources.addAll(this.sources);
        for (String key : this.applicabilityCondition.keySet()) {
            clone.applicabilityCondition.put(key, this.applicabilityCondition.get(key));
        }
        return clone;
    }

    public static interface CvssVectorAttribute {
        public String getIdentifier();

        public String getShortIdentifier();

        public boolean isSet();
    }

    public static interface ApplyMetricsPredicate {
        public boolean apply(CvssVectorAttribute var1, CvssVectorAttribute var2, CvssVectorAttribute var3, CvssVectorAttribute var4, boolean var5);
    }
}

