/*
 * Decompiled with CFR 0.152.
 */
package org.metaeffekt.core.security.cvss;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;

public class CvssSource {
    private final CvssEntity hostingEntity;
    private final CvssEntity issuingEntity;
    private final CvssIssuingEntityRole issuingEntityRole;
    private final Class<CvssVector> vectorClass;

    public CvssSource(CvssEntity hostingEntity, CvssIssuingEntityRole issuingEntityRole, CvssEntity issuingEntity, Class<? extends CvssVector> vectorClass) {
        this.hostingEntity = hostingEntity;
        this.issuingEntityRole = issuingEntityRole;
        this.issuingEntity = issuingEntity;
        this.vectorClass = vectorClass;
    }

    public CvssSource(CvssEntity hostingEntity, CvssEntity issuingEntity, Class<? extends CvssVector> vectorClass) {
        this(hostingEntity, null, issuingEntity, vectorClass);
    }

    public CvssSource(CvssEntity hostingEntity, Class<? extends CvssVector> vectorClass) {
        this(hostingEntity, null, null, vectorClass);
    }

    public CvssSource(CvssEntity hostingEntity, CvssIssuingEntityRole issuingEntityRole, CvssEntity issuingEntity, CvssVector vectorInstance) {
        this.hostingEntity = hostingEntity;
        this.issuingEntityRole = issuingEntityRole;
        this.issuingEntity = issuingEntity;
        this.vectorClass = vectorInstance.getClass();
    }

    public CvssSource(CvssEntity hostingEntity, CvssEntity issuingEntity, CvssVector vectorInstance) {
        this(hostingEntity, null, issuingEntity, vectorInstance);
    }

    public CvssSource(CvssEntity hostingEntity, CvssVector vectorInstance) {
        this(hostingEntity, null, null, vectorInstance);
    }

    public CvssEntity getHostingEntity() {
        return this.hostingEntity;
    }

    public CvssIssuingEntityRole getIssuingEntityRole() {
        return this.issuingEntityRole;
    }

    public CvssEntity getIssuingEntity() {
        return this.issuingEntity;
    }

    public Class<CvssVector> getVectorClass() {
        return this.vectorClass;
    }

    public CvssVector parseVector(String vector) {
        if (this.vectorClass == null) {
            throw new IllegalStateException("No vector class specified for CVSS source: " + this);
        }
        try {
            return this.vectorClass.getConstructor(String.class).newInstance(vector);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to parse vector [" + vector + "] for CVSS source: " + this, e);
        }
    }

    public CvssSource deriveSource(Class<? extends CvssVector> vectorClass) {
        return new CvssSource(this.hostingEntity, this.issuingEntityRole, this.issuingEntity, vectorClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssSource that = (CvssSource)o;
        return Objects.equals(this.hostingEntity, that.hostingEntity) && Objects.equals(this.issuingEntity, that.issuingEntity) && Objects.equals(this.issuingEntityRole, that.issuingEntityRole) && Objects.equals(this.vectorClass, that.vectorClass);
    }

    public int hashCode() {
        return Objects.hash(this.hostingEntity, this.issuingEntity, this.issuingEntityRole, this.vectorClass);
    }

    public String toColumnHeaderString() {
        return this.toColumnHeaderString(true, true);
    }

    public String toColumnHeaderString(boolean includeVersion, boolean escapeNames) {
        StringBuilder builder = new StringBuilder();
        if (includeVersion) {
            try {
                String vectorVersion = CvssVector.getVersionName(this.vectorClass);
                builder.append(vectorVersion).append(" ");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unsupported CVSS version [" + this.vectorClass + "] in CVSS source: " + this);
            }
        }
        if (this.hostingEntity == null) {
            throw new IllegalStateException("No hosting entity specified for CVSS source: " + this);
        }
        builder.append(this.hostingEntity.optionalEscapedName(escapeNames));
        if (this.issuingEntityRole != null) {
            builder.append("-").append(this.issuingEntityRole.optionalEscapedName(escapeNames));
        }
        if (this.issuingEntity != null) {
            builder.append("-").append(this.issuingEntity.optionalEscapedName(escapeNames));
        }
        return builder.toString();
    }

    public static String toCombinedColumnHeaderString(Collection<CvssSource> sources) {
        return CvssSource.toCombinedColumnHeaderString(sources, true);
    }

    public static String toCombinedColumnHeaderString(Collection<CvssSource> sources, boolean includeVersion) {
        return CvssSource.toCombinedColumnHeaderString(sources, includeVersion, true);
    }

    public static String toCombinedColumnHeaderString(Collection<CvssSource> sources, boolean includeVersion, boolean escapeNames) {
        String vectorVersion;
        if (sources.isEmpty()) {
            return "";
        }
        if (includeVersion) {
            CvssSource firstSource = sources.iterator().next();
            try {
                vectorVersion = CvssVector.getVersionName(firstSource.getVectorClass()) + " ";
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unsupported CVSS version [" + firstSource.getVectorClass() + "] in CVSS source: " + firstSource);
            }
        } else {
            vectorVersion = "";
        }
        StringJoiner joiner = new StringJoiner(" + ", vectorVersion, "");
        for (CvssSource source : sources) {
            joiner.add(source.getHostingEntity().optionalEscapedName(escapeNames) + (source.getIssuingEntityRole() != null ? "-" + source.getIssuingEntityRole().optionalEscapedName(escapeNames) : "") + (source.getIssuingEntity() != null ? "-" + source.getIssuingEntity().optionalEscapedName(escapeNames) : ""));
        }
        return joiner.toString();
    }

    public String toString() {
        String vectorVersion;
        try {
            vectorVersion = CvssVector.getVersionName(this.vectorClass);
        }
        catch (Exception e) {
            vectorVersion = "CVSS:unknown";
        }
        return vectorVersion + " " + (this.hostingEntity != null ? this.hostingEntity.getName() : "unknown") + (this.issuingEntityRole != null ? "-" + this.issuingEntityRole.getName() : "") + (this.issuingEntity != null ? "-" + this.issuingEntity.getName() : "");
    }

    public static CvssSource fromColumnHeaderString(String header) {
        CvssEntity issuingEntity;
        CvssIssuingEntityRole issuingEntityRole;
        CvssEntity hostingEntity;
        Class<? extends CvssVector> cvssVectorClass;
        String[] versionRest = header.split(" ", 2);
        if (versionRest.length != 2) {
            throw new IllegalArgumentException("Invalid CVSS source, requires version and rest: " + header);
        }
        String version = versionRest[0];
        String rest = versionRest[1];
        try {
            cvssVectorClass = CvssVector.classFromVersionName(version);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported CVSS version [" + version + "] in CVSS source: " + header);
        }
        String[] parts = rest.split("-");
        if (parts.length > 0) {
            hostingEntity = KnownCvssEntities.findByNameOrMailOrCreateNew(EntityNameProvider.unescapeEntityName(parts[0]));
            if (parts.length == 2) {
                issuingEntityRole = null;
                issuingEntity = KnownCvssEntities.findByNameOrMailOrCreateNew(EntityNameProvider.unescapeEntityName(parts[1]));
            } else if (parts.length == 3) {
                issuingEntityRole = CvssIssuingEntityRole.findOrCreateNew(EntityNameProvider.unescapeEntityName(parts[1]));
                issuingEntity = KnownCvssEntities.findByNameOrMailOrCreateNew(EntityNameProvider.unescapeEntityName(parts[2]));
            } else {
                if (parts.length > 3) {
                    throw new IllegalArgumentException("Invalid CVSS source, requires at most hosting entity, issuing entity role and issuing entity: " + header);
                }
                issuingEntityRole = null;
                issuingEntity = null;
            }
        } else {
            throw new IllegalArgumentException("Invalid CVSS source, requires at least hosting entity: " + header);
        }
        return new CvssSource(hostingEntity, issuingEntityRole, issuingEntity, cvssVectorClass);
    }

    public static Map<String, CvssSource> fromMultipleColumnHeaderStrings(Set<String> headers) {
        LinkedHashMap<String, CvssSource> result = new LinkedHashMap<String, CvssSource>();
        for (String header : headers) {
            if (!header.startsWith("CVSS") || header.equalsIgnoreCase("CVSS Initial Overall") || header.equalsIgnoreCase("CVSS Context Overall") || header.equalsIgnoreCase("CVSS Initial Base") || header.equalsIgnoreCase("CVSS Initial Exploitability") || header.equalsIgnoreCase("CVSS Initial Impact")) continue;
            try {
                result.put(header, CvssSource.fromColumnHeaderString(header));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static Map<String, CvssSource> fromMultipleColumnHeaderStringsThrowing(Set<String> headers) {
        LinkedHashMap<String, CvssSource> result = new LinkedHashMap<String, CvssSource>();
        for (String header : headers) {
            if (!header.startsWith("CVSS") || header.equalsIgnoreCase("CVSS Initial Overall") || header.equalsIgnoreCase("CVSS Context Overall") || header.equalsIgnoreCase("CVSS Initial Base") || header.equalsIgnoreCase("CVSS Initial Exploitability") || header.equalsIgnoreCase("CVSS Initial Impact")) continue;
            result.put(header, CvssSource.fromColumnHeaderString(header));
        }
        return result;
    }

    public static interface EntityNameProvider {
        public String getName();

        default public String getEscapedName() {
            return this.getName().replace("_", "\\_").replace("-", "_");
        }

        public static String unescapeEntityName(String name) {
            StringBuilder result = new StringBuilder();
            boolean escapeNextChar = false;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '\\') {
                    escapeNextChar = !escapeNextChar;
                    continue;
                }
                if (!escapeNextChar) {
                    if (c == '_') {
                        result.append('-');
                        continue;
                    }
                    result.append(c);
                    continue;
                }
                result.append(c);
                escapeNextChar = false;
            }
            return result.toString();
        }

        default public String optionalEscapedName(boolean escape) {
            return escape ? this.getEscapedName() : this.getName();
        }
    }

    public static class CvssIssuingEntityRole
    implements EntityNameProvider {
        private final String name;
        public static final CvssIssuingEntityRole CNA = new CvssIssuingEntityRole("CNA");
        public static final List<CvssIssuingEntityRole> ALL = Arrays.asList(CNA);

        public CvssIssuingEntityRole(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public static CvssIssuingEntityRole findOrCreateNew(String name) {
            for (CvssIssuingEntityRole role : ALL) {
                if (!role.getName().equalsIgnoreCase(name)) continue;
                return role;
            }
            return new CvssIssuingEntityRole(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CvssIssuingEntityRole that = (CvssIssuingEntityRole)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static class ReportStep {
        private final int stepIndex;
        private final String title;
        private final String link;

        public ReportStep(int stepIndex, String title, String link) {
            this.stepIndex = stepIndex;
            this.title = title;
            this.link = link;
        }

        public int getStepIndex() {
            return this.stepIndex;
        }

        public String getTitle() {
            return this.title;
        }

        public String getLink() {
            return this.link;
        }

        public static ReportStep fromJson(JSONObject json) {
            return new ReportStep(json.getInt("stepIndex"), json.getString("title"), json.getString("link"));
        }

        public static List<ReportStep> fromJson(JSONArray json) {
            if (json == null) {
                return Collections.emptyList();
            }
            ArrayList<ReportStep> result = new ArrayList<ReportStep>();
            for (int i = 0; i < json.length(); ++i) {
                result.add(ReportStep.fromJson(json.getJSONObject(i)));
            }
            return result;
        }

        public String toString() {
            return "StepInfo{stepIndex=" + this.stepIndex + ", title='" + this.title + '\'' + ", link='" + this.link + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReportStep that = (ReportStep)o;
            return this.stepIndex == that.stepIndex && Objects.equals(this.title, that.title) && Objects.equals(this.link, that.link);
        }

        public int hashCode() {
            return Objects.hash(this.stepIndex, this.title, this.link);
        }
    }

    public static class CvssEntity
    implements EntityNameProvider {
        private final String name;
        private final String email;
        private final URL url;
        private final URL cveOrgDetailsLink;
        private final String description;
        private final String country;
        private final String role;
        private final List<String> organizationTypes;
        private final CvssEntity topLevelRootPartner;
        private final CvssEntity rootPartner;
        private final List<ReportStep> reportSteps;

        public CvssEntity(String name, String email, URL url, URL cveOrgDetailsLink, String description, String country, String role, List<String> organizationTypes, CvssEntity topLevelRootPartner, CvssEntity rootPartner, List<ReportStep> reportSteps) {
            this.name = name;
            this.email = email;
            this.url = url;
            this.cveOrgDetailsLink = cveOrgDetailsLink;
            this.description = description;
            this.country = country;
            this.role = role;
            this.organizationTypes = organizationTypes;
            this.topLevelRootPartner = topLevelRootPartner;
            this.rootPartner = rootPartner;
            this.reportSteps = reportSteps;
        }

        public CvssEntity(String name) {
            this(name, null, null, null, null, null, null, Collections.emptyList(), null, null, Collections.emptyList());
        }

        public String getEmail() {
            return this.email;
        }

        public URL getUrl() {
            return this.url;
        }

        public URL getCveOrgDetailsLink() {
            return this.cveOrgDetailsLink;
        }

        public String getDescription() {
            return this.description;
        }

        public String getCountry() {
            return this.country;
        }

        public String getRole() {
            return this.role;
        }

        public List<String> getOrganizationTypes() {
            return this.organizationTypes;
        }

        public CvssEntity getTopLevelRootPartner() {
            return this.topLevelRootPartner;
        }

        public CvssEntity getRootPartner() {
            return this.rootPartner;
        }

        public List<ReportStep> getReportSteps() {
            return this.reportSteps;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return "CvssEntity{" + this.name + (this.email != null ? ", " + this.email : "") + (this.url != null ? " (" + this.url + ")" : "") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CvssEntity that = (CvssEntity)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.email, that.email) && Objects.equals(this.url, that.url) && Objects.equals(this.cveOrgDetailsLink, that.cveOrgDetailsLink) && Objects.equals(this.description, that.description) && Objects.equals(this.country, that.country) && Objects.equals(this.role, that.role) && Objects.equals(this.organizationTypes, that.organizationTypes) && Objects.equals(this.topLevelRootPartner, that.topLevelRootPartner) && Objects.equals(this.rootPartner, that.rootPartner) && Objects.equals(this.reportSteps, that.reportSteps);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.email, this.url, this.cveOrgDetailsLink, this.description, this.country, this.role, this.organizationTypes, this.topLevelRootPartner, this.rootPartner, this.reportSteps);
        }

        public CvssSource deriveSource(Class<? extends CvssVector> vectorClass) {
            return new CvssSource(this, vectorClass);
        }
    }
}

