/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tools.jetty.listener;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.tools.jetty.listener.Messages;

public class NotifyListener
implements LifeCycle.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyListener.class);
    private static final String JETTY_PORT = System.getProperty("jetty.http.port", "8080");
    private static final String DELIMITER = "----------------------------------";

    public void lifeCycleStarting(LifeCycle event) {
        String jvmString = String.format("%s (%s)", System.getProperty("java.runtime.version"), System.getProperty("java.runtime.name"));
        LOGGER.info(Messages.getString("jetty.starting.notification"), (Object)JETTY_PORT, (Object)jvmString);
    }

    public void lifeCycleStarted(LifeCycle event) {
        LOGGER.info(DELIMITER);
        try {
            String serverUrl = String.format("http://%s:%s/", InetAddress.getLocalHost().getCanonicalHostName(), JETTY_PORT);
            LOGGER.info(Messages.getString("jetty.startup.notification"), (Object)serverUrl);
        }
        catch (UnknownHostException ex) {
            LOGGER.error("Failed to find hostname for localhost", (Throwable)ex);
        }
        LOGGER.info(DELIMITER);
    }

    public void lifeCycleStopping(LifeCycle event) {
        LOGGER.info(DELIMITER);
        LOGGER.info(Messages.getString("jetty.stopping.notification"));
    }

    public void lifeCycleStopped(LifeCycle event) {
        LOGGER.info(Messages.getString("jetty.stopped.notification"));
    }
}

