/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.linkchecker;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.transformation.linkchecker.HTTPChecker;

@Component
@Singleton
public class DefaultHTTPChecker
implements HTTPChecker,
Initializable {
    @Inject
    private Logger logger;
    private CloseableHttpClient httpClient;

    public void initialize() throws InitializationException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        httpClientBuilder.useSystemProperties();
        httpClientBuilder.setUserAgent("XWikiLinkChecker");
        RequestConfig config = RequestConfig.custom().setCookieSpec("ignoreCookies").build();
        httpClientBuilder.setDefaultRequestConfig(config);
        this.httpClient = httpClientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int check(String url) {
        int responseCode;
        CloseableHttpResponse httpResponse = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
            responseCode = httpResponse.getStatusLine().getStatusCode();
            this.logger.debug("Result of pinging [{}]: code = [{}]", (Object)url, (Object)responseCode);
        }
        catch (Exception e) {
            responseCode = 0;
            this.logger.debug("Error while checking [{}]", (Object)url, (Object)e);
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (Exception ee) {
                    this.logger.error("Failed to close HTTP connection for [{}]", (Object)url, (Object)ee);
                }
            }
        }
        return responseCode;
    }
}

