/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal.xwikiblog;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.whatsnew.NewsException;
import org.xwiki.whatsnew.NewsSource;
import org.xwiki.whatsnew.NewsSourceFactory;
import org.xwiki.whatsnew.internal.xwikiblog.RSSContentCleaner;
import org.xwiki.whatsnew.internal.xwikiblog.XWikiBlogNewsSource;

@Component
@Named(value="xwikiblog")
@Singleton
public class XWikiBlogNewsSourceFactory
implements NewsSourceFactory {
    @Inject
    private RSSContentCleaner rssContentCleaner;

    @Override
    public NewsSource create(Map<String, String> parameters) throws NewsException {
        String rssURL = parameters.get("rssURL");
        if (rssURL == null) {
            throw new NewsException("Failed to create a XWiki Blog news source. A 'rssURL' parameter must be passed");
        }
        return new XWikiBlogNewsSource(rssURL, this.rssContentCleaner);
    }
}

