/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal.xwikiblog;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xwiki.whatsnew.NewsCategory;

public class XWikiBlogNewsCategoryConverter {
    private static final String CATEGORY_SIMPLE_USER = "Blog.What's New for XWiki: Simple User";
    private static final String CATEGORY_ADMIN_USER = "Blog.What's New for XWiki: Admin User";
    private static final String CATEGORY_ADVANCED_USER = "Blog.What's New for XWiki: Advanced User";
    private static final String CATEGORY_EXTENSION = "Blog.What's New for XWiki: Extension";

    public Set<NewsCategory> convertFromRSS(List<String> rssCategories) {
        HashSet<NewsCategory> mappedCategories = new HashSet<NewsCategory>();
        for (String category : rssCategories) {
            if (CATEGORY_ADMIN_USER.equals(category)) {
                mappedCategories.add(NewsCategory.ADMIN_USER);
                continue;
            }
            if (CATEGORY_SIMPLE_USER.equals(category)) {
                mappedCategories.add(NewsCategory.SIMPLE_USER);
                continue;
            }
            if (CATEGORY_ADVANCED_USER.equals(category)) {
                mappedCategories.add(NewsCategory.ADVANCED_USER);
                continue;
            }
            if (CATEGORY_EXTENSION.equals(category)) {
                mappedCategories.add(NewsCategory.EXTENSION);
                continue;
            }
            mappedCategories.add(NewsCategory.UNKNOWN);
        }
        return mappedCategories;
    }

    public String convertToQueryString(Set<NewsCategory> categories) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = this.getMappedCategoriesForURL(categories).iterator();
        while (iterator.hasNext()) {
            builder.append("category").append('=').append(this.encodeString(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    private String encodeString(String text) {
        return URLEncoder.encode(text, StandardCharsets.UTF_8);
    }

    private List<String> getMappedCategoriesForURL(Set<NewsCategory> categories) {
        return List.of("Blog.What's New for XWiki");
    }
}

