/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal.xwikiblog;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.HTMLUtils;

@Component(roles={RSSContentCleaner.class})
@Singleton
public class RSSContentCleaner {
    @Inject
    private HTMLCleaner htmlCleaner;

    public String clean(String source) {
        HTMLCleanerConfiguration cleanerConfiguration = this.htmlCleaner.getDefaultConfiguration();
        HashMap<String, String> parameters = new HashMap<String, String>(cleanerConfiguration.getParameters());
        parameters.put("htmlVersion", "5");
        parameters.put("restricted", "true");
        cleanerConfiguration.setParameters(parameters);
        Document document = this.htmlCleaner.clean((Reader)new StringReader(source), cleanerConfiguration);
        HTMLUtils.stripHTMLEnvelope((Document)document);
        String cleanedContent = HTMLUtils.toString((Document)document, (boolean)true, (boolean)true);
        return cleanedContent.substring(7, cleanedContent.length() - 8);
    }
}

