/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal.configured;

import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.whatsnew.NewsConfiguration;
import org.xwiki.whatsnew.NewsException;
import org.xwiki.whatsnew.NewsSource;
import org.xwiki.whatsnew.NewsSourceDescriptor;
import org.xwiki.whatsnew.NewsSourceFactory;
import org.xwiki.whatsnew.internal.configured.CompositeNewsSource;

@Component
@Singleton
public class ConfiguredNewsSourceFactory
implements NewsSourceFactory {
    @Inject
    private NewsConfiguration configuration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    private NewsSource source;

    @Override
    public NewsSource create(Map<String, String> parameters) throws NewsException {
        NewsSource result;
        if (this.source != null) {
            result = this.source;
        } else {
            this.source = result = this.create();
        }
        return result;
    }

    private NewsSource create() throws NewsException {
        ArrayList<NewsSource> sources = new ArrayList<NewsSource>();
        for (NewsSourceDescriptor descriptor : this.configuration.getNewsSourceDescriptors()) {
            NewsSourceFactory factory = this.getFactory(descriptor.getSourceTypeHint());
            if (factory == null) continue;
            sources.add(factory.create(descriptor.getParameters()));
        }
        return new CompositeNewsSource(sources);
    }

    private NewsSourceFactory getFactory(String hint) throws NewsException {
        try {
            return (NewsSourceFactory)this.componentManager.getInstance(NewsSourceFactory.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new NewsException(String.format("Failed to locate News Source Factory for [%s].", hint), e);
        }
    }
}

