/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal.configured;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.extension.version.Version;
import org.xwiki.user.UserReference;
import org.xwiki.whatsnew.NewsCategory;
import org.xwiki.whatsnew.NewsException;
import org.xwiki.whatsnew.NewsSource;
import org.xwiki.whatsnew.NewsSourceItem;

public class CompositeNewsSource
implements NewsSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeNewsSource.class);
    private List<NewsSource> wrappedSources;

    public CompositeNewsSource(List<NewsSource> wrappedSources) {
        this.wrappedSources = Collections.unmodifiableList(wrappedSources);
    }

    @Override
    public NewsSource forUser(UserReference userReference) {
        for (NewsSource source : this.getWrappedSources()) {
            source.forUser(userReference);
        }
        return this;
    }

    @Override
    public NewsSource forCategories(Set<NewsCategory> wantedCategories) {
        for (NewsSource source : this.getWrappedSources()) {
            source.forCategories(wantedCategories);
        }
        return this;
    }

    @Override
    public NewsSource forXWikiVersion(Version targetXWikiVersion) {
        for (NewsSource source : this.getWrappedSources()) {
            source.forXWikiVersion(targetXWikiVersion);
        }
        return this;
    }

    @Override
    public NewsSource forExtraParameters(Map<String, Object> extraParameters) {
        for (NewsSource source : this.getWrappedSources()) {
            source.forExtraParameters(extraParameters);
        }
        return this;
    }

    @Override
    public NewsSource withCount(int count) {
        for (NewsSource source : this.getWrappedSources()) {
            source.withCount(count);
        }
        return this;
    }

    @Override
    public List<NewsSourceItem> build() {
        ArrayList<NewsSourceItem> items = new ArrayList<NewsSourceItem>();
        for (NewsSource source : this.getWrappedSources()) {
            try {
                items.addAll(source.build());
            }
            catch (NewsException e) {
                LOGGER.warn("Failed to get news items for source [{}]. Root cause: [{}]", (Object)source, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        Collections.sort(items);
        return items;
    }

    private List<NewsSource> getWrappedSources() {
        return this.wrappedSources;
    }
}

