/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.xwiki.whatsnew.NewsCategory;
import org.xwiki.whatsnew.NewsContent;
import org.xwiki.whatsnew.NewsSourceItem;

public class DefaultNewsSourceItem
implements NewsSourceItem {
    private Optional<String> title;
    private Optional<NewsContent> description;
    private Set<NewsCategory> categories = new HashSet<NewsCategory>();
    private Optional<Date> publishedDate;
    private Optional<String> author;
    private Optional<String> originURL;
    private Optional<String> imageURL;

    @Override
    public Optional<String> getTitle() {
        return this.title;
    }

    public void setTitle(Optional<String> title) {
        this.title = title;
    }

    @Override
    public Optional<NewsContent> getDescription() {
        return this.description;
    }

    public void setDescription(Optional<NewsContent> description) {
        this.description = description;
    }

    @Override
    public Set<NewsCategory> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<NewsCategory> categories) {
        this.categories = Collections.unmodifiableSet(categories);
    }

    @Override
    public Optional<Date> getPublishedDate() {
        return this.publishedDate;
    }

    public void setPublishedDate(Optional<Date> publishedDate) {
        this.publishedDate = publishedDate;
    }

    @Override
    public Optional<String> getAuthor() {
        return this.author;
    }

    public void setAuthor(Optional<String> author) {
        this.author = author;
    }

    @Override
    public Optional<String> getOriginURL() {
        return this.originURL;
    }

    public void setOriginURL(Optional<String> originURL) {
        this.originURL = originURL;
    }

    @Override
    public Optional<String> getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(Optional<String> imageURL) {
        this.imageURL = imageURL;
    }

    @Override
    public int compareTo(NewsSourceItem other) {
        return other.getPublishedDate().orElse(new Date()).compareTo(this.getPublishedDate().orElse(new Date()));
    }
}

