/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.whatsnew.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.whatsnew.NewsConfiguration;
import org.xwiki.whatsnew.NewsSourceDescriptor;

@Component
@Singleton
public class DefaultNewsConfiguration
implements NewsConfiguration {
    private static final String PREFIX = "whatsnew";
    private static final String XWIKIBLOG_HINT = "xwikiblog";
    private static final String XWIKIBLOG_RSSURL_KEY = "rssURL";
    private static final String XWIKIORG_RSS_URL = "https://extensions.xwiki.org/news";
    private static final String XWIKISAS_RSS_URL = "https://xwiki.com/news";
    private static final String SOURCES_CONFIG_NAME = "sources";
    private static final String SOURCE_CONFIG_NAME = "source";
    private static final long DAY = 86400L;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;

    @Override
    public List<NewsSourceDescriptor> getNewsSourceDescriptors() {
        Properties sources = this.getConfiguredSources();
        List<NewsSourceDescriptor> descriptors = sources != null ? this.getConfiguredNewsSourceDescriptors(sources) : this.getDefaultNewsSourceDescriptors();
        return descriptors;
    }

    @Override
    public long getNewsRefreshRate() {
        return (Long)this.configurationSource.getProperty(this.getFullKeyName("refreshRate"), (Object)86400L);
    }

    @Override
    public int getNewsDisplayCount() {
        return (Integer)this.configurationSource.getProperty(this.getFullKeyName("displayCount"), (Object)10);
    }

    @Override
    public boolean isActive() {
        Properties sources = this.getConfiguredSources();
        return sources == null || !sources.isEmpty();
    }

    private Properties getConfiguredSources() {
        Properties result = this.configurationSource.containsKey(this.getFullKeyName(SOURCES_CONFIG_NAME)) ? (Properties)this.configurationSource.getProperty(this.getFullKeyName(SOURCES_CONFIG_NAME), Properties.class) : null;
        return result;
    }

    private List<NewsSourceDescriptor> getConfiguredNewsSourceDescriptors(Properties sources) {
        ArrayList<NewsSourceDescriptor> descriptors = new ArrayList<NewsSourceDescriptor>();
        ArrayList<String> keys = new ArrayList<String>();
        String sourceKeyNamePrefix = String.format("%s.", this.getFullKeyName(SOURCE_CONFIG_NAME));
        for (String string : this.configurationSource.getKeys()) {
            if (!string.startsWith(sourceKeyNamePrefix)) continue;
            keys.add(string);
        }
        for (Map.Entry entry : sources.entrySet()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            String prefix = String.format("%s%s.", sourceKeyNamePrefix, entry.getKey());
            for (String key : keys) {
                if (!key.startsWith(prefix)) continue;
                String parameterKey = StringUtils.substringAfter((String)key, (String)prefix);
                parameters.put(parameterKey, (String)this.configurationSource.getProperty(key, String.class));
            }
            NewsSourceDescriptor descriptor = new NewsSourceDescriptor((String)entry.getKey(), (String)entry.getValue(), parameters);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private List<NewsSourceDescriptor> getDefaultNewsSourceDescriptors() {
        NewsSourceDescriptor xwikiOrgBlogDescriptor = new NewsSourceDescriptor("xwikiorg", XWIKIBLOG_HINT, Collections.singletonMap(XWIKIBLOG_RSSURL_KEY, XWIKIORG_RSS_URL));
        NewsSourceDescriptor xwikiSASBlogDescriptor = new NewsSourceDescriptor("xwikisas", XWIKIBLOG_HINT, Collections.singletonMap(XWIKIBLOG_RSSURL_KEY, XWIKISAS_RSS_URL));
        return List.of(xwikiOrgBlogDescriptor, xwikiSASBlogDescriptor);
    }

    private String getFullKeyName(String shortKeyName) {
        return String.format("%s.%s", PREFIX, shortKeyName);
    }
}

