/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.ui;

import com.xpn.xwiki.XWikiContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Priority;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightChangeSuggestion;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightsChangeSuggestionManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRightsManager;
import org.xwiki.skinx.SkinExtension;
import org.xwiki.template.TemplateManager;
import org.xwiki.uiextension.UIExtension;

@Component
@Named(value="org.xwiki.platform.security.requiredrights.ui.MissingRequiredRightWarningUIExtension")
@Priority(value=900)
@Singleton
public class MissingRequiredRightWarningUIExtension
implements UIExtension {
    public static final String ROLE_HINT = "org.xwiki.platform.security.requiredrights.ui.MissingRequiredRightWarningUIExtension";
    @Inject
    private TemplateManager templateManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private RequiredRightsChangeSuggestionManager suggestionManager;
    @Inject
    @Named(value="withTranslations")
    private RequiredRightAnalyzer<DocumentReference> requiredRightAnalyzer;
    @Inject
    private DocumentRequiredRightsManager documentRequiredRightsManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="jsrx")
    private SkinExtension jsrx;
    @Inject
    @Named(value="ssrx")
    private SkinExtension ssrx;

    public Block execute() {
        XWikiContext xWikiContext = (XWikiContext)this.contextProvider.get();
        DocumentReference documentReference = xWikiContext.getDoc().getDocumentReference();
        DocumentReference userReference = xWikiContext.getUserReference();
        if ("view".equals(xWikiContext.getAction()) && this.authorizationManager.hasAccess(Right.EDIT, userReference, (EntityReference)documentReference)) {
            GroupBlock container = new GroupBlock(Map.of("id", "missing-required-rights-warning"));
            this.jsrx.use("js/security/requiredrights/requiredRightsInformationUpdater.js");
            Optional<RequiredRightChangeSuggestion> changeSuggestion = this.getDefinitelyMissingRequiredRight(xWikiContext);
            if (changeSuggestion.isPresent() && this.authorizationManager.hasAccess(changeSuggestion.get().rightToAdd().right(), userReference, documentReference.extractReference(changeSuggestion.get().rightToAdd().scope()))) {
                this.jsrx.use("js/security/requiredrights/requiredRightsDialog.js");
                this.ssrx.use("css/security/requiredrights/requiredRightsDialog.css");
                container.addChild((Block)this.templateManager.executeNoException("security/requiredrights/missingRequiredRightWarning.vm"));
            }
            return container;
        }
        return new CompositeBlock();
    }

    private Optional<RequiredRightChangeSuggestion> getDefinitelyMissingRequiredRight(XWikiContext context) {
        DocumentReference documentReference = context.getDoc().getDocumentReference();
        try {
            Optional requiredRights = this.documentRequiredRightsManager.getRequiredRights(documentReference);
            if (requiredRights.isPresent() && ((DocumentRequiredRights)requiredRights.get()).enforce()) {
                List analysisResults = this.requiredRightAnalyzer.analyze((Object)documentReference);
                return this.suggestionManager.getSuggestedOperations(documentReference, (DocumentRequiredRights)requiredRights.get(), analysisResults).stream().filter(changeSuggestion -> changeSuggestion.increasesRights() && !changeSuggestion.requiresManualReview()).findFirst();
            }
        }
        catch (Exception e) {
            this.logger.warn("Error getting or analyzing required rights for document [{}], root cause: [{}]", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return Optional.empty();
    }

    public String getExtensionPointId() {
        return "org.xwiki.platform.template.content.header.after";
    }

    public String getId() {
        return ROLE_HINT;
    }

    public Map<String, String> getParameters() {
        return Map.of();
    }
}

