/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.rest.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AbstractLocalizedEntityReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.rest.internal.AvailableRightsManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.requiredrights.rest.model.jaxb.AvailableRight;
import org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRequiredRight;
import org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRightsAnalysisResult;
import org.xwiki.security.requiredrights.rest.model.jaxb.ObjectFactory;

@Component(roles={RequiredRightsObjectConverter.class})
@Singleton
public class RequiredRightsObjectConverter {
    @Inject
    @Named(value="html/5.0")
    private BlockRenderer htmlRenderer;
    @Inject
    @Named(value="withtype")
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private AvailableRightsManager availableRightsManager;
    private final ObjectFactory factory = new ObjectFactory();

    public DocumentRightsAnalysisResult toDocumentRightsAnalysisResult(DocumentRequiredRights currentRights, List<RequiredRightAnalysisResult> analysisResults, DocumentReference documentReference) {
        org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRequiredRights jaxbDocumentRights = this.convertDocumentRequiredRights(currentRights);
        List<AvailableRight> availableRights = this.availableRightsManager.computeAvailableRights(analysisResults, documentReference);
        List<org.xwiki.security.requiredrights.rest.model.jaxb.RequiredRightAnalysisResult> jaxbAnalysisResults = this.convertRequiredRightAnalysisResults(analysisResults);
        return this.factory.createDocumentRightsAnalysisResult().withAnalysisResults(jaxbAnalysisResults).withCurrentRights(jaxbDocumentRights).withAvailableRights(availableRights);
    }

    private List<org.xwiki.security.requiredrights.rest.model.jaxb.RequiredRightAnalysisResult> convertRequiredRightAnalysisResults(List<RequiredRightAnalysisResult> analysisResults) {
        return analysisResults.stream().map(analysisResult -> {
            AbstractLocalizedEntityReference localizedEntityReference;
            String summaryHTML = this.getHTML(analysisResult.getSummaryMessage());
            String detailsHTML = this.getHTML(analysisResult.getDetailedMessage());
            EntityReference patt4585$temp = analysisResult.getEntityReference();
            String locale = patt4585$temp instanceof AbstractLocalizedEntityReference && (localizedEntityReference = (AbstractLocalizedEntityReference)patt4585$temp).getLocale() != null ? localizedEntityReference.getLocale().toString() : null;
            return this.factory.createRequiredRightAnalysisResult().withSummaryMessageHTML(summaryHTML).withDetailedMessageHTML(detailsHTML).withEntityReference((String)this.entityReferenceSerializer.serialize(analysisResult.getEntityReference(), new Object[0])).withLocale(locale).withRequiredRights(analysisResult.getRequiredRights().stream().map(this::mapRequiredRight).toList());
        }).toList();
    }

    public org.xwiki.security.requiredrights.rest.model.jaxb.DocumentRequiredRights convertDocumentRequiredRights(DocumentRequiredRights currentRights) {
        return this.factory.createDocumentRequiredRights().withEnforce(currentRights.enforce()).withRights(currentRights.rights().stream().map(this::mapDocumentRight).toList());
    }

    private DocumentRequiredRight mapDocumentRight(org.xwiki.security.authorization.requiredrights.DocumentRequiredRight right) {
        if (right == null) {
            return null;
        }
        return this.factory.createDocumentRequiredRight().withRight(right.right().toString()).withScope(right.scope() != null ? right.scope().toString() : null);
    }

    private org.xwiki.security.requiredrights.rest.model.jaxb.RequiredRight mapRequiredRight(RequiredRight right) {
        return this.factory.createRequiredRight().withRight(right.getRight().toString()).withEntityType(right.getEntityType() != null ? right.getEntityType().toString() : null).withManualReviewNeeded(right.isManualReviewNeeded());
    }

    private String getHTML(Block block) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.htmlRenderer.render(block, (WikiPrinter)printer);
        return printer.toString();
    }
}

