/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.rest.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRight;
import org.xwiki.security.requiredrights.rest.model.jaxb.AvailableRight;
import org.xwiki.security.requiredrights.rest.model.jaxb.ObjectFactory;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component(roles={AvailableRightsManager.class})
@Singleton
public class AvailableRightsManager {
    private static final List<DocumentRequiredRight> CONSIDERED_RIGHTS = List.of(new DocumentRequiredRight(null, EntityType.DOCUMENT), new DocumentRequiredRight(Right.SCRIPT, EntityType.DOCUMENT), new DocumentRequiredRight(Right.ADMIN, EntityType.WIKI), new DocumentRequiredRight(Right.PROGRAM, null));
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceSerializer;
    @Inject
    private ContextualLocalizationManager localizationManager;
    private final ObjectFactory factory = new ObjectFactory();

    public List<AvailableRight> computeAvailableRights(List<RequiredRightAnalysisResult> analysisResults, DocumentReference documentReference) {
        int maximumRequiredRight = 0;
        HashSet<Integer> maybeRequiredRights = new HashSet<Integer>();
        for (RequiredRightAnalysisResult analysisResult : analysisResults) {
            for (RequiredRight requiredRight : analysisResult.getRequiredRights()) {
                int index = AvailableRightsManager.getIndexInConsideredRights(requiredRight);
                if (index == -1) continue;
                if (requiredRight.isManualReviewNeeded()) {
                    maybeRequiredRights.add(index);
                    continue;
                }
                maximumRequiredRight = Math.max(maximumRequiredRight, index);
            }
        }
        int finalMaximumRequiredRight = maximumRequiredRight;
        maybeRequiredRights.removeIf(maybeIndex -> maybeIndex <= finalMaximumRequiredRight);
        DocumentReference userReference = (DocumentReference)this.userReferenceSerializer.serialize((UserReference)CurrentUserReference.INSTANCE);
        boolean hasEdit = this.authorizationManager.hasAccess(Right.EDIT, userReference, (EntityReference)documentReference);
        ArrayList<AvailableRight> availableRights = new ArrayList<AvailableRight>(CONSIDERED_RIGHTS.size());
        for (int i = 0; i < CONSIDERED_RIGHTS.size(); ++i) {
            DocumentRequiredRight consideredRight = CONSIDERED_RIGHTS.get(i);
            boolean maybeRequired = maybeRequiredRights.contains(i);
            boolean hasRight = hasEdit && (consideredRight.right() == null || this.authorizationManager.hasAccess(consideredRight.right(), userReference, documentReference.extractReference(consideredRight.scope())));
            availableRights.add(this.factory.createAvailableRight().withRight(Objects.toString(consideredRight.right(), "")).withScope(Objects.toString(consideredRight.scope(), null)).withDefinitelyRequiredRight(i == maximumRequiredRight).withMaybeRequiredRight(maybeRequired).withHasRight(hasRight).withDisplayName(this.getDisplayName(consideredRight.right())));
        }
        return availableRights;
    }

    private String getDisplayName(Right right) {
        String translationKey = "security.requiredrights.rest.right." + (right == null ? "none" : right.getName());
        return this.localizationManager.getTranslationPlain(translationKey, new Object[0]);
    }

    private static int getIndexInConsideredRights(RequiredRight requiredRight) {
        int index = -1;
        for (int i = 0; i < CONSIDERED_RIGHTS.size(); ++i) {
            DocumentRequiredRight consideredRight = CONSIDERED_RIGHTS.get(i);
            if (consideredRight.right() != requiredRight.getRight() || consideredRight.scope() != requiredRight.getEntityType()) continue;
            index = i;
            break;
        }
        return index;
    }
}

