/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.realtime.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.xwiki.model.validation.edit.EditConfirmationCheckerResult;
import org.xwiki.model.validation.edit.XWikiDocumentLockEditConfirmationChecker;
import org.xwiki.realtime.internal.RealtimeSessionManager;

@Singleton
@Named(value="documentLock")
public class XWikiRealtimeDocumentLockEditConfirmationChecker
extends XWikiDocumentLockEditConfirmationChecker {
    static final String XWIKI_DOCUMENT_LOCK_COMPONENT_NAME = "documentLock";
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;
    @Inject
    private RealtimeSessionManager realtimeSessionManager;

    Optional<EditConfirmationCheckerResult> parentCheck() {
        return super.check();
    }

    public Optional<EditConfirmationCheckerResult> check() {
        XWikiContext context = (XWikiContext)this.xwikiContextProvider.get();
        XWikiDocument tdoc = (XWikiDocument)context.get((Object)"tdoc");
        if (this.realtimeSessionManager.canJoinSession(tdoc.getDocumentReference(), tdoc.getRealLocale())) {
            return Optional.empty();
        }
        return this.parentCheck();
    }
}

