/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.script;

import jakarta.inject.Inject;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.netflux.EntityChannel;
import org.xwiki.netflux.EntityChannelStore;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
@Named(value="netflux")
public class NetfluxScriptService
implements ScriptService {
    @Inject
    private EntityChannelStore channelStore;
    @Inject
    private ContextualAuthorizationManager authorization;

    public List<EntityChannel> getChannels(EntityReference entityReference) {
        if (this.authorization.hasAccess(Right.EDIT, entityReference)) {
            return this.channelStore.getChannels(entityReference);
        }
        return null;
    }

    public List<EntityChannel> getChannels(EntityReference entityReference, List<String> pathPrefix) {
        if (this.authorization.hasAccess(Right.EDIT, entityReference)) {
            return this.channelStore.getChannels(entityReference, pathPrefix);
        }
        return null;
    }

    public EntityChannel getChannel(EntityReference entityReference, List<String> path) {
        if (this.authorization.hasAccess(Right.EDIT, entityReference)) {
            return this.channelStore.getChannel(entityReference, path).orElse(null);
        }
        return null;
    }

    public EntityChannel createChannel(EntityReference entityReference, List<String> path) {
        if (this.authorization.hasAccess(Right.EDIT, entityReference)) {
            return this.channelStore.createChannel(entityReference, path);
        }
        return null;
    }
}

