/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.netflux.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.netflux.EntityChannel;
import org.xwiki.netflux.EntityChannelStore;
import org.xwiki.netflux.internal.Channel;
import org.xwiki.netflux.internal.ChannelStore;

@Component
@Singleton
public class DefaultEntityChannelStore
implements EntityChannelStore {
    @Inject
    private ChannelStore channelStore;
    private final Map<EntityReference, List<EntityChannel>> entityChannels = new ConcurrentHashMap<EntityReference, List<EntityChannel>>();

    @Override
    public List<EntityChannel> getChannels(EntityReference entityReference) {
        List<EntityChannel> channels = this.entityChannels.get(entityReference);
        if (channels != null) {
            this.channelStore.prune();
            List availableChannels = channels.stream().filter(this::hasRawChannel).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
            if (availableChannels.isEmpty()) {
                this.entityChannels.remove(entityReference);
            } else {
                this.entityChannels.put(entityReference, availableChannels);
                return Collections.unmodifiableList(availableChannels);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized EntityChannel createChannel(EntityReference entityReference, List<String> path) {
        Optional<EntityChannel> existingChannel = this.getChannel(entityReference, path);
        if (existingChannel.isPresent()) {
            return existingChannel.get();
        }
        EntityChannel channel = new EntityChannel(entityReference, path, this.channelStore.create().getKey());
        List channels = this.entityChannels.computeIfAbsent(entityReference, key -> new CopyOnWriteArrayList());
        channels.add(channel);
        this.channelStore.askBotsToJoin(this.channelStore.get(channel.getKey()));
        return channel;
    }

    @Override
    public Optional<EntityChannel> getChannel(String key) {
        return this.entityChannels.values().stream().flatMap(Collection::stream).filter(channel -> Objects.equals(channel.getKey(), key)).filter(this::hasRawChannel).findFirst();
    }

    private boolean hasRawChannel(EntityChannel channel) {
        Channel rawChannel = this.channelStore.get(channel.getKey());
        if (rawChannel != null) {
            channel.setUserCount(rawChannel.getConnectedUsers().size());
            return true;
        }
        return false;
    }
}

