/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.like.script;

import com.xpn.xwiki.XWikiContext;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.like.LikeConfiguration;
import org.xwiki.like.LikeException;
import org.xwiki.like.LikeManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Singleton
@Named(value="like")
public class LikeScriptService
implements ScriptService {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private LikeManager likeManager;
    @Inject
    private LikeConfiguration likeConfiguration;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    @Inject
    private Logger logger;

    private Right getLikeRight() {
        return this.likeManager.getLikeRight();
    }

    public boolean isAuthorized(EntityReference entityReference) {
        DocumentReference userReference = ((XWikiContext)this.contextProvider.get()).getUserReference();
        return userReference != null && this.authorizationManager.hasAccess(this.getLikeRight(), userReference, entityReference);
    }

    public boolean displayButton(EntityReference entityReference) {
        return this.likeConfiguration.isEnabled() && (this.likeConfiguration.alwaysDisplayButton() || this.isAuthorized(entityReference));
    }

    public boolean isEnabled() {
        return this.likeConfiguration.isEnabled();
    }

    public Optional<Long> like(EntityReference entityReference) {
        XWikiContext xWikiContext = (XWikiContext)this.contextProvider.get();
        DocumentReference currentUser = xWikiContext.getUserReference();
        if (entityReference instanceof DocumentReference) {
            DocumentReference documentReference = (DocumentReference)entityReference;
            if (this.isAuthorized((EntityReference)documentReference)) {
                UserReference userReference = this.userReferenceResolver.resolve((Object)currentUser, new Object[0]);
                try {
                    return Optional.of(this.likeManager.saveLike(userReference, (EntityReference)documentReference));
                }
                catch (LikeException e) {
                    this.logger.warn("Error while liking [{}] by [{}]", new Object[]{documentReference, currentUser, ExceptionUtils.getRootCause((Throwable)e)});
                }
            } else {
                this.logger.warn("[{}] is not authorized to like [{}].", (Object)currentUser, (Object)documentReference);
            }
        } else {
            this.logger.warn("Like is only implemented for document for now. (Called with [{}])", (Object)entityReference);
        }
        return Optional.empty();
    }

    public Optional<Long> unlike(EntityReference entityReference) {
        XWikiContext xWikiContext = (XWikiContext)this.contextProvider.get();
        DocumentReference currentUser = xWikiContext.getUserReference();
        if (entityReference instanceof DocumentReference) {
            DocumentReference documentReference = (DocumentReference)entityReference;
            if (this.isAuthorized((EntityReference)documentReference)) {
                UserReference userReference = this.userReferenceResolver.resolve((Object)currentUser, new Object[0]);
                try {
                    this.likeManager.removeLike(userReference, entityReference);
                    return Optional.of(this.likeManager.getEntityLikes(entityReference));
                }
                catch (LikeException e) {
                    this.logger.warn("Error while unliking [{}] by [{}]", new Object[]{documentReference, currentUser, ExceptionUtils.getRootCause((Throwable)e)});
                }
            } else {
                this.logger.warn("[{}] is not authorized to unlike [{}].", (Object)currentUser, (Object)documentReference);
            }
        } else {
            this.logger.warn("Unlike is only implemented for document for now. (Called with [{}])", (Object)entityReference);
        }
        return Optional.empty();
    }

    public Optional<Long> getLikes(EntityReference entityReference) {
        try {
            return Optional.of(this.likeManager.getEntityLikes(entityReference));
        }
        catch (LikeException e) {
            this.logger.warn("Error while getting like information for [{}]", (Object)entityReference, (Object)ExceptionUtils.getRootCause((Throwable)e));
            return Optional.empty();
        }
    }

    public List<EntityReference> getUserLikes(UserReference userReference, int offset, int limit) {
        try {
            return this.likeManager.getUserLikes(userReference, offset, limit);
        }
        catch (LikeException e) {
            this.logger.warn("Error while retrieving likes for user [{}]", (Object)userReference, (Object)ExceptionUtils.getRootCause((Throwable)e));
            return Collections.emptyList();
        }
    }

    public Optional<Long> countUserLikes(UserReference userReference) {
        Optional<Long> result = Optional.empty();
        try {
            result = Optional.of(this.likeManager.countUserLikes(userReference));
        }
        catch (LikeException e) {
            this.logger.warn("Error while counting likes for user [{}]", (Object)userReference, (Object)ExceptionUtils.getRootCause((Throwable)e));
        }
        return result;
    }

    public boolean isLiked(EntityReference entityReference) {
        UserReference userReference = this.userReferenceResolver.resolve((Object)((XWikiContext)this.contextProvider.get()).getUserReference(), new Object[0]);
        try {
            return this.likeManager.isLiked(userReference, entityReference);
        }
        catch (LikeException e) {
            this.logger.warn("Error while checking if [{}] is liked by [{}]", new Object[]{entityReference, userReference, ExceptionUtils.getRootCause((Throwable)e)});
            return false;
        }
    }

    public List<UserReference> getLikers(EntityReference target, int offset, int limit) {
        try {
            return this.likeManager.getLikers(target, offset, limit);
        }
        catch (LikeException e) {
            this.logger.warn("Error while checking getting likers for [{}]", (Object)target, (Object)ExceptionUtils.getRootCause((Throwable)e));
            return Collections.emptyList();
        }
    }
}

