/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.image.style.rest.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.image.style.ImageStyleConfiguration;
import org.xwiki.image.style.ImageStyleException;
import org.xwiki.image.style.ImageStyleManager;
import org.xwiki.image.style.model.ImageStyle;
import org.xwiki.image.style.rest.ImageStylesResource;
import org.xwiki.image.style.rest.model.jaxb.Style;
import org.xwiki.image.style.rest.model.jaxb.Styles;
import org.xwiki.rest.XWikiRestComponent;

@Component
@Named(value="org.xwiki.image.style.rest.internal.DefaultImageStylesResource")
@Singleton
public class DefaultImageStylesResource
implements ImageStylesResource,
XWikiRestComponent {
    @Inject
    private ImageStyleConfiguration imageStyleConfiguration;
    @Inject
    private ImageStyleManager imageStyleManager;

    @Override
    public Styles getStyles(String wikiName) throws ImageStyleException {
        Styles styles = new Styles();
        styles.getImageStyles().addAll(this.convert(this.imageStyleManager.getImageStyles(wikiName)));
        return styles;
    }

    @Override
    public Response getDefaultStyleIdentifier(String wikiName, String documentReference) throws ImageStyleException {
        String defaultStyle = this.imageStyleConfiguration.getDefaultStyle(wikiName, documentReference);
        boolean forceDefaultStyle = this.imageStyleConfiguration.getForceDefaultStyle(wikiName, documentReference);
        Response response = StringUtils.isEmpty((CharSequence)defaultStyle) ? Response.ok(Map.of()).build() : Response.ok(Map.of("defaultStyle", defaultStyle, "forceDefaultStyle", Boolean.toString(forceDefaultStyle))).build();
        return response;
    }

    private List<Style> convert(Set<ImageStyle> imageStyles) {
        return imageStyles.stream().map(this::convert).collect(Collectors.toList());
    }

    private Style convert(ImageStyle imageStyle) {
        Style style = new Style();
        style.setIdentifier(imageStyle.getIdentifier());
        style.setPrettyName(imageStyle.getPrettyName());
        style.setType(imageStyle.getType());
        style.setAdjustableSize(imageStyle.getAdjustableSize());
        style.setDefaultWidth(imageStyle.getDefaultWidth());
        style.setDefaultHeight(imageStyle.getDefaultHeight());
        style.setAdjustableBorder(imageStyle.getAdjustableBorder());
        style.setDefaultBorder(imageStyle.getDefaultBorder());
        style.setAdjustableAlignment(imageStyle.getAdjustableAlignment());
        style.setDefaultAlignment(imageStyle.getDefaultAlignment());
        style.setAdjustableTextWrap(imageStyle.getAdjustableTextWrap());
        style.setDefaultTextWrap(imageStyle.getDefaultTextWrap());
        return style;
    }
}

