/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.image.style.internal.rendering;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.chaining.EventType;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.LookaheadChainingListener;
import org.xwiki.rendering.listener.reference.ResourceReference;

abstract class AbstractCaptionedImageChainingListener
extends LookaheadChainingListener {
    static final String DATA_XWIKI_IMAGE_STYLE_TEXT_WRAP = "data-xwiki-image-style-text-wrap";
    static final String WIDTH_PROPERTY = "width";
    static final String STYLE_PROPERTY = "style";
    static final String STYLE_SEPARATOR = ";";
    static final String DATA_XWIKI_IMAGE_STYLE = "data-xwiki-image-style";
    static final String DATA_XWIKI_IMAGE_STYLE_ALIGNMENT = "data-xwiki-image-style-alignment";
    static final String DATA_XWIKI_IMAGE_STYLE_BORDER = "data-xwiki-image-style-border";
    protected final Deque<Map<String, String>> figureParametersQueue = new ArrayDeque<Map<String, String>>();

    protected AbstractCaptionedImageChainingListener(ListenerChain listenerChain) {
        super(listenerChain, 2);
    }

    public void beginFigure(Map<String, String> parameters) {
        this.figureParametersQueue.push(parameters);
        super.beginFigure(parameters);
    }

    public void onImage(ResourceReference reference, boolean freestanding, String id, Map<String, String> parameters) {
        Object[] eventParameters;
        QueueListener.Event figureEvent = this.getPreviousFigureEvent();
        if (figureEvent != null && (eventParameters = figureEvent.eventParameters).length == 1 && eventParameters[0] instanceof Map) {
            Map<String, String> figureParameters = this.figureParametersQueue.pop();
            Map<String, String> updatedFigureParameters = this.updateFigureParameters(figureParameters, parameters);
            this.figureParametersQueue.push(updatedFigureParameters);
            eventParameters[0] = updatedFigureParameters;
        }
        super.onImage(reference, freestanding, id, parameters);
    }

    public void endFigure(Map<String, String> parameters) {
        super.endFigure(this.figureParametersQueue.pop());
    }

    protected abstract Map<String, String> updateFigureParameters(Map<String, String> var1, Map<String, String> var2);

    private QueueListener.Event getPreviousFigureEvent() {
        QueueListener.Event result = null;
        QueueListener.Event candidate = (QueueListener.Event)this.getPreviousEvents().peekLast();
        if (candidate != null && candidate.eventType == EventType.BEGIN_LINK) {
            result = candidate;
            candidate = (QueueListener.Event)this.getPreviousEvents().get(this.getPreviousEvents().size() - 2);
        }
        if (candidate != null && candidate.eventType == EventType.BEGIN_FIGURE) {
            result = candidate;
        }
        return result;
    }
}

