/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.image.style.internal.configuration.source;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.Locale;
import org.xwiki.configuration.internal.AbstractDocumentConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.SpaceReference;

public abstract class AbstractXClassConfigurationSource
extends AbstractDocumentConfigurationSource {
    protected String getCacheKeyPrefix() {
        DocumentReference currentDocumentReference = this.getDocumentReference();
        if (currentDocumentReference != null) {
            return (String)this.referenceSerializer.serialize(currentDocumentReference.getParent(), new Object[0]);
        }
        return null;
    }

    protected DocumentReference getDocumentReference() {
        return new DocumentReference(this.getClassReference().getName(), new SpaceReference(this.getClassReference().getParent(), (EntityReference)this.getCurrentWikiReference()));
    }

    protected BaseObject getBaseObject(String language) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            DocumentReference documentReference = this.getFailsafeDocumentReference();
            LocalDocumentReference classReference = this.getFailsafeClassReference();
            if (documentReference != null && classReference != null) {
                XWikiDocument document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
                return this.getBaseObject(document, language);
            }
        }
        return null;
    }

    protected BaseObject getBaseObject(XWikiDocument document, String language) {
        if (language != null) {
            return document.getXObject((EntityReference)this.getClassReference(), "default_language", language, true);
        }
        return document.getXObject((EntityReference)this.getClassReference());
    }

    protected BaseObject getBaseObject() throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (xcontext != null && xcontext.getWiki() != null) {
            DocumentReference documentReference = this.getFailsafeDocumentReference();
            LocalDocumentReference classReference = this.getFailsafeClassReference();
            if (documentReference != null && classReference != null) {
                XWikiDocument document = xcontext.getWiki().getDocument(this.getDocumentReference(), xcontext);
                BaseObject object = this.getBaseObject(document, this.safeGetLanguage(xcontext));
                if (object != null) {
                    return object;
                }
                return document.getXObject((EntityReference)classReference);
            }
        }
        return null;
    }

    protected Object getBaseProperty(String propertyName, String language, boolean text) throws XWikiException {
        BaseObject baseObject = this.getBaseObject(language);
        if (baseObject != null) {
            BaseProperty property = (BaseProperty)baseObject.getField(propertyName);
            if (property != null) {
                if (text) {
                    return property.toText();
                }
                return property.getValue();
            }
            return null;
        }
        return null;
    }

    protected Object getBaseProperty(String propertyName, boolean text) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        Object propertyValue = this.getBaseProperty(propertyName, this.safeGetLanguage(xcontext), text);
        if (propertyValue == null || this.isEmpty(propertyValue)) {
            propertyValue = this.getBaseProperty(propertyName, null, text);
        }
        if (this.isEmpty(propertyValue)) {
            propertyValue = null;
        }
        return propertyValue;
    }

    private String safeGetLanguage(XWikiContext xcontext) {
        Locale locale = xcontext.getLocale();
        if (locale != null) {
            return locale.getLanguage();
        }
        return null;
    }
}

