/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.image.style.internal.configuration;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.image.style.ImageStyleConfiguration;
import org.xwiki.image.style.ImageStyleException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Singleton
public class DefaultImageStyleConfiguration
implements ImageStyleConfiguration {
    @Inject
    @Named(value="image.style")
    private ConfigurationSource configurationSource;
    @Inject
    private ExecutionContextManager contextManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    @Override
    public String getDefaultStyle(String wikiName, String documentReference) throws ImageStyleException {
        return (String)this.getConfiguration(wikiName, documentReference, "defaultStyle");
    }

    @Override
    public boolean getForceDefaultStyle(String wikiName, String documentReference) throws ImageStyleException {
        Integer forceDefaultStyle = (Integer)this.getConfiguration(wikiName, documentReference, "forceDefaultStyle");
        return forceDefaultStyle != null && forceDefaultStyle == 1;
    }

    private <T> T getConfiguration(String wikiName, String documentReference, String forceDefaultStyle) throws ImageStyleException {
        try {
            this.contextManager.pushContext(new ExecutionContext(), false);
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            context.setWikiId(wikiName);
            if (documentReference != null) {
                DocumentReference resolvedDocumentReference = this.documentReferenceResolver.resolve((Object)documentReference, new Object[]{context});
                XWikiDocument doc = context.getWiki().getDocument(resolvedDocumentReference, context);
                context.setDoc(doc);
            }
            Object object = this.configurationSource.getProperty(forceDefaultStyle);
            return (T)object;
        }
        catch (ExecutionContextException e) {
            throw new ImageStyleException("Failed to initialize the execution context", e);
        }
        catch (XWikiException e) {
            throw new ImageStyleException(String.format("Failed to resolved document [%s]", documentReference), e);
        }
        finally {
            this.contextManager.popContext();
        }
    }
}

