/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.image.style.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.image.style.ImageStyleException;
import org.xwiki.image.style.ImageStyleManager;
import org.xwiki.image.style.model.ImageStyle;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultImageStyleManager
implements ImageStyleManager {
    private static final LocalDocumentReference IMAGE_STYPE_CLASS_REFERENCE = new LocalDocumentReference(List.of("Image", "Style", "Code"), "ImageStyleClass");
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ExecutionContextManager contextManager;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private Logger logger;

    @Override
    public Set<ImageStyle> getImageStyles(String wikiName) throws ImageStyleException {
        try {
            this.contextManager.pushContext(new ExecutionContext(), true);
            ((XWikiContext)this.xcontextProvider.get()).setWikiId(wikiName);
            Set<ImageStyle> set = this.queryManager.createQuery("select doc.fullName from Document doc, doc.object(Image.Style.Code.ImageStyleClass) as obj where doc.space = 'Image.Style.Code.ImageStyles'", "xwql").setWiki(wikiName).execute().stream().map(this::convert).filter(Objects::nonNull).collect(Collectors.toSet());
            return set;
        }
        catch (QueryException e) {
            throw new ImageStyleException("Failed to retrieve the list of image styles", e);
        }
        catch (ExecutionContextException e) {
            throw new ImageStyleException(String.format("Failed to initialize a context for wiki [%s]", wikiName), e);
        }
        finally {
            this.contextManager.popContext();
        }
    }

    private ImageStyle convert(String documentReference) {
        try {
            XWikiContext context = (XWikiContext)this.xcontextProvider.get();
            DocumentReference resolve = this.documentReferenceResolver.resolve((Object)documentReference, new Object[0]);
            XWikiDocument document = context.getWiki().getDocument(resolve, context);
            BaseObject xObject = document.getXObject((EntityReference)IMAGE_STYPE_CLASS_REFERENCE);
            return new ImageStyle().setIdentifier(document.getDocumentReference().getName()).setPrettyName(xObject.getStringValue("prettyName")).setType(xObject.getStringValue("type")).setAdjustableSize(this.getBoolean(xObject, "adjustableSize")).setDefaultWidth(this.getLongIfNotEmpty(xObject, "defaultWidth")).setDefaultHeight(this.getLongIfNotEmpty(xObject, "defaultHeight")).setAdjustableBorder(this.getBoolean(xObject, "adjustableBorder")).setDefaultBorder(this.getBoolean(xObject, "defaultBorder")).setAdjustableAlignment(this.getBoolean(xObject, "adjustableAlignment")).setDefaultAlignment(xObject.getStringValue("defaultAlignment")).setAdjustableTextWrap(this.getBoolean(xObject, "adjustableTextWrap")).setDefaultTextWrap(this.getBoolean(xObject, "defaultTextWrap"));
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to resolve document reference [{}]. Cause: [{}].", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private boolean getBoolean(BaseObject xObject, String propertyName) {
        return 1L == xObject.getLongValue(propertyName);
    }

    private Long getLongIfNotEmpty(BaseObject xObject, String propertyName) {
        if (Objects.equals(xObject.getStringValue(propertyName), "")) {
            return null;
        }
        return xObject.getLongValue(propertyName);
    }
}

