/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.picker.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.attachment.picker.AttachmentGalleryPickerMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;

@Component
@Named(value="attachmentGalleryPicker")
@Singleton
public class AttachmentGalleryPickerMacro
extends AbstractMacro<AttachmentGalleryPickerMacroParameters> {
    private static final String BLOCK_PARAM_ID = "id";
    private static final String BLOCK_PARAM_CLASS = "class";
    private static final String ATTACHMENT_GALLERY_PICKER_CLASSES = "attachmentGalleryPicker";
    private static final String SKIN_RESOURCES_DOCUMENT_REFERENCE = "Attachment.Picker.Code.AttachmentGalleryPicker";
    @Inject
    @Named(value="ssx")
    private SkinExtension ssx;
    @Inject
    @Named(value="jsx")
    private SkinExtension jsx;
    @Inject
    private ContextualLocalizationManager l10n;

    public AttachmentGalleryPickerMacro() {
        super("Attachment Picker", "Grid based attachment picker.", AttachmentGalleryPickerMacroParameters.class);
        this.setDefaultCategories(Set.of("Development"));
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(AttachmentGalleryPickerMacroParameters parameters, String content, MacroTransformationContext context) {
        this.jsx.use(SKIN_RESOURCES_DOCUMENT_REFERENCE);
        this.ssx.use(SKIN_RESOURCES_DOCUMENT_REFERENCE);
        HashMap<String, String> attachmentPickerParameters = new HashMap<String, String>(Map.ofEntries(Map.entry(BLOCK_PARAM_CLASS, ATTACHMENT_GALLERY_PICKER_CLASSES), Map.entry("data-xwiki-lightbox", "false"), Map.entry("data-xwiki-attachment-picker-filter", String.join((CharSequence)",", parameters.getFilter()))));
        if (parameters.getId() != null) {
            attachmentPickerParameters.put(BLOCK_PARAM_ID, parameters.getId());
        }
        if (parameters.getLimit() != null) {
            attachmentPickerParameters.put("data-xwiki-attachment-picker-limit", String.valueOf(parameters.getLimit()));
        }
        if (parameters.getTarget() != null) {
            attachmentPickerParameters.put("data-xwiki-attachment-picker-target", parameters.getTarget());
        }
        return List.of(new GroupBlock(List.of(new GroupBlock(List.of(), Map.of(BLOCK_PARAM_CLASS, "attachmentPickerSearch")), new GroupBlock(Map.of(BLOCK_PARAM_CLASS, "attachmentPickerResults")), new GroupBlock(List.of(this.l10n.getTranslation("attachment.picker.macro.notResult.message").render(new Object[0])), Map.of(BLOCK_PARAM_CLASS, "attachmentPickerNoResults hidden box warningmessage")), new GroupBlock(List.of(this.l10n.getTranslation("attachment.picker.macro.globalSelection.message").render(new Object[0])), Map.of(BLOCK_PARAM_CLASS, "attachmentPickerGlobalSelection hidden box warningmessage"))), attachmentPickerParameters));
    }
}

